/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.stm653.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.AttachmentRefOrValue;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.common.model.service.ServiceSpecificationRef;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.stm653.model.CharacteristicSpecification;
import org.etsi.osl.tmf.stm653.model.ConstraintRef;
import org.etsi.osl.tmf.stm653.model.EntitySpecificationRelationship;
import org.etsi.osl.tmf.stm653.model.ServiceTestSpecRelationship;
import org.etsi.osl.tmf.stm653.model.TargetEntitySchema;
import org.etsi.osl.tmf.stm653.model.TestMeasureDefinition;
import org.springframework.validation.annotation.Validated;

@Schema(description="The service test specification describes the service test in terms of parameters to be configured and  measures to be taken.")
@Validated
@Entity(name="STMServiceTestSpec")
@Table(name="STMServiceTestSpec")
public class ServiceTestSpecification
extends BaseEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="isBundle")
    private Boolean isBundle = null;
    @JsonProperty(value="version")
    private String version = null;
    @JsonProperty(value="attachment")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<AttachmentRefOrValue> attachment = new HashSet<AttachmentRefOrValue>();
    @JsonProperty(value="constraint")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ConstraintRef> constraint = new HashSet<ConstraintRef>();
    @JsonProperty(value="entitySpecRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<EntitySpecificationRelationship> entitySpecRelationship = new HashSet<EntitySpecificationRelationship>();
    @JsonProperty(value="relatedParty")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<RelatedParty> relatedParty = new HashSet<RelatedParty>();
    @JsonProperty(value="relatedServiceSpecification")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ServiceSpecificationRef> relatedServiceSpecification = new HashSet<ServiceSpecificationRef>();
    @JsonProperty(value="serviceTestSpecRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ServiceTestSpecRelationship> serviceTestSpecRelationship = new HashSet<ServiceTestSpecRelationship>();
    @JsonProperty(value="specCharacteristic")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<CharacteristicSpecification> specCharacteristic = new HashSet<CharacteristicSpecification>();
    @JsonProperty(value="targetEntitySchema")
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private TargetEntitySchema targetEntitySchema = null;
    @JsonProperty(value="testMeasureDefinition")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<TestMeasureDefinition> testMeasureDefinition = new HashSet<TestMeasureDefinition>();

    public String getId() {
        if (this.uuid != null) {
            this.id = this.uuid;
        }
        return this.id;
    }

    @Override
    public ServiceTestSpecification version(String version) {
        this.version = version;
        return this;
    }

    @Override
    @Schema(description="Entity specification version")
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    public ServiceTestSpecification attachment(Set<AttachmentRefOrValue> attachment) {
        this.attachment = attachment;
        return this;
    }

    public ServiceTestSpecification addAttachmentItem(AttachmentRefOrValue attachmentItem) {
        if (this.attachment == null) {
            this.attachment = new HashSet<AttachmentRefOrValue>();
        }
        this.attachment.add(attachmentItem);
        return this;
    }

    @Schema(description="Attachments that may be of relevance to this specification, such as picture, document, media")
    @Valid
    public Set<AttachmentRefOrValue> getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Set<AttachmentRefOrValue> attachment) {
        this.attachment = attachment;
    }

    public ServiceTestSpecification constraint(Set<ConstraintRef> constraint) {
        this.constraint = constraint;
        return this;
    }

    public ServiceTestSpecification addConstraintItem(ConstraintRef constraintItem) {
        if (this.constraint == null) {
            this.constraint = new HashSet<ConstraintRef>();
        }
        this.constraint.add(constraintItem);
        return this;
    }

    @Schema(description="This is a list of constraint references applied to this specification")
    @Valid
    public Set<ConstraintRef> getConstraint() {
        return this.constraint;
    }

    public void setConstraint(Set<ConstraintRef> constraint) {
        this.constraint = constraint;
    }

    public ServiceTestSpecification entitySpecRelationship(Set<EntitySpecificationRelationship> entitySpecRelationship) {
        this.entitySpecRelationship = entitySpecRelationship;
        return this;
    }

    public ServiceTestSpecification addEntitySpecRelationshipItem(EntitySpecificationRelationship entitySpecRelationshipItem) {
        if (this.entitySpecRelationship == null) {
            this.entitySpecRelationship = new HashSet<EntitySpecificationRelationship>();
        }
        this.entitySpecRelationship.add(entitySpecRelationshipItem);
        return this;
    }

    @Schema(description="Relationship to another entity specification, might be dependency, substitution, etc.")
    @Valid
    public Set<EntitySpecificationRelationship> getEntitySpecRelationship() {
        return this.entitySpecRelationship;
    }

    public void setEntitySpecRelationship(Set<EntitySpecificationRelationship> entitySpecRelationship) {
        this.entitySpecRelationship = entitySpecRelationship;
    }

    public ServiceTestSpecification relatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ServiceTestSpecification addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new HashSet<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="Parties who manage or otherwise have an interest in this entity specification")
    @Valid
    public Set<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ServiceTestSpecification isBundle(Boolean isBundle) {
        this.isBundle = isBundle;
        return this;
    }

    @Schema(description="isBundle determines whether an EntitySpecification represents a single EntitySpecification (false), or a bundle of EntitySpecifications (true).")
    public Boolean isIsBundle() {
        return this.isBundle;
    }

    public void setIsBundle(Boolean isBundle) {
        this.isBundle = isBundle;
    }

    public ServiceTestSpecification relatedServiceSpecification(Set<ServiceSpecificationRef> relatedServiceSpecification) {
        this.relatedServiceSpecification = relatedServiceSpecification;
        return this;
    }

    public ServiceTestSpecification addRelatedServiceSpecificationItem(ServiceSpecificationRef relatedServiceSpecificationItem) {
        if (this.relatedServiceSpecification == null) {
            this.relatedServiceSpecification = new HashSet<ServiceSpecificationRef>();
        }
        this.relatedServiceSpecification.add(relatedServiceSpecificationItem);
        return this;
    }

    @Schema(description="The related service specification may relate to more than one service specification.")
    @Valid
    public Set<ServiceSpecificationRef> getRelatedServiceSpecification() {
        return this.relatedServiceSpecification;
    }

    public void setRelatedServiceSpecification(Set<ServiceSpecificationRef> relatedServiceSpecification) {
        this.relatedServiceSpecification = relatedServiceSpecification;
    }

    public ServiceTestSpecification serviceTestSpecRelationship(Set<ServiceTestSpecRelationship> serviceTestSpecRelationship) {
        this.serviceTestSpecRelationship = serviceTestSpecRelationship;
        return this;
    }

    public ServiceTestSpecification addServiceTestSpecRelationshipItem(ServiceTestSpecRelationship serviceTestSpecRelationshipItem) {
        if (this.serviceTestSpecRelationship == null) {
            this.serviceTestSpecRelationship = new HashSet<ServiceTestSpecRelationship>();
        }
        this.serviceTestSpecRelationship.add(serviceTestSpecRelationshipItem);
        return this;
    }

    @Schema(description="A list of service test specifications related to this specification e.g. dependency, substitution")
    @Valid
    public Set<ServiceTestSpecRelationship> getServiceTestSpecRelationship() {
        return this.serviceTestSpecRelationship;
    }

    public void setServiceTestSpecRelationship(Set<ServiceTestSpecRelationship> serviceTestSpecRelationship) {
        this.serviceTestSpecRelationship = serviceTestSpecRelationship;
    }

    public ServiceTestSpecification specCharacteristic(Set<CharacteristicSpecification> specCharacteristic) {
        this.specCharacteristic = specCharacteristic;
        return this;
    }

    public ServiceTestSpecification addSpecCharacteristicItem(CharacteristicSpecification specCharacteristicItem) {
        if (this.specCharacteristic == null) {
            this.specCharacteristic = new HashSet<CharacteristicSpecification>();
        }
        this.specCharacteristic.add(specCharacteristicItem);
        return this;
    }

    @Schema(description="List of characteristics that the entity can take")
    @Valid
    public Set<CharacteristicSpecification> getSpecCharacteristic() {
        return this.specCharacteristic;
    }

    public void setSpecCharacteristic(Set<CharacteristicSpecification> specCharacteristic) {
        this.specCharacteristic = specCharacteristic;
    }

    public ServiceTestSpecification targetEntitySchema(TargetEntitySchema targetEntitySchema) {
        this.targetEntitySchema = targetEntitySchema;
        return this;
    }

    @Schema(description="")
    @Valid
    public TargetEntitySchema getTargetEntitySchema() {
        return this.targetEntitySchema;
    }

    public void setTargetEntitySchema(TargetEntitySchema targetEntitySchema) {
        this.targetEntitySchema = targetEntitySchema;
    }

    public ServiceTestSpecification testMeasureDefinition(Set<TestMeasureDefinition> testMeasureDefinition) {
        this.testMeasureDefinition = testMeasureDefinition;
        return this;
    }

    public ServiceTestSpecification addTestMeasureDefinitionItem(TestMeasureDefinition testMeasureDefinitionItem) {
        if (this.testMeasureDefinition == null) {
            this.testMeasureDefinition = new HashSet<TestMeasureDefinition>();
        }
        this.testMeasureDefinition.add(testMeasureDefinitionItem);
        return this;
    }

    @Schema(description="A list of definitions for the measurements for the test defined by this specification")
    @Valid
    public Set<TestMeasureDefinition> getTestMeasureDefinition() {
        return this.testMeasureDefinition;
    }

    public void setTestMeasureDefinition(Set<TestMeasureDefinition> testMeasureDefinition) {
        this.testMeasureDefinition = testMeasureDefinition;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceTestSpecification serviceTestSpecification = (ServiceTestSpecification)o;
        return Objects.equals(this.id, serviceTestSpecification.id) && Objects.equals(this.href, serviceTestSpecification.href) && Objects.equals(this.description, serviceTestSpecification.description) && Objects.equals(this.isBundle, serviceTestSpecification.isBundle) && Objects.equals(this.lastUpdate, serviceTestSpecification.lastUpdate) && Objects.equals(this.lifecycleStatus, serviceTestSpecification.lifecycleStatus) && Objects.equals(this.name, serviceTestSpecification.name) && Objects.equals(this.version, serviceTestSpecification.version) && Objects.equals(this.attachment, serviceTestSpecification.attachment) && Objects.equals(this.constraint, serviceTestSpecification.constraint) && Objects.equals(this.entitySpecRelationship, serviceTestSpecification.entitySpecRelationship) && Objects.equals(this.relatedParty, serviceTestSpecification.relatedParty) && Objects.equals(this.relatedServiceSpecification, serviceTestSpecification.relatedServiceSpecification) && Objects.equals(this.serviceTestSpecRelationship, serviceTestSpecification.serviceTestSpecRelationship) && Objects.equals(this.specCharacteristic, serviceTestSpecification.specCharacteristic) && Objects.equals(this.targetEntitySchema, serviceTestSpecification.targetEntitySchema) && Objects.equals(this.testMeasureDefinition, serviceTestSpecification.testMeasureDefinition) && Objects.equals(this.validFor, serviceTestSpecification.validFor) && Objects.equals(this.baseType, serviceTestSpecification.baseType) && Objects.equals(this.schemaLocation, serviceTestSpecification.schemaLocation) && Objects.equals(this.type, serviceTestSpecification.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceTestSpecification {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    constraint: ").append(this.toIndentedString(this.constraint)).append("\n");
        sb.append("    entitySpecRelationship: ").append(this.toIndentedString(this.entitySpecRelationship)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    relatedServiceSpecification: ").append(this.toIndentedString(this.relatedServiceSpecification)).append("\n");
        sb.append("    serviceTestSpecRelationship: ").append(this.toIndentedString(this.serviceTestSpecRelationship)).append("\n");
        sb.append("    specCharacteristic: ").append(this.toIndentedString(this.specCharacteristic)).append("\n");
        sb.append("    targetEntitySchema: ").append(this.toIndentedString(this.targetEntitySchema)).append("\n");
        sb.append("    testMeasureDefinition: ").append(this.toIndentedString(this.testMeasureDefinition)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

