/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.stm653.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="A substitution, dependency or exclusivity relationship between/among service specifications.")
@Validated
@Entity(name="STMServiceTestSpecRelationship")
@Table(name="STMServiceTestSpecRelationship")
public class ServiceTestSpecRelationship
extends BaseEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="relationshipType")
    private String relationshipType = null;
    @JsonProperty(value="role")
    private String role = null;
    @JsonProperty(value="@referredType")
    private String _atReferredType = null;

    public String getId() {
        this.id = this.uuid;
        return this.uuid;
    }

    public ServiceTestSpecRelationship href(String href) {
        this.href = href;
        return this;
    }

    @Override
    @Schema(description="Hyperlink reference")
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    @Override
    public ServiceTestSpecRelationship name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="Name of the related entity.")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public ServiceTestSpecRelationship relationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @Schema(description="Type of relationship such as substitution, dependency, exclusivity")
    @NotNull
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public ServiceTestSpecRelationship role(String role) {
        this.role = role;
        return this;
    }

    @Schema(description="The association role for this service test specification")
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getAtReferredType() {
        return this._atReferredType;
    }

    public void setAtReferredType(String _atReferredType) {
        this._atReferredType = _atReferredType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceTestSpecRelationship serviceTestSpecRelationship = (ServiceTestSpecRelationship)o;
        return Objects.equals(this.id, serviceTestSpecRelationship.id) && Objects.equals(this.href, serviceTestSpecRelationship.href) && Objects.equals(this.name, serviceTestSpecRelationship.name) && Objects.equals(this.relationshipType, serviceTestSpecRelationship.relationshipType) && Objects.equals(this.role, serviceTestSpecRelationship.role) && Objects.equals(this.validFor, serviceTestSpecRelationship.validFor) && Objects.equals(this.baseType, serviceTestSpecRelationship.baseType) && Objects.equals(this.schemaLocation, serviceTestSpecRelationship.schemaLocation) && Objects.equals(this.type, serviceTestSpecRelationship.type) && Objects.equals(this._atReferredType, serviceTestSpecRelationship._atReferredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceTestSpecRelationship {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    relationshipType: ").append(this.toIndentedString(this.relationshipType)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    _atReferredType: ").append(this.toIndentedString(this._atReferredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

