/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.stm653.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.common.model.service.ServiceRef;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.stm653.model.Characteristic;
import org.etsi.osl.tmf.stm653.model.ServiceTestSpecificationRef;
import org.etsi.osl.tmf.stm653.model.TestMeasure;
import org.springframework.validation.annotation.Validated;

@Schema(description="A service test is an entity that exists for a controlled test invocation on a service. The service  test is executed according to a schedule and contains service test configuration parameters that are to be  applied at execution time, and service test measures that result.")
@Validated
@Entity(name="STMServiceTest")
@Table(name="STMServiceTest")
public class ServiceTest
extends BaseEntity {
    @JsonProperty(value="id")
    private String id = null;
    @Column(name="st_end_date_time")
    private OffsetDateTime endDateTime = null;
    @JsonProperty(value="mode")
    private String mode = null;
    @Column(name="st_start_date_time")
    private OffsetDateTime startDateTime = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="characteristic")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<Characteristic> characteristic = new HashSet<Characteristic>();
    @JsonProperty(value="relatedParty")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<RelatedParty> relatedParty = new HashSet<RelatedParty>();
    @JsonProperty(value="relatedService")
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private ServiceRef relatedService = null;
    @JsonProperty(value="testMeasure")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<TestMeasure> testMeasure = new HashSet<TestMeasure>();
    @JsonProperty(value="testSpecification")
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private ServiceTestSpecificationRef testSpecification = null;

    public String getId() {
        if (this.uuid != null) {
            this.id = this.uuid;
        }
        return this.id;
    }

    public ServiceTest href(String href) {
        this.href = href;
        return this;
    }

    @Override
    @Schema(description="Hyperlink reference")
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    @Override
    public ServiceTest description(String description) {
        this.description = description;
        return this;
    }

    @Override
    @Schema(description="Description of the service test")
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public ServiceTest endDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    @JsonProperty(value="endDateTime")
    public String getEndDateStr() {
        if (this.endDateTime != null) {
            return this.endDateTime.toString();
        }
        return null;
    }

    @Schema(description="The end date and time of the service test")
    @Valid
    public OffsetDateTime getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
    }

    public ServiceTest mode(String mode) {
        this.mode = mode;
        return this;
    }

    @Schema(description="An indication of whether the service test is running in  \"PROACTIVE\" or \"ONDEMAND\" mode")
    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    @Override
    public ServiceTest name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="The name of the service test")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public ServiceTest startDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    @Schema(description="The start date and time of the service test.")
    @Valid
    public OffsetDateTime getStartDateTime() {
        return this.startDateTime;
    }

    @JsonProperty(value="startDateTime")
    public String getStartDateStr() {
        if (this.startDateTime != null) {
            return this.startDateTime.toString();
        }
        return null;
    }

    public void setStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
    }

    public ServiceTest state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="The actual state the service test is in")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public ServiceTest characteristic(Set<Characteristic> characteristic) {
        this.characteristic = characteristic;
        return this;
    }

    public ServiceTest addCharacteristicItem(Characteristic characteristicItem) {
        if (this.characteristic == null) {
            this.characteristic = new HashSet<Characteristic>();
        }
        this.characteristic.add(characteristicItem);
        return this;
    }

    @Schema(description="List of characteristics with values that define the test run")
    @Valid
    public Set<Characteristic> getCharacteristic() {
        return this.characteristic;
    }

    public void setCharacteristic(Set<Characteristic> characteristic) {
        this.characteristic = characteristic;
    }

    public ServiceTest relatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ServiceTest addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new HashSet<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="Party related to the test")
    @Valid
    public Set<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ServiceTest relatedService(ServiceRef relatedService) {
        this.relatedService = relatedService;
        return this;
    }

    @Schema(description="")
    @Valid
    public ServiceRef getRelatedService() {
        return this.relatedService;
    }

    public void setRelatedService(ServiceRef relatedService) {
        this.relatedService = relatedService;
    }

    public ServiceTest testMeasure(Set<TestMeasure> testMeasure) {
        this.testMeasure = testMeasure;
        return this;
    }

    public ServiceTest addTestMeasureItem(TestMeasure testMeasureItem) {
        if (this.testMeasure == null) {
            this.testMeasure = new HashSet<TestMeasure>();
        }
        this.testMeasure.add(testMeasureItem);
        return this;
    }

    @Schema(description="The results of the test in terms of the measured metrics")
    @Valid
    public Set<TestMeasure> getTestMeasure() {
        return this.testMeasure;
    }

    public void setTestMeasure(Set<TestMeasure> testMeasure) {
        this.testMeasure = testMeasure;
    }

    public ServiceTest testSpecification(ServiceTestSpecificationRef testSpecification) {
        this.testSpecification = testSpecification;
        return this;
    }

    @Schema(description="")
    @Valid
    public ServiceTestSpecificationRef getTestSpecification() {
        return this.testSpecification;
    }

    public void setTestSpecification(ServiceTestSpecificationRef testSpecification) {
        this.testSpecification = testSpecification;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceTest serviceTest = (ServiceTest)o;
        return Objects.equals(this.id, serviceTest.id) && Objects.equals(this.href, serviceTest.href) && Objects.equals(this.description, serviceTest.description) && Objects.equals(this.endDateTime, serviceTest.endDateTime) && Objects.equals(this.mode, serviceTest.mode) && Objects.equals(this.name, serviceTest.name) && Objects.equals(this.startDateTime, serviceTest.startDateTime) && Objects.equals(this.state, serviceTest.state) && Objects.equals(this.characteristic, serviceTest.characteristic) && Objects.equals(this.relatedParty, serviceTest.relatedParty) && Objects.equals(this.relatedService, serviceTest.relatedService) && Objects.equals(this.testMeasure, serviceTest.testMeasure) && Objects.equals(this.testSpecification, serviceTest.testSpecification) && Objects.equals(this.validFor, serviceTest.validFor) && Objects.equals(this.baseType, serviceTest.baseType) && Objects.equals(this.schemaLocation, serviceTest.schemaLocation) && Objects.equals(this.type, serviceTest.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceTest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    endDateTime: ").append(this.toIndentedString(this.endDateTime)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    startDateTime: ").append(this.toIndentedString(this.startDateTime)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    characteristic: ").append(this.toIndentedString(this.characteristic)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    relatedService: ").append(this.toIndentedString(this.relatedService)).append("\n");
        sb.append("    testMeasure: ").append(this.toIndentedString(this.testMeasure)).append("\n");
        sb.append("    testSpecification: ").append(this.toIndentedString(this.testSpecification)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public Characteristic getCharacteristicByName(@NotNull String name) {
        for (Characteristic c : this.characteristic) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }
}

