/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.stm653.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.stm653.model.Duration;
import org.etsi.osl.tmf.stm653.model.MetricDefMeasureConsequence;
import org.springframework.validation.annotation.Validated;

@Schema(description="A MetricDefMeasureThresholdRule is a rule that defines the condition (raise or clear) to achieve to apply  consequences when a threshold is crossed or ceased to be crossed. It also defines the severity of the  raise or clear of the threshold.")
@Validated
@Entity(name="STMMetrcDefMeasrThreshRule")
@Table(name="STMMetrcDefMeasrThreshRule")
public class MetricDefMeasureThresholdRule
extends BaseRootNamedEntity {
    @JsonProperty(value="conformanceComparatorLower")
    private String conformanceComparatorLower = null;
    @JsonProperty(value="conformanceComparatorUpper")
    private String conformanceComparatorUpper = null;
    @JsonProperty(value="conformanceTargetLower")
    private String conformanceTargetLower = null;
    @JsonProperty(value="conformanceTargetUpper")
    private String conformanceTargetUpper = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="numberOfAllowedCrossing")
    private Integer numberOfAllowedCrossing = null;
    @JsonProperty(value="thresholdRuleSeverity")
    private String thresholdRuleSeverity = null;
    @JsonProperty(value="consequence")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<MetricDefMeasureConsequence> consequence = new HashSet<MetricDefMeasureConsequence>();
    @JsonProperty(value="tolerancePeriod")
    private Duration tolerancePeriod = null;

    public MetricDefMeasureThresholdRule conformanceComparatorLower(String conformanceComparatorLower) {
        this.conformanceComparatorLower = conformanceComparatorLower;
        return this;
    }

    @Schema(description="An operator that when applied on a value specifies whether a  threshold is crossed or ceased to be crossed. This operator is used to Service Test Management API REST Specification compare with the conformanceTargetLower.")
    public String getConformanceComparatorLower() {
        return this.conformanceComparatorLower;
    }

    public void setConformanceComparatorLower(String conformanceComparatorLower) {
        this.conformanceComparatorLower = conformanceComparatorLower;
    }

    public MetricDefMeasureThresholdRule conformanceComparatorUpper(String conformanceComparatorUpper) {
        this.conformanceComparatorUpper = conformanceComparatorUpper;
        return this;
    }

    @Schema(description="An operator that when applied on a value specifies whether a  threshold is crossed or ceased to be crossed. This operator is used to compare with the conformanceTargetUpper.")
    public String getConformanceComparatorUpper() {
        return this.conformanceComparatorUpper;
    }

    public void setConformanceComparatorUpper(String conformanceComparatorUpper) {
        this.conformanceComparatorUpper = conformanceComparatorUpper;
    }

    public MetricDefMeasureThresholdRule conformanceTargetLower(String conformanceTargetLower) {
        this.conformanceTargetLower = conformanceTargetLower;
        return this;
    }

    @Schema(description="A value used to determine if the threshold is crossed or ceases  to be crossed. It represents the lower limit. The value should be less than the conformanceTargetUpper. The conformance comparators should also be logically defined so as to not lead to a logically impossible condition.")
    public String getConformanceTargetLower() {
        return this.conformanceTargetLower;
    }

    public void setConformanceTargetLower(String conformanceTargetLower) {
        this.conformanceTargetLower = conformanceTargetLower;
    }

    public MetricDefMeasureThresholdRule conformanceTargetUpper(String conformanceTargetUpper) {
        this.conformanceTargetUpper = conformanceTargetUpper;
        return this;
    }

    @Schema(description="A value used to determine if the threshold is crossed or ceases  to be crossed. It represents the Upper limit. The value should be greater than the conformanceTargetLower. The conformance comparators should also be logically defined so as to not lead to a logically impossible condition.")
    public String getConformanceTargetUpper() {
        return this.conformanceTargetUpper;
    }

    public void setConformanceTargetUpper(String conformanceTargetUpper) {
        this.conformanceTargetUpper = conformanceTargetUpper;
    }

    public MetricDefMeasureThresholdRule description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description for the MetricDefMeasureThresholdRule .")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public MetricDefMeasureThresholdRule name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="Name for the MetricDefMeasureThresholdRule .")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public MetricDefMeasureThresholdRule numberOfAllowedCrossing(Integer numberOfAllowedCrossing) {
        this.numberOfAllowedCrossing = numberOfAllowedCrossing;
        return this;
    }

    @Schema(description="The number of allowed crossing occurrences in reference to the  tolerancePeriod without a consequence being initiated.")
    public Integer getNumberOfAllowedCrossing() {
        return this.numberOfAllowedCrossing;
    }

    public void setNumberOfAllowedCrossing(Integer numberOfAllowedCrossing) {
        this.numberOfAllowedCrossing = numberOfAllowedCrossing;
    }

    public MetricDefMeasureThresholdRule thresholdRuleSeverity(String thresholdRuleSeverity) {
        this.thresholdRuleSeverity = thresholdRuleSeverity;
        return this;
    }

    @Schema(description="A threshold can be generated in different severity levels. A  crossing for each level may require a different condition and possibly trigger a different consequence.")
    public String getThresholdRuleSeverity() {
        return this.thresholdRuleSeverity;
    }

    public void setThresholdRuleSeverity(String thresholdRuleSeverity) {
        this.thresholdRuleSeverity = thresholdRuleSeverity;
    }

    public MetricDefMeasureThresholdRule consequence(Set<MetricDefMeasureConsequence> consequence) {
        this.consequence = consequence;
        return this;
    }

    public MetricDefMeasureThresholdRule addConsequenceItem(MetricDefMeasureConsequence consequenceItem) {
        if (this.consequence == null) {
            this.consequence = new HashSet<MetricDefMeasureConsequence>();
        }
        this.consequence.add(consequenceItem);
        return this;
    }

    @Schema(description="A list of consequences (actions, notifications) that will arise if the threshold is crossed")
    @Valid
    public Set<MetricDefMeasureConsequence> getConsequence() {
        return this.consequence;
    }

    public void setConsequence(Set<MetricDefMeasureConsequence> consequence) {
        this.consequence = consequence;
    }

    public MetricDefMeasureThresholdRule tolerancePeriod(Duration tolerancePeriod) {
        this.tolerancePeriod = tolerancePeriod;
        return this;
    }

    @Schema(description="")
    @Valid
    public Duration getTolerancePeriod() {
        return this.tolerancePeriod;
    }

    public void setTolerancePeriod(Duration tolerancePeriod) {
        this.tolerancePeriod = tolerancePeriod;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricDefMeasureThresholdRule metricDefMeasureThresholdRule = (MetricDefMeasureThresholdRule)o;
        return Objects.equals(this.conformanceComparatorLower, metricDefMeasureThresholdRule.conformanceComparatorLower) && Objects.equals(this.conformanceComparatorUpper, metricDefMeasureThresholdRule.conformanceComparatorUpper) && Objects.equals(this.conformanceTargetLower, metricDefMeasureThresholdRule.conformanceTargetLower) && Objects.equals(this.conformanceTargetUpper, metricDefMeasureThresholdRule.conformanceTargetUpper) && Objects.equals(this.description, metricDefMeasureThresholdRule.description) && Objects.equals(this.name, metricDefMeasureThresholdRule.name) && Objects.equals(this.numberOfAllowedCrossing, metricDefMeasureThresholdRule.numberOfAllowedCrossing) && Objects.equals(this.thresholdRuleSeverity, metricDefMeasureThresholdRule.thresholdRuleSeverity) && Objects.equals(this.consequence, metricDefMeasureThresholdRule.consequence) && Objects.equals(this.tolerancePeriod, metricDefMeasureThresholdRule.tolerancePeriod) && Objects.equals(this.baseType, metricDefMeasureThresholdRule.baseType) && Objects.equals(this.schemaLocation, metricDefMeasureThresholdRule.schemaLocation) && Objects.equals(this.type, metricDefMeasureThresholdRule.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricDefMeasureThresholdRule {\n");
        sb.append("    conformanceComparatorLower: ").append(this.toIndentedString(this.conformanceComparatorLower)).append("\n");
        sb.append("    conformanceComparatorUpper: ").append(this.toIndentedString(this.conformanceComparatorUpper)).append("\n");
        sb.append("    conformanceTargetLower: ").append(this.toIndentedString(this.conformanceTargetLower)).append("\n");
        sb.append("    conformanceTargetUpper: ").append(this.toIndentedString(this.conformanceTargetUpper)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    numberOfAllowedCrossing: ").append(this.toIndentedString(this.numberOfAllowedCrossing)).append("\n");
        sb.append("    thresholdRuleSeverity: ").append(this.toIndentedString(this.thresholdRuleSeverity)).append("\n");
        sb.append("    consequence: ").append(this.toIndentedString(this.consequence)).append("\n");
        sb.append("    tolerancePeriod: ").append(this.toIndentedString(this.tolerancePeriod)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

