/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.stm653.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="A MetricDefMeasureConsequence defines the action (prescribed action or notification) to take when a  MetricDefMeasureThresholdRule is crossed.")
@Validated
@Entity(name="STMMetricDefMeasrConseq")
@Table(name="STMMetricDefMeasrConseq")
public class MetricDefMeasureConsequence
extends BaseRootNamedEntity {
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="prescribeAction")
    private String prescribeAction = null;
    @JsonProperty(value="repeatAction")
    private Boolean repeatAction = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;

    public MetricDefMeasureConsequence description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A narrative that explains in detail what the consequence is.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public MetricDefMeasureConsequence name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="A word, term, or phrase by which a  MetricDefMeasureConsequence is known and distinguished from other MetricDefMeasureConsequences.")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public MetricDefMeasureConsequence prescribeAction(String prescribeAction) {
        this.prescribeAction = prescribeAction;
        return this;
    }

    @Schema(description="Recommended remedy for a violated threshold. This could be  the hyperlink to the action.")
    public String getPrescribeAction() {
        return this.prescribeAction;
    }

    public void setPrescribeAction(String prescribeAction) {
        this.prescribeAction = prescribeAction;
    }

    public MetricDefMeasureConsequence repeatAction(Boolean repeatAction) {
        this.repeatAction = repeatAction;
        return this;
    }

    @Schema(description="An indicator used to specify that a consequence should cease  being applied if a value is in the same range as the previous value or continue being applied if a value is in the same range as the previous value.  If the repeatAction is True, if the consequence is always applied as soon as the MetricMeasure value is in the range of values and if the repeatAction is False, the consequence is applied only if the previous MetricMeasure value was not in the same range.")
    public Boolean isRepeatAction() {
        return this.repeatAction;
    }

    public void setRepeatAction(Boolean repeatAction) {
        this.repeatAction = repeatAction;
    }

    public MetricDefMeasureConsequence validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricDefMeasureConsequence metricDefMeasureConsequence = (MetricDefMeasureConsequence)o;
        return Objects.equals(this.description, metricDefMeasureConsequence.description) && Objects.equals(this.name, metricDefMeasureConsequence.name) && Objects.equals(this.prescribeAction, metricDefMeasureConsequence.prescribeAction) && Objects.equals(this.repeatAction, metricDefMeasureConsequence.repeatAction) && Objects.equals(this.validFor, metricDefMeasureConsequence.validFor) && Objects.equals(this.baseType, metricDefMeasureConsequence.baseType) && Objects.equals(this.schemaLocation, metricDefMeasureConsequence.schemaLocation) && Objects.equals(this.type, metricDefMeasureConsequence.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricDefMeasureConsequence {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    prescribeAction: ").append(this.toIndentedString(this.prescribeAction)).append("\n");
        sb.append("    repeatAction: ").append(this.toIndentedString(this.repeatAction)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

