/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.stm653.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.stm653.model.AppliedConsequence;
import org.etsi.osl.tmf.stm653.model.Duration;
import org.springframework.validation.annotation.Validated;

@Schema(description="A measureThresholdRuleViolation is a violation of a rule that defines the in the  MericDefMeasureThresholdRule.")
@Validated
@Entity(name="STMMeasureThresholdRuleViolation")
@Table(name="STMMeasureThresholdRuleViolation")
public class MeasureThresholdRuleViolation
extends BaseRootNamedEntity {
    @JsonProperty(value="conformanceComparatorLower")
    private String conformanceComparatorLower = null;
    @JsonProperty(value="conformanceComparatorUpper")
    private String conformanceComparatorUpper = null;
    @JsonProperty(value="conformanceTargetExact")
    private String conformanceTargetExact = null;
    @JsonProperty(value="conformanceTargetLower")
    private String conformanceTargetLower = null;
    @JsonProperty(value="conformanceTargetUpper")
    private String conformanceTargetUpper = null;
    @Lob
    @Column(name="LDESCRIPTION", columnDefinition="LONGTEXT")
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="numberOfAllowedCrossing")
    private Integer numberOfAllowedCrossing = null;
    @JsonProperty(value="thresholdRuleSeverity")
    private String thresholdRuleSeverity = null;
    @JsonProperty(value="appliedConsequence")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<AppliedConsequence> appliedConsequence = new HashSet<AppliedConsequence>();
    @JsonProperty(value="tolerancePeriod")
    private Duration tolerancePeriod = null;

    public MeasureThresholdRuleViolation conformanceComparatorLower(String conformanceComparatorLower) {
        this.conformanceComparatorLower = conformanceComparatorLower;
        return this;
    }

    @Schema(description="An operator that when applied on a value specifies whether a  threshold is crossed or ceased to be crossed. This operator is used to compare with the conformanceTargetLower.")
    public String getConformanceComparatorLower() {
        return this.conformanceComparatorLower;
    }

    public void setConformanceComparatorLower(String conformanceComparatorLower) {
        this.conformanceComparatorLower = conformanceComparatorLower;
    }

    public MeasureThresholdRuleViolation conformanceComparatorUpper(String conformanceComparatorUpper) {
        this.conformanceComparatorUpper = conformanceComparatorUpper;
        return this;
    }

    @Schema(description="An operator that when applied on a value specifies whether a  threshold is crossed or ceased to be crossed. This operator is used to compare with the conformanceTargetUpper.")
    public String getConformanceComparatorUpper() {
        return this.conformanceComparatorUpper;
    }

    public void setConformanceComparatorUpper(String conformanceComparatorUpper) {
        this.conformanceComparatorUpper = conformanceComparatorUpper;
    }

    public MeasureThresholdRuleViolation conformanceTargetExact(String conformanceTargetExact) {
        this.conformanceTargetExact = conformanceTargetExact;
        return this;
    }

    @Schema(description="to cater for values that are not numerical test metrics (e.g. a DSL line can be Synchronised or Unsynchronised. If the latter, the test should result in a rule violation).The allowed value can contain a REGEX string.")
    public String getConformanceTargetExact() {
        return this.conformanceTargetExact;
    }

    public void setConformanceTargetExact(String conformanceTargetExact) {
        this.conformanceTargetExact = conformanceTargetExact;
    }

    public MeasureThresholdRuleViolation conformanceTargetLower(String conformanceTargetLower) {
        this.conformanceTargetLower = conformanceTargetLower;
        return this;
    }

    @Schema(description="A value used to determine if the threshold is crossed or ceases  to be crossed. It represents the lower limit. The value should be less than the conformanceTargetUpper. The conformance comparators should also be logically defined so as to not lead to a logically impossible condition.")
    public String getConformanceTargetLower() {
        return this.conformanceTargetLower;
    }

    public void setConformanceTargetLower(String conformanceTargetLower) {
        this.conformanceTargetLower = conformanceTargetLower;
    }

    public MeasureThresholdRuleViolation conformanceTargetUpper(String conformanceTargetUpper) {
        this.conformanceTargetUpper = conformanceTargetUpper;
        return this;
    }

    @Schema(description="A value used to determine if the threshold is crossed or ceases  to be crossed. It represents the Upper limit. The value should be greater than the conformanceTargetLower. The conformance comparators should also be logically defined so as to not lead to a logically impossible condition.")
    public String getConformanceTargetUpper() {
        return this.conformanceTargetUpper;
    }

    public void setConformanceTargetUpper(String conformanceTargetUpper) {
        this.conformanceTargetUpper = conformanceTargetUpper;
    }

    public MeasureThresholdRuleViolation description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description for the MetricDefMeasureThresholdRule .")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public MeasureThresholdRuleViolation name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="Name for the MetricDefMeasureThresholdRule .")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public MeasureThresholdRuleViolation numberOfAllowedCrossing(Integer numberOfAllowedCrossing) {
        this.numberOfAllowedCrossing = numberOfAllowedCrossing;
        return this;
    }

    @Schema(description="The number of allowed crossing occurrences in reference to the  tolerancePeriod without a consequence being initiated.")
    public Integer getNumberOfAllowedCrossing() {
        return this.numberOfAllowedCrossing;
    }

    public void setNumberOfAllowedCrossing(Integer numberOfAllowedCrossing) {
        this.numberOfAllowedCrossing = numberOfAllowedCrossing;
    }

    public MeasureThresholdRuleViolation thresholdRuleSeverity(String thresholdRuleSeverity) {
        this.thresholdRuleSeverity = thresholdRuleSeverity;
        return this;
    }

    @Schema(description="A threshold can be generated in different severity levels. A  crossing for each level may require a different condition and possibly trigger a different consequence.")
    public String getThresholdRuleSeverity() {
        return this.thresholdRuleSeverity;
    }

    public void setThresholdRuleSeverity(String thresholdRuleSeverity) {
        this.thresholdRuleSeverity = thresholdRuleSeverity;
    }

    public MeasureThresholdRuleViolation appliedConsequence(Set<AppliedConsequence> appliedConsequence) {
        this.appliedConsequence = appliedConsequence;
        return this;
    }

    public MeasureThresholdRuleViolation addAppliedConsequenceItem(AppliedConsequence appliedConsequenceItem) {
        if (this.appliedConsequence == null) {
            this.appliedConsequence = new HashSet<AppliedConsequence>();
        }
        this.appliedConsequence.add(appliedConsequenceItem);
        return this;
    }

    @Schema(description="An Applied Consequence defines the action (prescribed action or notification) to take when a MeasureThresholdRuleViolation occurs.")
    @Valid
    public Set<AppliedConsequence> getAppliedConsequence() {
        return this.appliedConsequence;
    }

    public void setAppliedConsequence(Set<AppliedConsequence> appliedConsequence) {
        this.appliedConsequence = appliedConsequence;
    }

    public MeasureThresholdRuleViolation tolerancePeriod(Duration tolerancePeriod) {
        this.tolerancePeriod = tolerancePeriod;
        return this;
    }

    @Schema(description="")
    @Valid
    public Duration getTolerancePeriod() {
        return this.tolerancePeriod;
    }

    public void setTolerancePeriod(Duration tolerancePeriod) {
        this.tolerancePeriod = tolerancePeriod;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeasureThresholdRuleViolation measureThresholdRuleViolation = (MeasureThresholdRuleViolation)o;
        return Objects.equals(this.conformanceComparatorLower, measureThresholdRuleViolation.conformanceComparatorLower) && Objects.equals(this.conformanceComparatorUpper, measureThresholdRuleViolation.conformanceComparatorUpper) && Objects.equals(this.conformanceTargetExact, measureThresholdRuleViolation.conformanceTargetExact) && Objects.equals(this.conformanceTargetLower, measureThresholdRuleViolation.conformanceTargetLower) && Objects.equals(this.conformanceTargetUpper, measureThresholdRuleViolation.conformanceTargetUpper) && Objects.equals(this.description, measureThresholdRuleViolation.description) && Objects.equals(this.name, measureThresholdRuleViolation.name) && Objects.equals(this.numberOfAllowedCrossing, measureThresholdRuleViolation.numberOfAllowedCrossing) && Objects.equals(this.thresholdRuleSeverity, measureThresholdRuleViolation.thresholdRuleSeverity) && Objects.equals(this.appliedConsequence, measureThresholdRuleViolation.appliedConsequence) && Objects.equals(this.tolerancePeriod, measureThresholdRuleViolation.tolerancePeriod) && Objects.equals(this.baseType, measureThresholdRuleViolation.baseType) && Objects.equals(this.schemaLocation, measureThresholdRuleViolation.schemaLocation) && Objects.equals(this.type, measureThresholdRuleViolation.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MeasureThresholdRuleViolation {\n");
        sb.append("    conformanceComparatorLower: ").append(this.toIndentedString(this.conformanceComparatorLower)).append("\n");
        sb.append("    conformanceComparatorUpper: ").append(this.toIndentedString(this.conformanceComparatorUpper)).append("\n");
        sb.append("    conformanceTargetExact: ").append(this.toIndentedString(this.conformanceTargetExact)).append("\n");
        sb.append("    conformanceTargetLower: ").append(this.toIndentedString(this.conformanceTargetLower)).append("\n");
        sb.append("    conformanceTargetUpper: ").append(this.toIndentedString(this.conformanceTargetUpper)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    numberOfAllowedCrossing: ").append(this.toIndentedString(this.numberOfAllowedCrossing)).append("\n");
        sb.append("    thresholdRuleSeverity: ").append(this.toIndentedString(this.thresholdRuleSeverity)).append("\n");
        sb.append("    appliedConsequence: ").append(this.toIndentedString(this.appliedConsequence)).append("\n");
        sb.append("    tolerancePeriod: ").append(this.toIndentedString(this.tolerancePeriod)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

