/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.stm653.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.stm653.model.AssociationSpecificationRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="A migration, substitution, dependency or exclusivity relationship between/among entity specifications.")
@Validated
@Entity(name="STMEntitySpecRel")
@Table(name="STMEntitySpecRel")
public class EntitySpecificationRelationship
extends BaseEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="relationshipType")
    private String relationshipType = null;
    @JsonProperty(value="role")
    private String role = null;
    @JsonProperty(value="associationSpec")
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private AssociationSpecificationRef associationSpec = null;
    @JsonProperty(value="@referredType")
    private String _atReferredType = null;

    public EntitySpecificationRelationship id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="unique identifier")
    public String getId() {
        if (this.uuid != null) {
            this.id = this.uuid;
        }
        return this.id;
    }

    public EntitySpecificationRelationship href(String href) {
        this.href = href;
        return this;
    }

    @Override
    @Schema(description="Hyperlink reference")
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    @Override
    public EntitySpecificationRelationship name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="Name of the related entity.")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public EntitySpecificationRelationship relationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @Schema(description="Type of relationship such as migration, substitution, dependency, exclusivity")
    @NotNull
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public EntitySpecificationRelationship role(String role) {
        this.role = role;
        return this;
    }

    @Schema(description="The association role for this entity specification")
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public EntitySpecificationRelationship associationSpec(AssociationSpecificationRef associationSpec) {
        this.associationSpec = associationSpec;
        return this;
    }

    @Schema(description="")
    @Valid
    public AssociationSpecificationRef getAssociationSpec() {
        return this.associationSpec;
    }

    public void setAssociationSpec(AssociationSpecificationRef associationSpec) {
        this.associationSpec = associationSpec;
    }

    public EntitySpecificationRelationship _atReferredType(String _atReferredType) {
        this._atReferredType = _atReferredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getAtReferredType() {
        return this._atReferredType;
    }

    public void setAtReferredType(String _atReferredType) {
        this._atReferredType = _atReferredType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntitySpecificationRelationship entitySpecificationRelationship = (EntitySpecificationRelationship)o;
        return Objects.equals(this.id, entitySpecificationRelationship.id) && Objects.equals(this.href, entitySpecificationRelationship.href) && Objects.equals(this.name, entitySpecificationRelationship.name) && Objects.equals(this.relationshipType, entitySpecificationRelationship.relationshipType) && Objects.equals(this.role, entitySpecificationRelationship.role) && Objects.equals(this.associationSpec, entitySpecificationRelationship.associationSpec) && Objects.equals(this.validFor, entitySpecificationRelationship.validFor) && Objects.equals(this.baseType, entitySpecificationRelationship.baseType) && Objects.equals(this.schemaLocation, entitySpecificationRelationship.schemaLocation) && Objects.equals(this.type, entitySpecificationRelationship.type) && Objects.equals(this._atReferredType, entitySpecificationRelationship._atReferredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntitySpecificationRelationship {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    relationshipType: ").append(this.toIndentedString(this.relationshipType)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    associationSpec: ").append(this.toIndentedString(this.associationSpec)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    _atReferredType: ").append(this.toIndentedString(this._atReferredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

