/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.stm653.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.AttachmentRefOrValue;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.stm653.model.CharacteristicSpecification;
import org.etsi.osl.tmf.stm653.model.ConstraintRef;
import org.etsi.osl.tmf.stm653.model.EntitySpecificationRelationship;
import org.etsi.osl.tmf.stm653.model.TargetEntitySchema;
import org.springframework.validation.annotation.Validated;

@Schema(description="EntitySpecification is a class that offers characteristics to describe a type of entity. Entities are generic constructs that may be used to describe bespoke business entities that are not effectively covered by the existing SID model. Functionally, the entity specification acts as a template by which entities may be instantiated and described. By sharing the same specification, these entities would therefore share the same set of characteristics. Note: The \u2018configurable\u2019 attribute on the specCharacteristics determines if an entity instantiated from the entity specification can override the value of the attribute. When set to false, the entity instance may not define a value that differs from the value in the specification.")
@Validated
@Entity(name="STMEntitySpecification")
@Table(name="STMEntitySpecification")
public class EntitySpecification
extends BaseEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="isBundle")
    private Boolean isBundle = null;
    @JsonProperty(value="attachment")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<AttachmentRefOrValue> attachment = new HashSet<AttachmentRefOrValue>();
    @JsonProperty(value="constraint")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ConstraintRef> constraint = new HashSet<ConstraintRef>();
    @JsonProperty(value="entitySpecRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<EntitySpecificationRelationship> entitySpecRelationship = new HashSet<EntitySpecificationRelationship>();
    @JsonProperty(value="relatedParty")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<RelatedParty> relatedParty = new HashSet<RelatedParty>();
    @JsonProperty(value="specCharacteristic")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<CharacteristicSpecification> specCharacteristic = new HashSet<CharacteristicSpecification>();
    @JsonProperty(value="targetEntitySchema")
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private TargetEntitySchema targetEntitySchema = null;

    public String getId() {
        if (this.uuid != null) {
            this.id = this.uuid;
        }
        return this.id;
    }

    public EntitySpecification href(String href) {
        this.href = href;
        return this;
    }

    @Override
    @Schema(description="Hyperlink reference")
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    @Override
    public EntitySpecification description(String description) {
        this.description = description;
        return this;
    }

    @Override
    @Schema(description="Description of this REST resource")
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public EntitySpecification isBundle(Boolean isBundle) {
        this.isBundle = isBundle;
        return this;
    }

    @Schema(description="isBundle determines whether an EntitySpecification represents a single EntitySpecification (false), or a bundle of EntitySpecifications (true).")
    public Boolean isIsBundle() {
        return this.isBundle;
    }

    public void setIsBundle(Boolean isBundle) {
        this.isBundle = isBundle;
    }

    @Override
    public EntitySpecification lastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Override
    @Schema(description="Date and time of the last update of this REST resource")
    @Valid
    public OffsetDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void setLastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    public EntitySpecification lifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
        return this;
    }

    @Override
    @Schema(description="Used to indicate the current lifecycle status of this catalog item")
    public String getLifecycleStatus() {
        return this.lifecycleStatus;
    }

    @Override
    public void setLifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
    }

    @Override
    public EntitySpecification name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="Name given to this REST resource")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public EntitySpecification version(String version) {
        this.version = version;
        return this;
    }

    @Override
    @Schema(description="Entity specification version")
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    public EntitySpecification attachment(Set<AttachmentRefOrValue> attachment) {
        this.attachment = attachment;
        return this;
    }

    public EntitySpecification addAttachmentItem(AttachmentRefOrValue attachmentItem) {
        if (this.attachment == null) {
            this.attachment = new HashSet<AttachmentRefOrValue>();
        }
        this.attachment.add(attachmentItem);
        return this;
    }

    @Schema(description="Attachments that may be of relevance to this specification, such as picture, document, media")
    @Valid
    public Set<AttachmentRefOrValue> getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Set<AttachmentRefOrValue> attachment) {
        this.attachment = attachment;
    }

    public EntitySpecification constraint(Set<ConstraintRef> constraint) {
        this.constraint = constraint;
        return this;
    }

    public EntitySpecification addConstraintItem(ConstraintRef constraintItem) {
        if (this.constraint == null) {
            this.constraint = new HashSet<ConstraintRef>();
        }
        this.constraint.add(constraintItem);
        return this;
    }

    @Schema(description="This is a list of constraint references applied to this specification")
    @Valid
    public Set<ConstraintRef> getConstraint() {
        return this.constraint;
    }

    public void setConstraint(Set<ConstraintRef> constraint) {
        this.constraint = constraint;
    }

    public EntitySpecification entitySpecRelationship(Set<EntitySpecificationRelationship> entitySpecRelationship) {
        this.entitySpecRelationship = entitySpecRelationship;
        return this;
    }

    public EntitySpecification addEntitySpecRelationshipItem(EntitySpecificationRelationship entitySpecRelationshipItem) {
        if (this.entitySpecRelationship == null) {
            this.entitySpecRelationship = new HashSet<EntitySpecificationRelationship>();
        }
        this.entitySpecRelationship.add(entitySpecRelationshipItem);
        return this;
    }

    @Schema(description="Relationship to another entity specification, might be dependency, substitution, etc.")
    @Valid
    public Set<EntitySpecificationRelationship> getEntitySpecRelationship() {
        return this.entitySpecRelationship;
    }

    public void setEntitySpecRelationship(Set<EntitySpecificationRelationship> entitySpecRelationship) {
        this.entitySpecRelationship = entitySpecRelationship;
    }

    public EntitySpecification relatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public EntitySpecification addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new HashSet<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="Parties who manage or otherwise have an interest in this entity specification")
    @Valid
    public Set<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public EntitySpecification specCharacteristic(Set<CharacteristicSpecification> specCharacteristic) {
        this.specCharacteristic = specCharacteristic;
        return this;
    }

    public EntitySpecification addSpecCharacteristicItem(CharacteristicSpecification specCharacteristicItem) {
        if (this.specCharacteristic == null) {
            this.specCharacteristic = new HashSet<CharacteristicSpecification>();
        }
        this.specCharacteristic.add(specCharacteristicItem);
        return this;
    }

    @Schema(description="List of characteristics that the entity can take")
    @Valid
    public Set<CharacteristicSpecification> getSpecCharacteristic() {
        return this.specCharacteristic;
    }

    public void setSpecCharacteristic(Set<CharacteristicSpecification> specCharacteristic) {
        this.specCharacteristic = specCharacteristic;
    }

    public EntitySpecification targetEntitySchema(TargetEntitySchema targetEntitySchema) {
        this.targetEntitySchema = targetEntitySchema;
        return this;
    }

    @Schema(description="")
    @Valid
    public TargetEntitySchema getTargetEntitySchema() {
        return this.targetEntitySchema;
    }

    public void setTargetEntitySchema(TargetEntitySchema targetEntitySchema) {
        this.targetEntitySchema = targetEntitySchema;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntitySpecification entitySpecification = (EntitySpecification)o;
        return Objects.equals(this.id, entitySpecification.id) && Objects.equals(this.href, entitySpecification.href) && Objects.equals(this.description, entitySpecification.description) && Objects.equals(this.isBundle, entitySpecification.isBundle) && Objects.equals(this.lastUpdate, entitySpecification.lastUpdate) && Objects.equals(this.lifecycleStatus, entitySpecification.lifecycleStatus) && Objects.equals(this.name, entitySpecification.name) && Objects.equals(this.version, entitySpecification.version) && Objects.equals(this.attachment, entitySpecification.attachment) && Objects.equals(this.constraint, entitySpecification.constraint) && Objects.equals(this.entitySpecRelationship, entitySpecification.entitySpecRelationship) && Objects.equals(this.relatedParty, entitySpecification.relatedParty) && Objects.equals(this.specCharacteristic, entitySpecification.specCharacteristic) && Objects.equals(this.targetEntitySchema, entitySpecification.targetEntitySchema) && Objects.equals(this.validFor, entitySpecification.validFor) && Objects.equals(this.baseType, entitySpecification.baseType) && Objects.equals(this.schemaLocation, entitySpecification.schemaLocation) && Objects.equals(this.type, entitySpecification.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntitySpecification {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    constraint: ").append(this.toIndentedString(this.constraint)).append("\n");
        sb.append("    entitySpecRelationship: ").append(this.toIndentedString(this.entitySpecRelationship)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    specCharacteristic: ").append(this.toIndentedString(this.specCharacteristic)).append("\n");
        sb.append("    targetEntitySchema: ").append(this.toIndentedString(this.targetEntitySchema)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    _atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    _atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    _atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

