/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.stm653.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Constraint reference. The Constraint resource represents a policy/rule applied to an entity or entity spec.")
@Validated
@Entity(name="STMConstraintRef")
@Table(name="STMConstraintRef")
public class ConstraintRef
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="@referredType")
    private String _atReferredType = null;
    @JsonProperty(value="version")
    private String version = null;

    @Schema(description="reference id to the target constraint")
    @NotNull
    public String getId() {
        if (this.uuid != null) {
            this.id = this.uuid;
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ConstraintRef href(String href) {
        this.href = href;
        return this;
    }

    @Override
    @Schema(description="Hyperlink reference to the target constraint")
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    @Override
    public ConstraintRef name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="Name given to the constraint")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public ConstraintRef _atReferredType(String _atReferredType) {
        this._atReferredType = _atReferredType;
        return this;
    }

    @Schema(description="The (class) type of the referred constraint")
    public String getAtReferredType() {
        return this._atReferredType;
    }

    public void setAtReferredType(String _atReferredType) {
        this._atReferredType = _atReferredType;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstraintRef constraintRef = (ConstraintRef)o;
        return Objects.equals(this.id, constraintRef.id) && Objects.equals(this.href, constraintRef.href) && Objects.equals(this.name, constraintRef.name) && Objects.equals(this.version, constraintRef.version) && Objects.equals(this.baseType, constraintRef.baseType) && Objects.equals(this.schemaLocation, constraintRef.schemaLocation) && Objects.equals(this.type, constraintRef.type) && Objects.equals(this._atReferredType, constraintRef._atReferredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConstraintRef {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    _atReferredType: ").append(this.toIndentedString(this._atReferredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

