/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.stm653.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.Any;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="specification of a value (number or text or an object) that can be assigned to a Characteristic.")
@Validated
@Entity(name="STMCharacValSpec")
@Table(name="STMCharacValSpec")
public class CharacteristicValueSpecification
extends BaseRootEntity {
    @JsonProperty(value="isDefault")
    private Boolean isDefault = null;
    @JsonProperty(value="rangeInterval")
    private String rangeInterval = null;
    @JsonProperty(value="regex")
    private String regex = null;
    @JsonProperty(value="unitOfMeasure")
    private String unitOfMeasure = null;
    @JsonProperty(value="valueFrom")
    private Integer valueFrom = null;
    @JsonProperty(value="valueTo")
    private Integer valueTo = null;
    @JsonProperty(value="valueType")
    private String valueType = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="value")
    private Any value = null;

    public CharacteristicValueSpecification() {
    }

    public CharacteristicValueSpecification(CharacteristicValueSpecification r) {
        this();
        this.isDefault = r.isDefault;
        this.rangeInterval = r.rangeInterval;
        this.regex = r.regex;
        this.unitOfMeasure = r.unitOfMeasure;
        this.valueFrom = r.valueFrom;
        this.valueTo = r.valueTo;
        this.valueType = r.valueType;
        this.validFor = new TimePeriod(r.validFor);
        this.value = new Any(r.value);
        this.baseType = r.baseType;
    }

    public CharacteristicValueSpecification isDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    @Schema(description="If true, the Boolean Indicates if the value is the default value for a characteristic")
    public Boolean isIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public CharacteristicValueSpecification rangeInterval(String rangeInterval) {
        this.rangeInterval = rangeInterval;
        return this;
    }

    @Schema(description="An indicator that specifies the inclusion or exclusion of the valueFrom and valueTo attributes. If applicable, possible values are \"open\", \"closed\", \"closedBottom\" and \"closedTop\".")
    public String getRangeInterval() {
        return this.rangeInterval;
    }

    public void setRangeInterval(String rangeInterval) {
        this.rangeInterval = rangeInterval;
    }

    public CharacteristicValueSpecification regex(String regex) {
        this.regex = regex;
        return this;
    }

    @Schema(description="A regular expression constraint for given value")
    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public CharacteristicValueSpecification unitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Schema(description="A length, surface, volume, dry measure, liquid measure, money, weight, time, and the like. In general, a determinate quantity or magnitude of the kind designated, taken as a standard of comparison for others of the same kind, in assigning to them numerical values, as 1 foot, 1 yard, 1 mile, 1 square foot.")
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public CharacteristicValueSpecification valueFrom(Integer valueFrom) {
        this.valueFrom = valueFrom;
        return this;
    }

    @Schema(description="The low range value that a characteristic can take on")
    public Integer getValueFrom() {
        return this.valueFrom;
    }

    public void setValueFrom(Integer valueFrom) {
        this.valueFrom = valueFrom;
    }

    public CharacteristicValueSpecification valueTo(Integer valueTo) {
        this.valueTo = valueTo;
        return this;
    }

    @Schema(description="The upper range value that a characteristic can take on")
    public Integer getValueTo() {
        return this.valueTo;
    }

    public void setValueTo(Integer valueTo) {
        this.valueTo = valueTo;
    }

    public CharacteristicValueSpecification valueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    @Schema(description="A kind of value that the characteristic value can take on, such as numeric, text and so forth")
    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public CharacteristicValueSpecification validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public CharacteristicValueSpecification value(Any value) {
        this.value = value;
        return this;
    }

    @Schema(description="")
    @Valid
    public Any getValue() {
        return this.value;
    }

    public void setValue(Any value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharacteristicValueSpecification characteristicValueSpecification = (CharacteristicValueSpecification)o;
        return Objects.equals(this.isDefault, characteristicValueSpecification.isDefault) && Objects.equals(this.rangeInterval, characteristicValueSpecification.rangeInterval) && Objects.equals(this.regex, characteristicValueSpecification.regex) && Objects.equals(this.unitOfMeasure, characteristicValueSpecification.unitOfMeasure) && Objects.equals(this.valueFrom, characteristicValueSpecification.valueFrom) && Objects.equals(this.valueTo, characteristicValueSpecification.valueTo) && Objects.equals(this.valueType, characteristicValueSpecification.valueType) && Objects.equals(this.validFor, characteristicValueSpecification.validFor) && Objects.equals(this.value, characteristicValueSpecification.value) && Objects.equals(this.baseType, characteristicValueSpecification.baseType) && Objects.equals(this.schemaLocation, characteristicValueSpecification.schemaLocation) && Objects.equals(this.type, characteristicValueSpecification.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CharacteristicValueSpecification {\n");
        sb.append("    isDefault: ").append(this.toIndentedString(this.isDefault)).append("\n");
        sb.append("    rangeInterval: ").append(this.toIndentedString(this.rangeInterval)).append("\n");
        sb.append("    regex: ").append(this.toIndentedString(this.regex)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    valueFrom: ").append(this.toIndentedString(this.valueFrom)).append("\n");
        sb.append("    valueTo: ").append(this.toIndentedString(this.valueTo)).append("\n");
        sb.append("    valueType: ").append(this.toIndentedString(this.valueType)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

