/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.stm653.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="An aggregation, migration, substitution, dependency or exclusivity relationship between/among Characteristic specifications. The specification characteristic is embedded within the specification whose ID and href are in this entity, and identified by its ID.")
@Validated
@Entity(name="STMCharacSpecRel")
@Table(name="STMCharacSpecRel")
public class CharacteristicSpecificationRelationship
extends BaseRootNamedEntity {
    @JsonProperty(value="characteristicSpecificationId")
    private String characteristicSpecificationId = null;
    @JsonProperty(value="parentSpecificationHref")
    private String parentSpecificationHref = null;
    @JsonProperty(value="parentSpecificationId")
    private String parentSpecificationId = null;
    @JsonProperty(value="relationshipType")
    private String relationshipType = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;

    public CharacteristicSpecificationRelationship() {
    }

    public CharacteristicSpecificationRelationship(CharacteristicSpecificationRelationship src) {
        this.name = src.name;
        this.relationshipType = src.relationshipType;
        this.validFor = new TimePeriod(src.validFor);
        this.characteristicSpecificationId = src.characteristicSpecificationId;
    }

    public CharacteristicSpecificationRelationship characteristicSpecificationId(String characteristicSpecificationId) {
        this.characteristicSpecificationId = characteristicSpecificationId;
        return this;
    }

    @Schema(description="Unique identifier of the characteristic within the specification")
    public String getCharacteristicSpecificationId() {
        return this.characteristicSpecificationId;
    }

    public void setCharacteristicSpecificationId(String characteristicSpecificationId) {
        this.characteristicSpecificationId = characteristicSpecificationId;
    }

    public CharacteristicSpecificationRelationship parentSpecificationHref(String parentSpecificationHref) {
        this.parentSpecificationHref = parentSpecificationHref;
        return this;
    }

    @Schema(description="Hyperlink reference to the parent specification containing the target characteristic")
    public String getParentSpecificationHref() {
        return this.parentSpecificationHref;
    }

    public void setParentSpecificationHref(String parentSpecificationHref) {
        this.parentSpecificationHref = parentSpecificationHref;
    }

    public CharacteristicSpecificationRelationship parentSpecificationId(String parentSpecificationId) {
        this.parentSpecificationId = parentSpecificationId;
        return this;
    }

    @Schema(description="Unique identifier of the parent specification containing the target characteristic")
    public String getParentSpecificationId() {
        return this.parentSpecificationId;
    }

    public void setParentSpecificationId(String parentSpecificationId) {
        this.parentSpecificationId = parentSpecificationId;
    }

    public CharacteristicSpecificationRelationship relationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @Schema(description="Type of relationship such as aggregation, migration, substitution, dependency, exclusivity")
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public CharacteristicSpecificationRelationship validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharacteristicSpecificationRelationship characteristicSpecificationRelationship = (CharacteristicSpecificationRelationship)o;
        return Objects.equals(this.characteristicSpecificationId, characteristicSpecificationRelationship.characteristicSpecificationId) && Objects.equals(this.name, characteristicSpecificationRelationship.name) && Objects.equals(this.parentSpecificationHref, characteristicSpecificationRelationship.parentSpecificationHref) && Objects.equals(this.parentSpecificationId, characteristicSpecificationRelationship.parentSpecificationId) && Objects.equals(this.relationshipType, characteristicSpecificationRelationship.relationshipType) && Objects.equals(this.validFor, characteristicSpecificationRelationship.validFor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.characteristicSpecificationId, this.name, this.parentSpecificationHref, this.parentSpecificationId, this.relationshipType, this.validFor);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CharacteristicSpecificationRelationship {\n");
        sb.append("    characteristicSpecificationId: ").append(this.toIndentedString(this.characteristicSpecificationId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parentSpecificationHref: ").append(this.toIndentedString(this.parentSpecificationHref)).append("\n");
        sb.append("    parentSpecificationId: ").append(this.toIndentedString(this.parentSpecificationId)).append("\n");
        sb.append("    relationshipType: ").append(this.toIndentedString(this.relationshipType)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

