/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.stm653.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="This class defines a characteristic specification.")
@Validated
public class CharacteristicSpecificationBase {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="configurable")
    private Boolean configurable = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="extensible")
    private Boolean extensible = null;
    @JsonProperty(value="isUnique")
    private Boolean isUnique = null;
    @JsonProperty(value="maxCardinality")
    private Integer maxCardinality = null;
    @JsonProperty(value="minCardinality")
    private Integer minCardinality = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="regex")
    private String regex = null;
    @JsonProperty(value="valueType")
    private String valueType = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;
    @JsonProperty(value="@valueSchemaLocation")
    private String _atValueSchemaLocation = null;

    public CharacteristicSpecificationBase id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique ID for the characteristic")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CharacteristicSpecificationBase configurable(Boolean configurable) {
        this.configurable = configurable;
        return this;
    }

    @Schema(description="If true, the Boolean indicates that the target Characteristic is configurable")
    public Boolean isConfigurable() {
        return this.configurable;
    }

    public void setConfigurable(Boolean configurable) {
        this.configurable = configurable;
    }

    public CharacteristicSpecificationBase description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A narrative that explains the CharacteristicSpecification.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CharacteristicSpecificationBase extensible(Boolean extensible) {
        this.extensible = extensible;
        return this;
    }

    @Schema(description="An indicator that specifies that the values for the characteristic can be extended by adding new values when instantiating a characteristic for a resource.")
    public Boolean isExtensible() {
        return this.extensible;
    }

    public void setExtensible(Boolean extensible) {
        this.extensible = extensible;
    }

    public CharacteristicSpecificationBase isUnique(Boolean isUnique) {
        this.isUnique = isUnique;
        return this;
    }

    @Schema(description="An indicator that specifies if a value is unique for the specification. Possible values are; \"unique while value is in effect\" and \"unique whether value is in effect or not\"")
    public Boolean isIsUnique() {
        return this.isUnique;
    }

    public void setIsUnique(Boolean isUnique) {
        this.isUnique = isUnique;
    }

    public CharacteristicSpecificationBase maxCardinality(Integer maxCardinality) {
        this.maxCardinality = maxCardinality;
        return this;
    }

    @Schema(description="The maximum number of instances a CharacteristicValue can take on. For example, zero to five phone numbers in a group calling plan, where five is the value for the maxCardinality.")
    public Integer getMaxCardinality() {
        return this.maxCardinality;
    }

    public void setMaxCardinality(Integer maxCardinality) {
        this.maxCardinality = maxCardinality;
    }

    public CharacteristicSpecificationBase minCardinality(Integer minCardinality) {
        this.minCardinality = minCardinality;
        return this;
    }

    @Schema(description="The minimum number of instances a CharacteristicValue can take on. For example, zero to five phone numbers in a group calling plan, where zero is the value for the minCardinality.")
    public Integer getMinCardinality() {
        return this.minCardinality;
    }

    public void setMinCardinality(Integer minCardinality) {
        this.minCardinality = minCardinality;
    }

    public CharacteristicSpecificationBase name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="A word, term, or phrase by which this characteristic specification is known and distinguished from other characteristic specifications.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CharacteristicSpecificationBase regex(String regex) {
        this.regex = regex;
        return this;
    }

    @Schema(description="A rule or principle represented in regular expression used to derive the value of a characteristic value.")
    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public CharacteristicSpecificationBase valueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    @Schema(description="A kind of value that the characteristic can take on, such as numeric, text and so forth")
    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public CharacteristicSpecificationBase validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public CharacteristicSpecificationBase baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    public CharacteristicSpecificationBase schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public CharacteristicSpecificationBase type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class Extensible name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    public CharacteristicSpecificationBase _atValueSchemaLocation(String _atValueSchemaLocation) {
        this._atValueSchemaLocation = _atValueSchemaLocation;
        return this;
    }

    @Schema(description="This (optional) field provides a link to the schema describing the value type.")
    public String getAtValueSchemaLocation() {
        return this._atValueSchemaLocation;
    }

    public void setAtValueSchemaLocation(String _atValueSchemaLocation) {
        this._atValueSchemaLocation = _atValueSchemaLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharacteristicSpecificationBase characteristicSpecificationBase = (CharacteristicSpecificationBase)o;
        return Objects.equals(this.id, characteristicSpecificationBase.id) && Objects.equals(this.configurable, characteristicSpecificationBase.configurable) && Objects.equals(this.description, characteristicSpecificationBase.description) && Objects.equals(this.extensible, characteristicSpecificationBase.extensible) && Objects.equals(this.isUnique, characteristicSpecificationBase.isUnique) && Objects.equals(this.maxCardinality, characteristicSpecificationBase.maxCardinality) && Objects.equals(this.minCardinality, characteristicSpecificationBase.minCardinality) && Objects.equals(this.name, characteristicSpecificationBase.name) && Objects.equals(this.regex, characteristicSpecificationBase.regex) && Objects.equals(this.valueType, characteristicSpecificationBase.valueType) && Objects.equals(this.validFor, characteristicSpecificationBase.validFor) && Objects.equals(this.baseType, characteristicSpecificationBase.baseType) && Objects.equals(this.schemaLocation, characteristicSpecificationBase.schemaLocation) && Objects.equals(this.type, characteristicSpecificationBase.type) && Objects.equals(this._atValueSchemaLocation, characteristicSpecificationBase._atValueSchemaLocation);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.configurable, this.description, this.extensible, this.isUnique, this.maxCardinality, this.minCardinality, this.name, this.regex, this.valueType, this.validFor, this.baseType, this.schemaLocation, this.type, this._atValueSchemaLocation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CharacteristicSpecificationBase {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    configurable: ").append(this.toIndentedString(this.configurable)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    extensible: ").append(this.toIndentedString(this.extensible)).append("\n");
        sb.append("    isUnique: ").append(this.toIndentedString(this.isUnique)).append("\n");
        sb.append("    maxCardinality: ").append(this.toIndentedString(this.maxCardinality)).append("\n");
        sb.append("    minCardinality: ").append(this.toIndentedString(this.minCardinality)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    regex: ").append(this.toIndentedString(this.regex)).append("\n");
        sb.append("    valueType: ").append(this.toIndentedString(this.valueType)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    _atValueSchemaLocation: ").append(this.toIndentedString(this._atValueSchemaLocation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

