/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.stm653.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.stm653.model.CharacteristicSpecificationRelationship;
import org.etsi.osl.tmf.stm653.model.CharacteristicValueSpecification;
import org.springframework.validation.annotation.Validated;

@Schema(description="This class defines a characteristic specification.")
@Validated
@Entity(name="STMCharactSpec")
@Table(name="STMCharactSpec")
public class CharacteristicSpecification
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="configurable")
    private Boolean configurable = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="extensible")
    private Boolean extensible = null;
    @JsonProperty(value="isUnique")
    private Boolean isUnique = null;
    @JsonProperty(value="maxCardinality")
    private Integer maxCardinality = null;
    @JsonProperty(value="minCardinality")
    private Integer minCardinality = null;
    @JsonProperty(value="regex")
    private String regex = null;
    @JsonProperty(value="valueType")
    private String valueType = null;
    @JsonProperty(value="charSpecRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<CharacteristicSpecificationRelationship> charSpecRelationship = new HashSet<CharacteristicSpecificationRelationship>();
    @JsonProperty(value="characteristicValueSpecification")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<CharacteristicValueSpecification> characteristicValueSpecification = new HashSet<CharacteristicValueSpecification>();
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="@valueSchemaLocation")
    private String _atValueSchemaLocation = null;

    public CharacteristicSpecification() {
        this.baseType = "BaseRootEntity";
        this.type = this.getClass().getName();
    }

    public CharacteristicSpecification(CharacteristicSpecification src) {
        this();
        this.configurable = src.configurable;
        this.description = src.description;
        this.extensible = src.extensible;
        this.isUnique = src.isUnique;
        this.maxCardinality = src.maxCardinality;
        this.minCardinality = src.minCardinality;
        this.name = src.name;
        this.regex = src.regex;
        this.valueType = src.valueType;
        this.validFor = new TimePeriod(src.validFor);
        for (CharacteristicSpecificationRelationship characteristicSpecificationRelationship : src.charSpecRelationship) {
            this.addServiceSpecCharRelationshipItem(new CharacteristicSpecificationRelationship(characteristicSpecificationRelationship));
        }
        for (CharacteristicValueSpecification characteristicValueSpecification : src.characteristicValueSpecification) {
            this.addServiceSpecCharacteristicValueItem(new CharacteristicValueSpecification(characteristicValueSpecification));
        }
    }

    private CharacteristicSpecification addServiceSpecCharRelationshipItem(CharacteristicSpecificationRelationship characteristicSpecificationRelationship) {
        if (this.charSpecRelationship == null) {
            this.charSpecRelationship = new HashSet<CharacteristicSpecificationRelationship>();
        }
        this.charSpecRelationship.add(characteristicSpecificationRelationship);
        return this;
    }

    @Schema(description="Unique ID for the characteristic")
    public String getId() {
        this.id = this.uuid;
        return this.uuid;
    }

    public CharacteristicSpecification configurable(Boolean configurable) {
        this.configurable = configurable;
        return this;
    }

    @Schema(description="If true, the Boolean indicates that the target Characteristic is configurable")
    public Boolean isConfigurable() {
        return this.configurable;
    }

    public void setConfigurable(Boolean configurable) {
        this.configurable = configurable;
    }

    public CharacteristicSpecification description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A narrative that explains the CharacteristicSpecification.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CharacteristicSpecification extensible(Boolean extensible) {
        this.extensible = extensible;
        return this;
    }

    @Schema(description="An indicator that specifies that the values for the characteristic can be extended by adding new values when instantiating a characteristic for a resource.")
    public Boolean isExtensible() {
        return this.extensible;
    }

    public void setExtensible(Boolean extensible) {
        this.extensible = extensible;
    }

    public CharacteristicSpecification isUnique(Boolean isUnique) {
        this.isUnique = isUnique;
        return this;
    }

    @Schema(description="An indicator that specifies if a value is unique for the specification. Possible values are; \"unique while value is in effect\" and \"unique whether value is in effect or not\"")
    public Boolean isIsUnique() {
        return this.isUnique;
    }

    public void setIsUnique(Boolean isUnique) {
        this.isUnique = isUnique;
    }

    public CharacteristicSpecification maxCardinality(Integer maxCardinality) {
        this.maxCardinality = maxCardinality;
        return this;
    }

    @Schema(description="The maximum number of instances a CharacteristicValue can take on. For example, zero to five phone numbers in a group calling plan, where five is the value for the maxCardinality.")
    public Integer getMaxCardinality() {
        return this.maxCardinality;
    }

    public void setMaxCardinality(Integer maxCardinality) {
        this.maxCardinality = maxCardinality;
    }

    public CharacteristicSpecification minCardinality(Integer minCardinality) {
        this.minCardinality = minCardinality;
        return this;
    }

    @Schema(description="The minimum number of instances a CharacteristicValue can take on. For example, zero to five phone numbers in a group calling plan, where zero is the value for the minCardinality.")
    public Integer getMinCardinality() {
        return this.minCardinality;
    }

    public void setMinCardinality(Integer minCardinality) {
        this.minCardinality = minCardinality;
    }

    @Override
    public CharacteristicSpecification name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="A word, term, or phrase by which this characteristic specification is known and distinguished from other characteristic specifications.")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public CharacteristicSpecification regex(String regex) {
        this.regex = regex;
        return this;
    }

    @Schema(description="A rule or principle represented in regular expression used to derive the value of a characteristic value.")
    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public CharacteristicSpecification valueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    @Schema(description="A kind of value that the characteristic can take on, such as numeric, text and so forth")
    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public CharacteristicSpecification charSpecRelationship(Set<CharacteristicSpecificationRelationship> charSpecRelationship) {
        this.charSpecRelationship = charSpecRelationship;
        return this;
    }

    public CharacteristicSpecification addCharSpecRelationshipItem(CharacteristicSpecificationRelationship charSpecRelationshipItem) {
        if (this.charSpecRelationship == null) {
            this.charSpecRelationship = new HashSet<CharacteristicSpecificationRelationship>();
        }
        this.charSpecRelationship.add(charSpecRelationshipItem);
        return this;
    }

    @Schema(description="An aggregation, migration, substitution, dependency or exclusivity relationship between/among Specification Characteristics.")
    @Valid
    public Set<CharacteristicSpecificationRelationship> getCharSpecRelationship() {
        return this.charSpecRelationship;
    }

    public void setCharSpecRelationship(Set<CharacteristicSpecificationRelationship> charSpecRelationship) {
        this.charSpecRelationship = charSpecRelationship;
    }

    public CharacteristicSpecification characteristicValueSpecification(Set<CharacteristicValueSpecification> characteristicValueSpecification) {
        this.characteristicValueSpecification = characteristicValueSpecification;
        return this;
    }

    public CharacteristicSpecification addCharacteristicValueSpecificationItem(CharacteristicValueSpecification characteristicValueSpecificationItem) {
        if (this.characteristicValueSpecification == null) {
            this.characteristicValueSpecification = new HashSet<CharacteristicValueSpecification>();
        }
        this.characteristicValueSpecification.add(characteristicValueSpecificationItem);
        return this;
    }

    @Schema(description="A CharacteristicValueSpecification object is used to define a set of attributes, each of which can be assigned to a corresponding set of attributes in a CharacteristicSpecification object. The values of the attributes in the CharacteristicValueSpecification object describe the values of the attributes that a corresponding Characteristic object can take on.")
    @Valid
    public Set<CharacteristicValueSpecification> getCharacteristicValueSpecification() {
        return this.characteristicValueSpecification;
    }

    public void setCharacteristicValueSpecification(Set<CharacteristicValueSpecification> characteristicValueSpecification) {
        this.characteristicValueSpecification = characteristicValueSpecification;
    }

    public CharacteristicSpecification validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public CharacteristicSpecification _atValueSchemaLocation(String _atValueSchemaLocation) {
        this._atValueSchemaLocation = _atValueSchemaLocation;
        return this;
    }

    @Schema(description="This (optional) field provides a link to the schema describing the value type.")
    public String getAtValueSchemaLocation() {
        return this._atValueSchemaLocation;
    }

    public void setAtValueSchemaLocation(String _atValueSchemaLocation) {
        this._atValueSchemaLocation = _atValueSchemaLocation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharacteristicSpecification characteristicSpecification = (CharacteristicSpecification)o;
        return Objects.equals(this.id, characteristicSpecification.id) && Objects.equals(this.configurable, characteristicSpecification.configurable) && Objects.equals(this.description, characteristicSpecification.description) && Objects.equals(this.extensible, characteristicSpecification.extensible) && Objects.equals(this.isUnique, characteristicSpecification.isUnique) && Objects.equals(this.maxCardinality, characteristicSpecification.maxCardinality) && Objects.equals(this.minCardinality, characteristicSpecification.minCardinality) && Objects.equals(this.name, characteristicSpecification.name) && Objects.equals(this.regex, characteristicSpecification.regex) && Objects.equals(this.valueType, characteristicSpecification.valueType) && Objects.equals(this.charSpecRelationship, characteristicSpecification.charSpecRelationship) && Objects.equals(this.characteristicValueSpecification, characteristicSpecification.characteristicValueSpecification) && Objects.equals(this.validFor, characteristicSpecification.validFor) && Objects.equals(this.baseType, characteristicSpecification.baseType) && Objects.equals(this.schemaLocation, characteristicSpecification.baseType) && Objects.equals(this.type, characteristicSpecification.type) && Objects.equals(this._atValueSchemaLocation, characteristicSpecification._atValueSchemaLocation);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CharacteristicSpecification {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    configurable: ").append(this.toIndentedString(this.configurable)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    extensible: ").append(this.toIndentedString(this.extensible)).append("\n");
        sb.append("    isUnique: ").append(this.toIndentedString(this.isUnique)).append("\n");
        sb.append("    maxCardinality: ").append(this.toIndentedString(this.maxCardinality)).append("\n");
        sb.append("    minCardinality: ").append(this.toIndentedString(this.minCardinality)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    regex: ").append(this.toIndentedString(this.regex)).append("\n");
        sb.append("    valueType: ").append(this.toIndentedString(this.valueType)).append("\n");
        sb.append("    charSpecRelationship: ").append(this.toIndentedString(this.charSpecRelationship)).append("\n");
        sb.append("    characteristicValueSpecification: ").append(this.toIndentedString(this.characteristicValueSpecification)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    _atValueSchemaLocation: ").append(this.toIndentedString(this._atValueSchemaLocation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public void updateWith(CharacteristicSpecification src) {
        this.name = src.getName();
        this.description = src.getDescription();
        this.maxCardinality = src.getMaxCardinality();
        this.minCardinality = src.getMinCardinality();
        this.regex = src.getRegex();
        this.isUnique = src.isUnique;
        this.configurable = src.isConfigurable();
        this.extensible = src.isExtensible();
        this.valueType = src.valueType;
        this.updateServiceSpecCharacteristicValues(src.getCharacteristicValueSpecification());
        this.updateServiceSpecCharRelationships(src.getCharSpecRelationship());
    }

    private void updateServiceSpecCharacteristicValues(@Valid Set<CharacteristicValueSpecification> srcSet) {
        HashMap<Integer, Boolean> idAddedUpdated = new HashMap<Integer, Boolean>();
        for (CharacteristicValueSpecification r : srcSet) {
            boolean valueExists = false;
            for (CharacteristicValueSpecification thisCharVal : this.characteristicValueSpecification) {
                if (thisCharVal.hashCode() != r.hashCode()) continue;
                valueExists = true;
                idAddedUpdated.put(thisCharVal.hashCode(), true);
                break;
            }
            if (valueExists) continue;
            CharacteristicValueSpecification nr = new CharacteristicValueSpecification(r);
            this.addServiceSpecCharacteristicValueItem(nr);
            idAddedUpdated.put(nr.hashCode(), true);
        }
        ArrayList<CharacteristicValueSpecification> toRemove = new ArrayList<CharacteristicValueSpecification>();
        for (CharacteristicValueSpecification ss : this.characteristicValueSpecification) {
            if (idAddedUpdated.get(ss.hashCode()) != null) continue;
            toRemove.add(ss);
        }
        for (CharacteristicValueSpecification r : toRemove) {
            this.characteristicValueSpecification.remove(r);
        }
    }

    private CharacteristicSpecification addServiceSpecCharacteristicValueItem(CharacteristicValueSpecification nr) {
        if (this.characteristicValueSpecification == null) {
            this.characteristicValueSpecification = new HashSet<CharacteristicValueSpecification>();
        }
        this.characteristicValueSpecification.add(nr);
        return this;
    }

    private void updateServiceSpecCharRelationships(@Valid Set<CharacteristicSpecificationRelationship> srcSet) {
        HashMap<String, Boolean> idAddedUpdated = new HashMap<String, Boolean>();
        for (CharacteristicSpecificationRelationship r : srcSet) {
            boolean valueExists = false;
            for (CharacteristicSpecificationRelationship thisCharVal : this.charSpecRelationship) {
                if (thisCharVal.getCharacteristicSpecificationId() == null || !thisCharVal.getCharacteristicSpecificationId().equals(r.getCharacteristicSpecificationId())) continue;
                valueExists = true;
                idAddedUpdated.put(thisCharVal.getCharacteristicSpecificationId(), true);
                break;
            }
            if (valueExists) continue;
            this.charSpecRelationship.add(new CharacteristicSpecificationRelationship(r));
            idAddedUpdated.put(r.getCharacteristicSpecificationId(), true);
        }
        ArrayList<CharacteristicSpecificationRelationship> toRemove = new ArrayList<CharacteristicSpecificationRelationship>();
        for (CharacteristicSpecificationRelationship ss : this.charSpecRelationship) {
            if (idAddedUpdated.get(ss.getCharacteristicSpecificationId()) != null) continue;
            toRemove.add(ss);
        }
        for (CharacteristicSpecificationRelationship r : toRemove) {
            this.charSpecRelationship.remove(r);
        }
    }
}

