/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.stm653.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.Any;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.stm653.model.CharacteristicRelationship;
import org.springframework.validation.annotation.Validated;

@Schema(description="Describes a given characteristic of an object or entity through a name/value pair.")
@Validated
@Entity(name="STMCharacteristic")
@Table(name="STMCharacteristic")
public class Characteristic
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="valueType")
    private String valueType = null;
    @JsonProperty(value="characteristicRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<CharacteristicRelationship> characteristicRelationship = null;
    @JsonProperty(value="value")
    private Any value = null;

    public Characteristic() {
    }

    public Characteristic(Characteristic src) {
        this.name = src.name;
        this.valueType = src.valueType;
    }

    public String getId() {
        if (this.uuid != null) {
            this.id = this.uuid;
        }
        return this.id;
    }

    @Override
    public Characteristic name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="Name of the characteristic")
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Characteristic valueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    @Schema(description="Data type of the value of the characteristic")
    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public Characteristic characteristicRelationship(Set<CharacteristicRelationship> characteristicRelationship) {
        this.characteristicRelationship = characteristicRelationship;
        return this;
    }

    public Characteristic addCharacteristicRelationshipItem(CharacteristicRelationship characteristicRelationshipItem) {
        if (this.characteristicRelationship == null) {
            this.characteristicRelationship = new HashSet<CharacteristicRelationship>();
        }
        this.characteristicRelationship.add(characteristicRelationshipItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<CharacteristicRelationship> getCharacteristicRelationship() {
        return this.characteristicRelationship;
    }

    public void setCharacteristicRelationship(Set<CharacteristicRelationship> characteristicRelationship) {
        this.characteristicRelationship = characteristicRelationship;
    }

    public Characteristic value(Any value) {
        this.value = value;
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public Any getValue() {
        return this.value;
    }

    public void setValue(Any value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Characteristic characteristic = (Characteristic)o;
        return Objects.equals(this.id, characteristic.id) && Objects.equals(this.name, characteristic.name) && Objects.equals(this.valueType, characteristic.valueType) && Objects.equals(this.characteristicRelationship, characteristic.characteristicRelationship) && Objects.equals(this.value, characteristic.value) && Objects.equals(this.baseType, characteristic.baseType) && Objects.equals(this.schemaLocation, characteristic.schemaLocation) && Objects.equals(this.type, characteristic.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Characteristic {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    valueType: ").append(this.toIndentedString(this.valueType)).append("\n");
        sb.append("    characteristicRelationship: ").append(this.toIndentedString(this.characteristicRelationship)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

