/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.stm653.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="An Applied Consequence defines the action (prescribed action or notification) to take when a  MeasureThresholdRuleViolation occurs.")
@Validated
@Entity(name="STMAppliedConsequence")
@Table(name="STMAppliedConsequence")
public class AppliedConsequence
extends BaseRootNamedEntity {
    @JsonProperty(value="appliedAction")
    private String appliedAction = null;
    @Lob
    @Column(name="LDESCRIPTION", columnDefinition="LONGTEXT")
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="repeatAction")
    private Boolean repeatAction = null;

    public AppliedConsequence appliedAction(String appliedAction) {
        this.appliedAction = appliedAction;
        return this;
    }

    @Schema(description="The action for a violated threshold. This could be a hyperlink to  the action.")
    public String getAppliedAction() {
        return this.appliedAction;
    }

    public void setAppliedAction(String appliedAction) {
        this.appliedAction = appliedAction;
    }

    public AppliedConsequence description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A narrative that explains in detail what the consequence is.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public AppliedConsequence name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="A word, term, or phrase by which Consequence is known and  distinguished from other MetricDefMeasureConsequences.")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public AppliedConsequence repeatAction(Boolean repeatAction) {
        this.repeatAction = repeatAction;
        return this;
    }

    @Schema(description="An indicator used to specify that a consequence should cease  being applied if a value is in the same range as the previous value or continue being applied if a value is in the same range as the previous value.   If the repeatAction is True, if the consequence is always applied as soon as the MetricMeasure value is in the range of values and if the repeatAction is False, the consequence is applied only if the previous MetricMeasure value was not in the same range.")
    public Boolean isRepeatAction() {
        return this.repeatAction;
    }

    public void setRepeatAction(Boolean repeatAction) {
        this.repeatAction = repeatAction;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppliedConsequence appliedConsequence = (AppliedConsequence)o;
        return Objects.equals(this.appliedAction, appliedConsequence.appliedAction) && Objects.equals(this.description, appliedConsequence.description) && Objects.equals(this.name, appliedConsequence.name) && Objects.equals(this.repeatAction, appliedConsequence.repeatAction) && Objects.equals(this.baseType, appliedConsequence.baseType) && Objects.equals(this.schemaLocation, appliedConsequence.schemaLocation) && Objects.equals(this.type, appliedConsequence.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppliedConsequence {\n");
        sb.append("    appliedAction: ").append(this.toIndentedString(this.appliedAction)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    repeatAction: ").append(this.toIndentedString(this.repeatAction)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

