/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.sqm657.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.sqm657.model.ServiceLevelObjectiveRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="A Service Level Specification represents a pre-defined or negotiated set of Service Level  Objectives. In addition, certain consequences are associated with not meeting the Service Level  Objectives. Service Level Agreements are expressed in terms of Service Level Specifications. Skipped properties: id,href,id,href,validFor")
@Validated
public class ServiceLevelSpecificationUpdate {
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="objective")
    @Valid
    private List<ServiceLevelObjectiveRef> objective = null;
    @JsonProperty(value="@type")
    private String type = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;

    public ServiceLevelSpecificationUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A brief introduction of a service level specification.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ServiceLevelSpecificationUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The name of Service Level Specification")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ServiceLevelSpecificationUpdate objective(List<ServiceLevelObjectiveRef> objective) {
        this.objective = objective;
        return this;
    }

    public ServiceLevelSpecificationUpdate addObjectiveItem(ServiceLevelObjectiveRef objectiveItem) {
        if (this.objective == null) {
            this.objective = new ArrayList<ServiceLevelObjectiveRef>();
        }
        this.objective.add(objectiveItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<ServiceLevelObjectiveRef> getObjective() {
        return this.objective;
    }

    public void setObjective(List<ServiceLevelObjectiveRef> objective) {
        this.objective = objective;
    }

    public ServiceLevelSpecificationUpdate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="The class type of the actual resource (for type extension).")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ServiceLevelSpecificationUpdate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A link to the schema describing a resource (for type extension).")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ServiceLevelSpecificationUpdate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="The base type for use in polymorphic collections")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceLevelSpecificationUpdate serviceLevelSpecificationUpdate = (ServiceLevelSpecificationUpdate)o;
        return Objects.equals(this.description, serviceLevelSpecificationUpdate.description) && Objects.equals(this.name, serviceLevelSpecificationUpdate.name) && Objects.equals(this.objective, serviceLevelSpecificationUpdate.objective) && Objects.equals(this.type, serviceLevelSpecificationUpdate.type) && Objects.equals(this.schemaLocation, serviceLevelSpecificationUpdate.schemaLocation) && Objects.equals(this.baseType, serviceLevelSpecificationUpdate.baseType);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.name, this.objective, this.type, this.schemaLocation, this.baseType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceLevelSpecificationUpdate {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    objective: ").append(this.toIndentedString(this.objective)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

