/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.sqm657.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.sqm657.model.ServiceLevelObjectiveRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="A Service Level Specification represents a pre-defined or negotiated set of Service Level  Objectives. In addition, certain consequences are associated with not meeting the Service Level  Objectives. Service Level Agreements are expressed in terms of Service Level Specifications. Skipped properties: id,href")
@Validated
public class ServiceLevelSpecificationCreate {
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="objective")
    @Valid
    private List<ServiceLevelObjectiveRef> objective = new ArrayList<ServiceLevelObjectiveRef>();
    @JsonProperty(value="@type")
    private String type = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;

    public ServiceLevelSpecificationCreate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A brief introduction of a service level specification.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ServiceLevelSpecificationCreate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The name of Service Level Specification")
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ServiceLevelSpecificationCreate validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="A valid duration of a thing.")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ServiceLevelSpecificationCreate objective(List<ServiceLevelObjectiveRef> objective) {
        this.objective = objective;
        return this;
    }

    public ServiceLevelSpecificationCreate addObjectiveItem(ServiceLevelObjectiveRef objectiveItem) {
        this.objective.add(objectiveItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public List<ServiceLevelObjectiveRef> getObjective() {
        return this.objective;
    }

    public void setObjective(List<ServiceLevelObjectiveRef> objective) {
        this.objective = objective;
    }

    public ServiceLevelSpecificationCreate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="The class type of the actual resource (for type extension).")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ServiceLevelSpecificationCreate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A link to the schema describing a resource (for type extension).")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ServiceLevelSpecificationCreate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="The base type for use in polymorphic collections")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceLevelSpecificationCreate serviceLevelSpecificationCreate = (ServiceLevelSpecificationCreate)o;
        return Objects.equals(this.description, serviceLevelSpecificationCreate.description) && Objects.equals(this.name, serviceLevelSpecificationCreate.name) && Objects.equals(this.validFor, serviceLevelSpecificationCreate.validFor) && Objects.equals(this.objective, serviceLevelSpecificationCreate.objective) && Objects.equals(this.type, serviceLevelSpecificationCreate.type) && Objects.equals(this.schemaLocation, serviceLevelSpecificationCreate.schemaLocation) && Objects.equals(this.baseType, serviceLevelSpecificationCreate.baseType);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.name, this.validFor, this.objective, this.type, this.schemaLocation, this.baseType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceLevelSpecificationCreate {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    objective: ").append(this.toIndentedString(this.objective)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

