/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.sqm657.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.sqm657.model.ServiceLevelObjectiveRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="A Service Level Specification represents a pre-defined or negotiated set of Service Level  Objectives. In addition, certain consequences are associated with not meeting the Service Level  Objectives. Service Level Agreements are expressed in terms of Service Level Specifications.")
@Validated
public class ServiceLevelSpecification {
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="objective")
    @Valid
    private List<ServiceLevelObjectiveRef> objective = null;
    @JsonProperty(value="@type")
    private String type = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;

    public ServiceLevelSpecification description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A brief introduction of a service level specification.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ServiceLevelSpecification href(String href) {
        this.href = href;
        return this;
    }

    @Schema(description="The hyperlink to access a service level specification.")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public ServiceLevelSpecification id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="The identifier to a service level specification.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ServiceLevelSpecification name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The name of Service Level Specification")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ServiceLevelSpecification validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="A valid duration of a thing.")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ServiceLevelSpecification objective(List<ServiceLevelObjectiveRef> objective) {
        this.objective = objective;
        return this;
    }

    public ServiceLevelSpecification addObjectiveItem(ServiceLevelObjectiveRef objectiveItem) {
        if (this.objective == null) {
            this.objective = new ArrayList<ServiceLevelObjectiveRef>();
        }
        this.objective.add(objectiveItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<ServiceLevelObjectiveRef> getObjective() {
        return this.objective;
    }

    public void setObjective(List<ServiceLevelObjectiveRef> objective) {
        this.objective = objective;
    }

    public ServiceLevelSpecification type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="The class type of the actual resource (for type extension).")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ServiceLevelSpecification schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A link to the schema describing a resource (for type extension).")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ServiceLevelSpecification baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="The base type for use in polymorphic collections")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceLevelSpecification serviceLevelSpecification = (ServiceLevelSpecification)o;
        return Objects.equals(this.description, serviceLevelSpecification.description) && Objects.equals(this.href, serviceLevelSpecification.href) && Objects.equals(this.id, serviceLevelSpecification.id) && Objects.equals(this.name, serviceLevelSpecification.name) && Objects.equals(this.validFor, serviceLevelSpecification.validFor) && Objects.equals(this.objective, serviceLevelSpecification.objective) && Objects.equals(this.type, serviceLevelSpecification.type) && Objects.equals(this.schemaLocation, serviceLevelSpecification.schemaLocation) && Objects.equals(this.baseType, serviceLevelSpecification.baseType);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.href, this.id, this.name, this.validFor, this.objective, this.type, this.schemaLocation, this.baseType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceLevelSpecification {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    objective: ").append(this.toIndentedString(this.objective)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

