/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.sqm657.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.sqm657.model.EntityRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="Service Level Specification parameters can be one of two types. A Key Quality Indicator (KQI)  provides a measurement of a specific aspect of the performance of a Product (i.e., Product  Specification, Product Offering, or Product) or a Service (i.e., Service Specification or Service).")
@Validated
public class ServiceLevelSpecParameter {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="serviceParmCategory")
    private String serviceParmCategory = null;
    @JsonProperty(value="serviceParmPerspective")
    private String serviceParmPerspective = null;
    @JsonProperty(value="transformationAlgorithmOfKQI")
    private String transformationAlgorithmOfKQI = null;
    @JsonProperty(value="type")
    private String paramtype = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="relatedEntity")
    @Valid
    private List<EntityRef> relatedEntity = new ArrayList<EntityRef>();
    @JsonProperty(value="@type")
    private String type = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;

    public ServiceLevelSpecParameter name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The name of parameter.")
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ServiceLevelSpecParameter serviceParmCategory(String serviceParmCategory) {
        this.serviceParmCategory = serviceParmCategory;
        return this;
    }

    @Schema(description="A string that specifies whether the Service Level Specification Parameter is technology specific, service specific, or technology/service independent")
    public String getServiceParmCategory() {
        return this.serviceParmCategory;
    }

    public void setServiceParmCategory(String serviceParmCategory) {
        this.serviceParmCategory = serviceParmCategory;
    }

    public ServiceLevelSpecParameter serviceParmPerspective(String serviceParmPerspective) {
        this.serviceParmPerspective = serviceParmPerspective;
        return this;
    }

    @Schema(description="A string that specifies whether the Service Level Specification  Parameter represents a single user instance parameter or a parameter that represents an aggregation.")
    public String getServiceParmPerspective() {
        return this.serviceParmPerspective;
    }

    public void setServiceParmPerspective(String serviceParmPerspective) {
        this.serviceParmPerspective = serviceParmPerspective;
    }

    public ServiceLevelSpecParameter transformationAlgorithmOfKQI(String transformationAlgorithmOfKQI) {
        this.transformationAlgorithmOfKQI = transformationAlgorithmOfKQI;
        return this;
    }

    @Schema(description="The description of a logical step-by-step procedure used to  calculate the value of a KQI.")
    public String getTransformationAlgorithmOfKQI() {
        return this.transformationAlgorithmOfKQI;
    }

    public void setTransformationAlgorithmOfKQI(String transformationAlgorithmOfKQI) {
        this.transformationAlgorithmOfKQI = transformationAlgorithmOfKQI;
    }

    public ServiceLevelSpecParameter paramtype(String type) {
        this.paramtype = type;
        return this;
    }

    @Schema(description="Types of Service Level Specification parameters are KQI or KPI.")
    public String getParamtype() {
        return this.paramtype;
    }

    public void setParamtype(String type) {
        this.paramtype = type;
    }

    public ServiceLevelSpecParameter validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="A valid duration of a thing.")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ServiceLevelSpecParameter relatedEntity(List<EntityRef> relatedEntity) {
        this.relatedEntity = relatedEntity;
        return this;
    }

    public ServiceLevelSpecParameter addRelatedEntityItem(EntityRef relatedEntityItem) {
        this.relatedEntity.add(relatedEntityItem);
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public List<EntityRef> getRelatedEntity() {
        return this.relatedEntity;
    }

    public void setRelatedEntity(List<EntityRef> relatedEntity) {
        this.relatedEntity = relatedEntity;
    }

    public ServiceLevelSpecParameter type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="The class type of the actual resource (for type extension).")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ServiceLevelSpecParameter schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A link to the schema describing a resource (for type extension).")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ServiceLevelSpecParameter baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="The base type for use in polymorphic collections")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceLevelSpecParameter serviceLevelSpecParameter = (ServiceLevelSpecParameter)o;
        return Objects.equals(this.name, serviceLevelSpecParameter.name) && Objects.equals(this.serviceParmCategory, serviceLevelSpecParameter.serviceParmCategory) && Objects.equals(this.serviceParmPerspective, serviceLevelSpecParameter.serviceParmPerspective) && Objects.equals(this.transformationAlgorithmOfKQI, serviceLevelSpecParameter.transformationAlgorithmOfKQI) && Objects.equals(this.type, serviceLevelSpecParameter.type) && Objects.equals(this.validFor, serviceLevelSpecParameter.validFor) && Objects.equals(this.relatedEntity, serviceLevelSpecParameter.relatedEntity) && Objects.equals(this.type, serviceLevelSpecParameter.type) && Objects.equals(this.schemaLocation, serviceLevelSpecParameter.schemaLocation) && Objects.equals(this.baseType, serviceLevelSpecParameter.baseType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.serviceParmCategory, this.serviceParmPerspective, this.transformationAlgorithmOfKQI, this.type, this.validFor, this.relatedEntity, this.type, this.schemaLocation, this.baseType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceLevelSpecParameter {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    serviceParmCategory: ").append(this.toIndentedString(this.serviceParmCategory)).append("\n");
        sb.append("    serviceParmPerspective: ").append(this.toIndentedString(this.serviceParmPerspective)).append("\n");
        sb.append("    transformationAlgorithmOfKQI: ").append(this.toIndentedString(this.transformationAlgorithmOfKQI)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    relatedEntity: ").append(this.toIndentedString(this.relatedEntity)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

