/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.sqm657.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="Some consequences for the provider of the Service are resulted when the service level objective does not meet.")
@Validated
public class ServiceLevelSpecConsequence {
    @JsonProperty(value="prescribedAction")
    private String prescribedAction = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="@type")
    private String type = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;

    public ServiceLevelSpecConsequence prescribedAction(String prescribedAction) {
        this.prescribedAction = prescribedAction;
        return this;
    }

    @Schema(description="Recommended remedy for a violated Service Level Objective.  This could be a hyperlink to the recommended action.")
    public String getPrescribedAction() {
        return this.prescribedAction;
    }

    public void setPrescribedAction(String prescribedAction) {
        this.prescribedAction = prescribedAction;
    }

    public ServiceLevelSpecConsequence validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="A valid duration of a thing.")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ServiceLevelSpecConsequence type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="The class type of the actual resource (for type extension).")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ServiceLevelSpecConsequence schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A link to the schema describing a resource (for type extension).")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ServiceLevelSpecConsequence baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="The base type for use in polymorphic collections")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceLevelSpecConsequence serviceLevelSpecConsequence = (ServiceLevelSpecConsequence)o;
        return Objects.equals(this.prescribedAction, serviceLevelSpecConsequence.prescribedAction) && Objects.equals(this.validFor, serviceLevelSpecConsequence.validFor) && Objects.equals(this.type, serviceLevelSpecConsequence.type) && Objects.equals(this.schemaLocation, serviceLevelSpecConsequence.schemaLocation) && Objects.equals(this.baseType, serviceLevelSpecConsequence.baseType);
    }

    public int hashCode() {
        return Objects.hash(this.prescribedAction, this.validFor, this.type, this.schemaLocation, this.baseType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceLevelSpecConsequence {\n");
        sb.append("    prescribedAction: ").append(this.toIndentedString(this.prescribedAction)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

