/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.sqm657.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Schema(description="A set of Service Level Objectives that are contained in the Service Level Specification.")
@Validated
public class ServiceLevelObjectiveRef {
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="@referredType")
    private String referredType = null;

    public ServiceLevelObjectiveRef href(String href) {
        this.href = href;
        return this;
    }

    @Schema(description="The hyperlink to access a service level object.")
    @NotNull
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public ServiceLevelObjectiveRef id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="The identifier of a service level object.")
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ServiceLevelObjectiveRef referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceLevelObjectiveRef serviceLevelObjectiveRef = (ServiceLevelObjectiveRef)o;
        return Objects.equals(this.href, serviceLevelObjectiveRef.href) && Objects.equals(this.id, serviceLevelObjectiveRef.id) && Objects.equals(this.referredType, serviceLevelObjectiveRef.referredType);
    }

    public int hashCode() {
        return Objects.hash(this.href, this.id, this.referredType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceLevelObjectiveRef {\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

