/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.sqm657.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.sqm657.model.ServiceLevelSpecConsequence;
import org.etsi.osl.tmf.sqm657.model.ServiceLevelSpecParameter;
import org.springframework.validation.annotation.Validated;

@Schema(description="Service level objectives are defined in terms of parameters and metrics, thresholds, and tolerances  associated with the parameters.")
@Validated
public class ServiceLevelObjective {
    @JsonProperty(value="conformanceComparator")
    private String conformanceComparator = null;
    @JsonProperty(value="conformancePeriod")
    private TimePeriod conformancePeriod = null;
    @JsonProperty(value="conformanceTarget")
    private String conformanceTarget = null;
    @JsonProperty(value="graceTimes")
    private String graceTimes = null;
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="thresholdTarget")
    private String thresholdTarget = null;
    @JsonProperty(value="tolerancePeriod")
    private TimePeriod tolerancePeriod = null;
    @JsonProperty(value="toleranceTarget")
    private String toleranceTarget = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="specParameter")
    private ServiceLevelSpecParameter specParameter = null;
    @JsonProperty(value="specConsequence")
    @Valid
    private List<ServiceLevelSpecConsequence> specConsequence = null;
    @JsonProperty(value="@type")
    private String type = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;

    public ServiceLevelObjective conformanceComparator(String conformanceComparator) {
        this.conformanceComparator = conformanceComparator;
        return this;
    }

    @Schema(description="An operator that specifies whether a Service Level Objective is  violated above or below the conformanceTarget.")
    public String getConformanceComparator() {
        return this.conformanceComparator;
    }

    public void setConformanceComparator(String conformanceComparator) {
        this.conformanceComparator = conformanceComparator;
    }

    public ServiceLevelObjective conformancePeriod(TimePeriod conformancePeriod) {
        this.conformancePeriod = conformancePeriod;
        return this;
    }

    @Schema(description="An interval of time during which the Conformance Target must be measured.")
    @Valid
    public TimePeriod getConformancePeriod() {
        return this.conformancePeriod;
    }

    public void setConformancePeriod(TimePeriod conformancePeriod) {
        this.conformancePeriod = conformancePeriod;
    }

    public ServiceLevelObjective conformanceTarget(String conformanceTarget) {
        this.conformanceTarget = conformanceTarget;
        return this;
    }

    @Schema(description="A value used to determine if Service Level Objective is met.  The data type should be adjusted case by case.")
    public String getConformanceTarget() {
        return this.conformanceTarget;
    }

    public void setConformanceTarget(String conformanceTarget) {
        this.conformanceTarget = conformanceTarget;
    }

    public ServiceLevelObjective graceTimes(String graceTimes) {
        this.graceTimes = graceTimes;
        return this;
    }

    @Schema(description="The number of times an objective can remain un-updated without  a violation of a Service Level Agreement in reference to a measurement period and/or Service Level Agreement reporting period.")
    public String getGraceTimes() {
        return this.graceTimes;
    }

    public void setGraceTimes(String graceTimes) {
        this.graceTimes = graceTimes;
    }

    public ServiceLevelObjective href(String href) {
        this.href = href;
        return this;
    }

    @Schema(description="The hyperlink to access a service level objective.")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public ServiceLevelObjective id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="The identifier of a service level objectives.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ServiceLevelObjective name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The name of the service level objectives.")
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ServiceLevelObjective thresholdTarget(String thresholdTarget) {
        this.thresholdTarget = thresholdTarget;
        return this;
    }

    @Schema(description="A value that used to specify when a warning should be used  that indicates an objective is danger of not being met. Notice, the data type should be adjusted case by case.")
    public String getThresholdTarget() {
        return this.thresholdTarget;
    }

    public void setThresholdTarget(String thresholdTarget) {
        this.thresholdTarget = thresholdTarget;
    }

    public ServiceLevelObjective tolerancePeriod(TimePeriod tolerancePeriod) {
        this.tolerancePeriod = tolerancePeriod;
        return this;
    }

    @Schema(description="")
    @Valid
    public TimePeriod getTolerancePeriod() {
        return this.tolerancePeriod;
    }

    public void setTolerancePeriod(TimePeriod tolerancePeriod) {
        this.tolerancePeriod = tolerancePeriod;
    }

    public ServiceLevelObjective toleranceTarget(String toleranceTarget) {
        this.toleranceTarget = toleranceTarget;
        return this;
    }

    @Schema(description="A value that specifies the allowable variation of a conformance  Target. The data type should be adjusted case by case.")
    public String getToleranceTarget() {
        return this.toleranceTarget;
    }

    public void setToleranceTarget(String toleranceTarget) {
        this.toleranceTarget = toleranceTarget;
    }

    public ServiceLevelObjective validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="A valid duration of a thing.")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ServiceLevelObjective specParameter(ServiceLevelSpecParameter specParameter) {
        this.specParameter = specParameter;
        return this;
    }

    @Schema(description="")
    @Valid
    public ServiceLevelSpecParameter getSpecParameter() {
        return this.specParameter;
    }

    public void setSpecParameter(ServiceLevelSpecParameter specParameter) {
        this.specParameter = specParameter;
    }

    public ServiceLevelObjective specConsequence(List<ServiceLevelSpecConsequence> specConsequence) {
        this.specConsequence = specConsequence;
        return this;
    }

    public ServiceLevelObjective addSpecConsequenceItem(ServiceLevelSpecConsequence specConsequenceItem) {
        if (this.specConsequence == null) {
            this.specConsequence = new ArrayList<ServiceLevelSpecConsequence>();
        }
        this.specConsequence.add(specConsequenceItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<ServiceLevelSpecConsequence> getSpecConsequence() {
        return this.specConsequence;
    }

    public void setSpecConsequence(List<ServiceLevelSpecConsequence> specConsequence) {
        this.specConsequence = specConsequence;
    }

    public ServiceLevelObjective type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="The class type of the actual resource (for type extension).")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ServiceLevelObjective schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A link to the schema describing a resource (for type extension).")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ServiceLevelObjective baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="The base type for use in polymorphic collections")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceLevelObjective serviceLevelObjective = (ServiceLevelObjective)o;
        return Objects.equals(this.conformanceComparator, serviceLevelObjective.conformanceComparator) && Objects.equals(this.conformancePeriod, serviceLevelObjective.conformancePeriod) && Objects.equals(this.conformanceTarget, serviceLevelObjective.conformanceTarget) && Objects.equals(this.graceTimes, serviceLevelObjective.graceTimes) && Objects.equals(this.href, serviceLevelObjective.href) && Objects.equals(this.id, serviceLevelObjective.id) && Objects.equals(this.name, serviceLevelObjective.name) && Objects.equals(this.thresholdTarget, serviceLevelObjective.thresholdTarget) && Objects.equals(this.tolerancePeriod, serviceLevelObjective.tolerancePeriod) && Objects.equals(this.toleranceTarget, serviceLevelObjective.toleranceTarget) && Objects.equals(this.validFor, serviceLevelObjective.validFor) && Objects.equals(this.specParameter, serviceLevelObjective.specParameter) && Objects.equals(this.specConsequence, serviceLevelObjective.specConsequence) && Objects.equals(this.type, serviceLevelObjective.type) && Objects.equals(this.schemaLocation, serviceLevelObjective.schemaLocation) && Objects.equals(this.baseType, serviceLevelObjective.baseType);
    }

    public int hashCode() {
        return Objects.hash(this.conformanceComparator, this.conformancePeriod, this.conformanceTarget, this.graceTimes, this.href, this.id, this.name, this.thresholdTarget, this.tolerancePeriod, this.toleranceTarget, this.validFor, this.specParameter, this.specConsequence, this.type, this.schemaLocation, this.baseType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceLevelObjective {\n");
        sb.append("    conformanceComparator: ").append(this.toIndentedString(this.conformanceComparator)).append("\n");
        sb.append("    conformancePeriod: ").append(this.toIndentedString(this.conformancePeriod)).append("\n");
        sb.append("    conformanceTarget: ").append(this.toIndentedString(this.conformanceTarget)).append("\n");
        sb.append("    graceTimes: ").append(this.toIndentedString(this.graceTimes)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    thresholdTarget: ").append(this.toIndentedString(this.thresholdTarget)).append("\n");
        sb.append("    tolerancePeriod: ").append(this.toIndentedString(this.tolerancePeriod)).append("\n");
        sb.append("    toleranceTarget: ").append(this.toIndentedString(this.toleranceTarget)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    specParameter: ").append(this.toIndentedString(this.specParameter)).append("\n");
        sb.append("    specConsequence: ").append(this.toIndentedString(this.specConsequence)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

