/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.sqm657.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Schema(description="The related entity source of a KQI or KPI. A KQI draws its data from a number of sources,  including Key Performance Indicators (KPIs).  A KPI provides a measurement of a specific aspect  of the performance of a Service (whether it is a network- or a non-network-based Service) or a  group of Services of the same type.")
@Validated
public class EntityRef {
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="@referredType")
    private String referredType = null;

    public EntityRef href(String href) {
        this.href = href;
        return this;
    }

    @Schema(description="The hyperlink to access an entity.")
    @NotNull
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public EntityRef id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="The identifier of an entity.")
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public EntityRef name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The name of an entity.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EntityRef referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityRef entityRef = (EntityRef)o;
        return Objects.equals(this.href, entityRef.href) && Objects.equals(this.id, entityRef.id) && Objects.equals(this.name, entityRef.name) && Objects.equals(this.referredType, entityRef.referredType);
    }

    public int hashCode() {
        return Objects.hash(this.href, this.id, this.name, this.referredType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntityRef {\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

