/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.so641.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.service.Characteristic;
import org.etsi.osl.tmf.common.model.service.Place;
import org.etsi.osl.tmf.common.model.service.ResourceRef;
import org.etsi.osl.tmf.common.model.service.ServiceRef;
import org.etsi.osl.tmf.common.model.service.ServiceRelationship;
import org.etsi.osl.tmf.common.model.service.ServiceSpecificationRef;
import org.etsi.osl.tmf.common.model.service.ServiceStateType;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.springframework.validation.annotation.Validated;

@Schema(description="In the context of a service order, and depending of the action requested (add/modify/delete/noChange) this data structure captures the configuration to apply to an existing subscribed service or to a new one")
@Validated
@Entity(name="ServiceRestriction")
public class ServiceRestriction
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="category")
    private String category = null;
    @JsonProperty(value="serviceType")
    private String serviceType = null;
    @OneToOne(cascade={CascadeType.ALL})
    private ServiceSpecificationRef serviceSpecificationRef = null;
    @JsonProperty(value="place")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<Place> place = new HashSet<Place>();
    @JsonProperty(value="relatedParty")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<RelatedParty> relatedParty = new HashSet<RelatedParty>();
    @JsonProperty(value="serviceCharacteristic")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<Characteristic> serviceCharacteristic = new HashSet<Characteristic>();
    @JsonProperty(value="state")
    private ServiceStateType state = ServiceStateType.FEASIBILITYCHECKED;
    @JsonProperty(value="supportingResource")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ResourceRef> supportingResource = new HashSet<ResourceRef>();
    @JsonProperty(value="serviceRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ServiceRelationship> serviceRelationship = new HashSet<ServiceRelationship>();
    @JsonProperty(value="supportingService")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ServiceRef> supportingService = new HashSet<ServiceRef>();

    @Schema(description="Unique identifier of the service")
    public String getId() {
        return this.uuid;
    }

    public ServiceRestriction category(String category) {
        this.category = category;
        return this;
    }

    @Schema(description="Is it a customer facing or resource facing service")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public ServiceRestriction serviceType(String serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @Schema(description="Business type of the service")
    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public ServiceRestriction place(Set<Place> place) {
        this.place = place;
        return this;
    }

    public ServiceRestriction addPlaceItem(Place placeItem) {
        if (this.place == null) {
            this.place = new HashSet<Place>();
        }
        this.place.add(placeItem);
        return this;
    }

    @Schema(description="A list of places (Place [*]). Used to define a place useful for the service (for example a delivery geographical place)")
    @Valid
    public Set<Place> getPlace() {
        return this.place;
    }

    public void setPlace(Set<Place> place) {
        this.place = place;
    }

    public ServiceRestriction relatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ServiceRestriction addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new HashSet<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="A list of related party references (RelatedParty [*]). A related party defines party or party role linked to a specific entity")
    @Valid
    public Set<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ServiceRestriction serviceCharacteristic(Set<Characteristic> serviceCharacteristic) {
        this.serviceCharacteristic = serviceCharacteristic;
        return this;
    }

    public ServiceRestriction addServiceCharacteristicItem(Characteristic serviceCharacteristicItem) {
        if (this.serviceCharacteristic == null) {
            this.serviceCharacteristic = new HashSet<Characteristic>();
        }
        this.serviceCharacteristic.add(serviceCharacteristicItem);
        return this;
    }

    @Schema(description="A list of characteristics that characterize this service (ServiceCharacteristic [*]) ")
    @Valid
    public Set<Characteristic> getServiceCharacteristic() {
        return this.serviceCharacteristic;
    }

    public void setServiceCharacteristic(Set<Characteristic> serviceCharacteristic) {
        this.serviceCharacteristic = serviceCharacteristic;
    }

    public ServiceRestriction serviceRelationship(Set<ServiceRelationship> serviceRelationship) {
        this.serviceRelationship = serviceRelationship;
        return this;
    }

    public ServiceRestriction addServiceRelationshipItem(ServiceRelationship serviceRelationshipItem) {
        if (this.serviceRelationship == null) {
            this.serviceRelationship = new HashSet<ServiceRelationship>();
        }
        this.serviceRelationship.add(serviceRelationshipItem);
        return this;
    }

    @Schema(description="A list of service relationships (ServiceRelationship [*]). Describes links with other service(s) in the inventory (useful for describing relies-on, relies-from between CFS for example).")
    @Valid
    public Set<ServiceRelationship> getServiceRelationship() {
        return this.serviceRelationship;
    }

    public void setServiceRelationship(Set<ServiceRelationship> serviceRelationship) {
        this.serviceRelationship = serviceRelationship;
    }

    @Schema(description="The specification from which this service was instantiated")
    @Valid
    public ServiceSpecificationRef getServiceSpecification() {
        return this.serviceSpecificationRef;
    }

    public void setServiceSpecification(ServiceSpecificationRef aServiceSpecificationRef) {
        this.serviceSpecificationRef = aServiceSpecificationRef;
        this.name = aServiceSpecificationRef.getName();
    }

    public ServiceRestriction state(ServiceStateType state) {
        this.state = state;
        return this;
    }

    @Schema(description="The life cycle state of the service, such as: [feasibilityChecked], [designed]")
    @Valid
    public ServiceStateType getState() {
        return this.state;
    }

    public void setState(ServiceStateType state) {
        this.state = state;
    }

    public ServiceRestriction supportingResource(Set<ResourceRef> supportingResource) {
        this.supportingResource = supportingResource;
        return this;
    }

    public ServiceRestriction addSupportingResourceItem(ResourceRef supportingResourceItem) {
        if (this.supportingResource == null) {
            this.supportingResource = new HashSet<ResourceRef>();
        }
        this.supportingResource.add(supportingResourceItem);
        return this;
    }

    @Schema(description="A list of supporting resources (SupportingResource [*]).Note: only Service of type RFS can be associated with Resources")
    @Valid
    public Set<ResourceRef> getSupportingResource() {
        return this.supportingResource;
    }

    public void setSupportingResource(Set<ResourceRef> supportingResource) {
        this.supportingResource = supportingResource;
    }

    public ServiceRestriction supportingService(Set<ServiceRef> supportingService) {
        this.supportingService = supportingService;
        return this;
    }

    public ServiceRestriction addSupportingServiceItem(ServiceRef supportingServiceItem) {
        if (this.supportingService == null) {
            this.supportingService = new HashSet<ServiceRef>();
        }
        this.supportingService.add(supportingServiceItem);
        return this;
    }

    @Schema(description="A list of supporting services (SupportingService [*]). A collection of services that support this service (bundling, link CFS to RFS)")
    @Valid
    public Set<ServiceRef> getSupportingService() {
        return this.supportingService;
    }

    public void setSupportingService(Set<ServiceRef> supportingService) {
        this.supportingService = supportingService;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceRestriction serviceRestriction = (ServiceRestriction)o;
        return Objects.equals(this.id, serviceRestriction.id) && Objects.equals(this.href, serviceRestriction.href) && Objects.equals(this.category, serviceRestriction.category) && Objects.equals(this.name, serviceRestriction.name) && Objects.equals(this.serviceType, serviceRestriction.serviceType) && Objects.equals(this.place, serviceRestriction.place) && Objects.equals(this.relatedParty, serviceRestriction.relatedParty) && Objects.equals(this.serviceCharacteristic, serviceRestriction.serviceCharacteristic) && Objects.equals(this.serviceRelationship, serviceRestriction.serviceRelationship) && Objects.equals(this.getServiceSpecification(), serviceRestriction.getServiceSpecification()) && Objects.equals((Object)this.state, (Object)serviceRestriction.state) && Objects.equals(this.supportingResource, serviceRestriction.supportingResource) && Objects.equals(this.supportingService, serviceRestriction.supportingService) && Objects.equals(this.baseType, serviceRestriction.baseType) && Objects.equals(this.schemaLocation, serviceRestriction.schemaLocation) && Objects.equals(this.type, serviceRestriction.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceRestriction {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    serviceType: ").append(this.toIndentedString(this.serviceType)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    serviceCharacteristic: ").append(this.toIndentedString(this.serviceCharacteristic)).append("\n");
        sb.append("    serviceRelationship: ").append(this.toIndentedString(this.serviceRelationship)).append("\n");
        sb.append("    serviceSpecification: ").append(this.toIndentedString(this.getServiceSpecification())).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    supportingResource: ").append(this.toIndentedString(this.supportingResource)).append("\n");
        sb.append("    supportingService: ").append(this.toIndentedString(this.supportingService)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public Object getSupportingServiceById(@NotNull String id) {
        for (ServiceRef sr : this.supportingService) {
            if (!sr.getId().equals(id)) continue;
            return sr;
        }
        return null;
    }

    public Object getSupportingResourceById(@NotNull String id) {
        for (ResourceRef sr : this.supportingResource) {
            if (!sr.getId().equals(id)) continue;
            return sr;
        }
        return null;
    }

    public Characteristic findCharacteristicByName(String aName) {
        for (Characteristic c : this.serviceCharacteristic) {
            if (!c.getName().equals(aName)) continue;
            return c;
        }
        return null;
    }
}

