/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.so641.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.service.Note;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.so641.model.ServiceOrderItem;
import org.etsi.osl.tmf.so641.model.ServiceOrderRelationship;
import org.etsi.osl.tmf.so641.model.ServiceOrderStateType;
import org.springframework.validation.annotation.Validated;

@Schema(description=" Skipped properties: id,href,externalId,priority,state,orderDate,completionDate,orderItem")
@Validated
public class ServiceOrderUpdate {
    @JsonProperty(value="category")
    private String category = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="notificationContact")
    private String notificationContact = null;
    private OffsetDateTime expectedCompletionDate = null;
    private OffsetDateTime requestedCompletionDate = null;
    private OffsetDateTime requestedStartDate = null;
    private OffsetDateTime startDate = null;
    @JsonProperty(value="note")
    @Valid
    private List<Note> note = null;
    @JsonProperty(value="orderRelationship")
    @Valid
    private List<ServiceOrderRelationship> orderRelationship = null;
    @JsonProperty(value="relatedParty")
    @Valid
    private List<RelatedParty> relatedParty = null;
    @JsonProperty(value="state")
    private ServiceOrderStateType state = null;
    @JsonProperty(value="orderItem")
    @Valid
    private List<ServiceOrderItem> orderItem = new ArrayList<ServiceOrderItem>();
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public ServiceOrderUpdate category(String category) {
        this.category = category;
        return this;
    }

    @Schema(description="Used to categorize the order, useful for the OM system, such as: Broadband, TVOption")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public ServiceOrderUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A free-text description of the service order")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ServiceOrderUpdate expectedCompletionDate(OffsetDateTime expectedCompletionDate) {
        this.expectedCompletionDate = expectedCompletionDate;
        return this;
    }

    @JsonProperty(value="expectedCompletionDate")
    public String getExpectedCompletionDateStr() {
        if (this.expectedCompletionDate != null) {
            return this.expectedCompletionDate.toString();
        }
        return this.baseType;
    }

    @Schema(description="Expected delivery date amended by the provider")
    @Valid
    public OffsetDateTime getExpectedCompletionDate() {
        return this.expectedCompletionDate;
    }

    public void setExpectedCompletionDate(OffsetDateTime expectedCompletionDate) {
        this.expectedCompletionDate = expectedCompletionDate;
    }

    public void setExpectedCompletionDate(String expectedCompletionDate) {
        if (expectedCompletionDate != null) {
            this.expectedCompletionDate = OffsetDateTime.parse(expectedCompletionDate);
        }
    }

    public ServiceOrderUpdate notificationContact(String notificationContact) {
        this.notificationContact = notificationContact;
        return this;
    }

    @Schema(description="Contact attached to the order to send back information regarding this order")
    public String getNotificationContact() {
        return this.notificationContact;
    }

    public void setNotificationContact(String notificationContact) {
        this.notificationContact = notificationContact;
    }

    public ServiceOrderUpdate requestedCompletionDate(OffsetDateTime requestedCompletionDate) {
        this.requestedCompletionDate = requestedCompletionDate;
        return this;
    }

    @Schema(description="Requested delivery date from the requestors perspective")
    @Valid
    public OffsetDateTime getRequestedCompletionDate() {
        return this.requestedCompletionDate;
    }

    @JsonProperty(value="requestedCompletionDate")
    public String getRequestedCompletionDateStr() {
        if (this.requestedCompletionDate != null) {
            return this.requestedCompletionDate.toString();
        }
        return null;
    }

    public void setRequestedCompletionDate(OffsetDateTime requestedCompletionDate) {
        this.requestedCompletionDate = requestedCompletionDate;
    }

    public ServiceOrderUpdate requestedStartDate(OffsetDateTime requestedStartDate) {
        this.requestedStartDate = requestedStartDate;
        return this;
    }

    public void setRequestedCompletionDate(String requestedCompletionDate) {
        if (requestedCompletionDate != null) {
            this.requestedCompletionDate = OffsetDateTime.parse(requestedCompletionDate);
        }
    }

    @Schema(description="Order start date wished by the requestor")
    @Valid
    public OffsetDateTime getRequestedStartDate() {
        return this.requestedStartDate;
    }

    @JsonProperty(value="requestedStartDate")
    public String getRequestedStartDateStr() {
        if (this.requestedStartDate != null) {
            return this.requestedStartDate.toString();
        }
        return null;
    }

    public void setRequestedStartDate(OffsetDateTime requestedStartDate) {
        this.requestedStartDate = requestedStartDate;
    }

    public void setRequestedStartDate(String requestedStartDate) {
        if (requestedStartDate != null) {
            this.requestedStartDate = OffsetDateTime.parse(requestedStartDate);
        }
    }

    public ServiceOrderUpdate startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Schema(description="Date when the order was started for processing")
    @Valid
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    public String getStartDateStr() {
        if (this.startDate != null) {
            return this.startDate.toString();
        }
        return null;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public void setStartDate(String startDate) {
        if (startDate != null) {
            this.startDate = OffsetDateTime.parse(startDate);
        }
    }

    public ServiceOrderUpdate note(List<Note> note) {
        this.note = note;
        return this;
    }

    public ServiceOrderUpdate addNoteItem(Note noteItem) {
        if (this.note == null) {
            this.note = new ArrayList<Note>();
        }
        this.note.add(noteItem);
        return this;
    }

    @Schema(description="Extra-information about the order; e.g. useful to add extra delivery information that could be useful for a human process")
    @Valid
    public List<Note> getNote() {
        return this.note;
    }

    public void setNote(List<Note> note) {
        this.note = note;
    }

    public ServiceOrderUpdate orderRelationship(List<ServiceOrderRelationship> orderRelationship) {
        this.orderRelationship = orderRelationship;
        return this;
    }

    public ServiceOrderUpdate addOrderRelationshipItem(ServiceOrderRelationship orderRelationshipItem) {
        if (this.orderRelationship == null) {
            this.orderRelationship = new ArrayList<ServiceOrderRelationship>();
        }
        this.orderRelationship.add(orderRelationshipItem);
        return this;
    }

    @Schema(description="A list of service orders related to this order (e.g. prerequisite, dependent on)")
    @Valid
    public List<ServiceOrderRelationship> getOrderRelationship() {
        return this.orderRelationship;
    }

    public void setOrderRelationship(List<ServiceOrderRelationship> orderRelationship) {
        this.orderRelationship = orderRelationship;
    }

    public ServiceOrderUpdate relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ServiceOrderUpdate addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="A list of parties which are involved in this order and the role they are playing")
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ServiceOrderUpdate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ServiceOrderUpdate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ServiceOrderUpdate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ServiceOrderStateType getState() {
        return this.state;
    }

    public ServiceOrderUpdate addOrderItemItem(ServiceOrderItem orderItemItem) {
        this.orderItem.add(orderItemItem);
        return this;
    }

    public List<ServiceOrderItem> getOrderItem() {
        return this.orderItem;
    }

    public void setOrderItem(List<ServiceOrderItem> orderItem) {
        this.orderItem = orderItem;
    }

    public void setState(ServiceOrderStateType state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceOrderUpdate serviceOrderUpdate = (ServiceOrderUpdate)o;
        return Objects.equals(this.category, serviceOrderUpdate.category) && Objects.equals(this.description, serviceOrderUpdate.description) && Objects.equals(this.expectedCompletionDate, serviceOrderUpdate.expectedCompletionDate) && Objects.equals(this.notificationContact, serviceOrderUpdate.notificationContact) && Objects.equals(this.requestedCompletionDate, serviceOrderUpdate.requestedCompletionDate) && Objects.equals(this.requestedStartDate, serviceOrderUpdate.requestedStartDate) && Objects.equals(this.startDate, serviceOrderUpdate.startDate) && Objects.equals(this.note, serviceOrderUpdate.note) && Objects.equals(this.orderRelationship, serviceOrderUpdate.orderRelationship) && Objects.equals(this.relatedParty, serviceOrderUpdate.relatedParty) && Objects.equals(this.baseType, serviceOrderUpdate.baseType) && Objects.equals(this.schemaLocation, serviceOrderUpdate.schemaLocation) && Objects.equals(this.type, serviceOrderUpdate.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceOrderUpdate {\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    expectedCompletionDate: ").append(this.toIndentedString(this.expectedCompletionDate)).append("\n");
        sb.append("    notificationContact: ").append(this.toIndentedString(this.notificationContact)).append("\n");
        sb.append("    requestedCompletionDate: ").append(this.toIndentedString(this.requestedCompletionDate)).append("\n");
        sb.append("    requestedStartDate: ").append(this.toIndentedString(this.requestedStartDate)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    orderRelationship: ").append(this.toIndentedString(this.orderRelationship)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

