/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.so641.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Linked service order to the one containing this attribute")
@Validated
@Entity(name="ServiceOrderRelationship")
public class ServiceOrderRelationship
extends BaseRootEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="relationshipType")
    private String relationshipType = null;
    @JsonProperty(value="@referredType")
    private String referredType = null;

    public ServiceOrderRelationship id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="The id of the related order")
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ServiceOrderRelationship relationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @Schema(description="The type of related order, such as: [dependency] if the order needs to be [not started] until another order item is complete (a service order in this case) or [cross-ref] to keep track of the source order (a productOrder)")
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    @Schema(description="The entity type of the related order")
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceOrderRelationship serviceOrderRelationship = (ServiceOrderRelationship)o;
        return Objects.equals(this.id, serviceOrderRelationship.id) && Objects.equals(this.href, serviceOrderRelationship.href) && Objects.equals(this.relationshipType, serviceOrderRelationship.relationshipType) && Objects.equals(this.baseType, serviceOrderRelationship.baseType) && Objects.equals(this.schemaLocation, serviceOrderRelationship.schemaLocation) && Objects.equals(this.type, serviceOrderRelationship.type) && Objects.equals(this.referredType, serviceOrderRelationship.referredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceOrderRelationship {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    relationshipType: ").append(this.toIndentedString(this.relationshipType)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

