/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.so641.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.so641.model.AppointmentRef;
import org.etsi.osl.tmf.so641.model.ServiceOrderActionType;
import org.etsi.osl.tmf.so641.model.ServiceOrderItemRelationship;
import org.etsi.osl.tmf.so641.model.ServiceOrderStateType;
import org.etsi.osl.tmf.so641.model.ServiceRestriction;
import org.springframework.validation.annotation.Validated;

@Validated
@Entity(name="ServiceOrderItem")
public class ServiceOrderItem
extends BaseRootEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="action")
    private ServiceOrderActionType action = ServiceOrderActionType.ADD;
    @JsonProperty(value="orderItemRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ServiceOrderItemRelationship> orderItemRelationship = new HashSet<ServiceOrderItemRelationship>();
    @JsonProperty(value="state")
    private ServiceOrderStateType state = ServiceOrderStateType.INITIAL;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="service_restrictuuid", referencedColumnName="uuid")
    @JsonProperty(value="service")
    private ServiceRestriction service = null;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="appointment_refid", referencedColumnName="uuid")
    @JsonProperty(value="appointment")
    private AppointmentRef appointment = null;

    @Schema(description="Identifier of the individual line item")
    public String getId() {
        return this.uuid;
    }

    public ServiceOrderItem action(ServiceOrderActionType action) {
        this.action = action;
        return this;
    }

    @Schema(description="The action to be carried out on the Service. Can be: add, modify, delete, noChange")
    @NotNull
    @Valid
    public ServiceOrderActionType getAction() {
        return this.action;
    }

    public void setAction(ServiceOrderActionType action) {
        this.action = action;
    }

    public ServiceOrderItem appointment(AppointmentRef appointment) {
        this.appointment = appointment;
        return this;
    }

    @Schema(description="An appointment that was set up with a related party for this order item")
    @Valid
    public AppointmentRef getAppointment() {
        return this.appointment;
    }

    public void setAppointment(AppointmentRef appointment) {
        this.appointment = appointment;
    }

    public ServiceOrderItem orderItemRelationship(Set<ServiceOrderItemRelationship> orderItemRelationship) {
        this.orderItemRelationship = orderItemRelationship;
        return this;
    }

    public ServiceOrderItem addOrderItemRelationshipItem(ServiceOrderItemRelationship orderItemRelationshipItem) {
        if (this.orderItemRelationship == null) {
            this.orderItemRelationship = new HashSet<ServiceOrderItemRelationship>();
        }
        this.orderItemRelationship.add(orderItemRelationshipItem);
        return this;
    }

    @Schema(description="A list of order items related to this order item")
    @Valid
    public Set<ServiceOrderItemRelationship> getOrderItemRelationship() {
        return this.orderItemRelationship;
    }

    public void setOrderItemRelationship(Set<ServiceOrderItemRelationship> orderItemRelationship) {
        this.orderItemRelationship = orderItemRelationship;
    }

    public ServiceOrderItem service(ServiceRestriction service) {
        this.service = service;
        return this;
    }

    @Schema(description="The Service to be acted on by the order item")
    @NotNull
    @Valid
    public ServiceRestriction getService() {
        return this.service;
    }

    public void setService(ServiceRestriction service) {
        this.service = service;
    }

    public ServiceOrderItem state(ServiceOrderStateType state) {
        this.state = state;
        return this;
    }

    @Schema(description="State of the order item: described in the state machine diagram. This is the requested state.")
    @Valid
    public ServiceOrderStateType getState() {
        return this.state;
    }

    public void setState(ServiceOrderStateType state) {
        this.state = state;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceOrderItem serviceOrderItem = (ServiceOrderItem)o;
        return Objects.equals(this.getId(), serviceOrderItem.getId()) && Objects.equals((Object)this.action, (Object)serviceOrderItem.action) && Objects.equals(this.appointment, serviceOrderItem.appointment) && Objects.equals(this.orderItemRelationship, serviceOrderItem.orderItemRelationship) && Objects.equals(this.service, serviceOrderItem.service) && Objects.equals((Object)this.state, (Object)serviceOrderItem.state) && Objects.equals(this.baseType, serviceOrderItem.baseType) && Objects.equals(this.schemaLocation, serviceOrderItem.schemaLocation) && Objects.equals(this.type, serviceOrderItem.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceOrderItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.getId())).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    appointment: ").append(this.toIndentedString(this.appointment)).append("\n");
        sb.append("    orderItemRelationship: ").append(this.toIndentedString(this.orderItemRelationship)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

