/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.so641.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.service.Note;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.so641.model.ServiceOrderItem;
import org.etsi.osl.tmf.so641.model.ServiceOrderRelationship;
import org.springframework.validation.annotation.Validated;

@Schema(description=" Skipped properties: id,href,orderDate,completionDate,expectedCompletionDate,startDate,state")
@Validated
public class ServiceOrderCreate {
    @JsonProperty(value="category")
    private String category = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="externalId")
    private String externalId = null;
    @JsonProperty(value="notificationContact")
    private String notificationContact = null;
    @JsonProperty(value="priority")
    private String priority = null;
    private OffsetDateTime requestedCompletionDate = null;
    private OffsetDateTime requestedStartDate = null;
    @JsonProperty(value="note")
    @Valid
    private List<Note> note = null;
    @JsonProperty(value="orderItem")
    @Valid
    private List<ServiceOrderItem> orderItem = new ArrayList<ServiceOrderItem>();
    @JsonProperty(value="orderRelationship")
    @Valid
    private List<ServiceOrderRelationship> orderRelationship = null;
    @JsonProperty(value="relatedParty")
    @Valid
    private List<RelatedParty> relatedParty = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public ServiceOrderCreate category(String category) {
        this.category = category;
        return this;
    }

    @Schema(description="Used to categorize the order, useful for the OM system, such as: Broadband, TVOption")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public ServiceOrderCreate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A free-text description of the service order")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ServiceOrderCreate externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Schema(description="ID given by the consumer to facilitate searches")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public ServiceOrderCreate notificationContact(String notificationContact) {
        this.notificationContact = notificationContact;
        return this;
    }

    @Schema(description="Contact attached to the order to send back information regarding this order")
    public String getNotificationContact() {
        return this.notificationContact;
    }

    public void setNotificationContact(String notificationContact) {
        this.notificationContact = notificationContact;
    }

    public ServiceOrderCreate priority(String priority) {
        this.priority = priority;
        return this;
    }

    @Schema(description="Can be used by consumers to prioritize orders in a Service Order Management system")
    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public ServiceOrderCreate requestedCompletionDate(OffsetDateTime requestedCompletionDate) {
        this.requestedCompletionDate = requestedCompletionDate;
        return this;
    }

    @Schema(description="Requested delivery date from the requestors perspective")
    @Valid
    public OffsetDateTime getRequestedCompletionDate() {
        return this.requestedCompletionDate;
    }

    @JsonProperty(value="requestedCompletionDate")
    public String getRequestedCompletionDateStr() {
        if (this.requestedCompletionDate != null) {
            return this.requestedCompletionDate.toString();
        }
        return null;
    }

    public void setRequestedCompletionDate(OffsetDateTime requestedCompletionDate) {
        this.requestedCompletionDate = requestedCompletionDate;
    }

    public void setRequestedCompletionDate(String requestedCompletionDate) {
        if (requestedCompletionDate != null) {
            this.requestedCompletionDate = OffsetDateTime.parse(requestedCompletionDate);
        }
    }

    public ServiceOrderCreate requestedStartDate(OffsetDateTime requestedStartDate) {
        this.requestedStartDate = requestedStartDate;
        return this;
    }

    @Schema(description="Order start date wished by the requestor")
    @Valid
    public OffsetDateTime getRequestedStartDate() {
        return this.requestedStartDate;
    }

    @JsonProperty(value="requestedStartDate")
    public String getRequestedStartDateStr() {
        if (this.requestedStartDate != null) {
            return this.requestedStartDate.toString();
        }
        return null;
    }

    public void setRequestedStartDate(OffsetDateTime requestedStartDate) {
        this.requestedStartDate = requestedStartDate;
    }

    public ServiceOrderCreate note(List<Note> note) {
        this.note = note;
        return this;
    }

    public void setRequestedStartDate(String requestedStartDate) {
        if (requestedStartDate != null) {
            this.requestedStartDate = OffsetDateTime.parse(requestedStartDate);
        }
    }

    public ServiceOrderCreate addNoteItem(Note noteItem) {
        if (this.note == null) {
            this.note = new ArrayList<Note>();
        }
        this.note.add(noteItem);
        return this;
    }

    @Schema(description="Extra-information about the order; e.g. useful to add extra delivery information that could be useful for a human process")
    @Valid
    public List<Note> getNote() {
        return this.note;
    }

    public void setNote(List<Note> note) {
        this.note = note;
    }

    public ServiceOrderCreate orderItem(List<ServiceOrderItem> orderItem) {
        this.orderItem = orderItem;
        return this;
    }

    public ServiceOrderCreate addOrderItemItem(ServiceOrderItem orderItemItem) {
        this.orderItem.add(orderItemItem);
        return this;
    }

    @Schema(description="A list of service order items to be processed by this order")
    @NotNull
    @Valid
    @Size(min=1)
    public @NotNull @Valid @Size(min=1) List<ServiceOrderItem> getOrderItem() {
        return this.orderItem;
    }

    public void setOrderItem(List<ServiceOrderItem> orderItem) {
        this.orderItem = orderItem;
    }

    public ServiceOrderCreate orderRelationship(List<ServiceOrderRelationship> orderRelationship) {
        this.orderRelationship = orderRelationship;
        return this;
    }

    public ServiceOrderCreate addOrderRelationshipItem(ServiceOrderRelationship orderRelationshipItem) {
        if (this.orderRelationship == null) {
            this.orderRelationship = new ArrayList<ServiceOrderRelationship>();
        }
        this.orderRelationship.add(orderRelationshipItem);
        return this;
    }

    @Schema(description="A list of service orders related to this order (e.g. prerequisite, dependent on)")
    @Valid
    public List<ServiceOrderRelationship> getOrderRelationship() {
        return this.orderRelationship;
    }

    public void setOrderRelationship(List<ServiceOrderRelationship> orderRelationship) {
        this.orderRelationship = orderRelationship;
    }

    public ServiceOrderCreate relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ServiceOrderCreate addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="A list of parties which are involved in this order and the role they are playing")
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ServiceOrderCreate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ServiceOrderCreate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ServiceOrderCreate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceOrderCreate serviceOrderCreate = (ServiceOrderCreate)o;
        return Objects.equals(this.category, serviceOrderCreate.category) && Objects.equals(this.description, serviceOrderCreate.description) && Objects.equals(this.externalId, serviceOrderCreate.externalId) && Objects.equals(this.notificationContact, serviceOrderCreate.notificationContact) && Objects.equals(this.priority, serviceOrderCreate.priority) && Objects.equals(this.requestedCompletionDate, serviceOrderCreate.requestedCompletionDate) && Objects.equals(this.requestedStartDate, serviceOrderCreate.requestedStartDate) && Objects.equals(this.note, serviceOrderCreate.note) && Objects.equals(this.orderItem, serviceOrderCreate.orderItem) && Objects.equals(this.orderRelationship, serviceOrderCreate.orderRelationship) && Objects.equals(this.relatedParty, serviceOrderCreate.relatedParty) && Objects.equals(this.baseType, serviceOrderCreate.baseType) && Objects.equals(this.schemaLocation, serviceOrderCreate.schemaLocation) && Objects.equals(this.type, serviceOrderCreate.type);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.description, this.externalId, this.notificationContact, this.priority, this.requestedCompletionDate, this.requestedStartDate, this.note, this.orderItem, this.orderRelationship, this.relatedParty, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceOrderCreate {\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    notificationContact: ").append(this.toIndentedString(this.notificationContact)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    requestedCompletionDate: ").append(this.toIndentedString(this.requestedCompletionDate)).append("\n");
        sb.append("    requestedStartDate: ").append(this.toIndentedString(this.requestedStartDate)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    orderItem: ").append(this.toIndentedString(this.orderItem)).append("\n");
        sb.append("    orderRelationship: ").append(this.toIndentedString(this.orderRelationship)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

