/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.so641.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.common.model.UserPartRoleType;
import org.etsi.osl.tmf.common.model.service.Note;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.so641.model.ServiceOrderItem;
import org.etsi.osl.tmf.so641.model.ServiceOrderRelationship;
import org.etsi.osl.tmf.so641.model.ServiceOrderStateType;
import org.springframework.validation.annotation.Validated;

@Validated
@Entity(name="ServiceOrder")
@JsonIgnoreProperties(value={"orderRequester"})
public class ServiceOrder
extends BaseRootEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="category")
    private String category = null;
    @Lob
    @Column(name="LDESCRIPTION", columnDefinition="LONGTEXT")
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="externalId")
    private String externalId = null;
    @JsonProperty(value="notificationContact")
    private String notificationContact = null;
    private OffsetDateTime orderDate = null;
    @JsonProperty(value="priority")
    private String priority = null;
    private OffsetDateTime completionDate = null;
    private OffsetDateTime expectedCompletionDate = null;
    private OffsetDateTime requestedCompletionDate = null;
    private OffsetDateTime requestedStartDate = null;
    private OffsetDateTime startDate = null;
    @JsonProperty(value="note")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<Note> note = new HashSet<Note>();
    @JsonProperty(value="orderItem")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ServiceOrderItem> orderItem = new HashSet<ServiceOrderItem>();
    @JsonProperty(value="orderRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ServiceOrderRelationship> orderRelationship = new HashSet<ServiceOrderRelationship>();
    @JsonProperty(value="relatedParty")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<RelatedParty> relatedParty = new HashSet<RelatedParty>();
    @JsonProperty(value="state")
    private ServiceOrderStateType state = ServiceOrderStateType.INITIAL;

    public ServiceOrder() {
        this.baseType = "BaseRootEntity";
        this.type = "ServiceOrder";
    }

    @Schema(description="ID created on repository side")
    public String getId() {
        if (this.id != null && this.uuid == null) {
            return this.id;
        }
        return this.uuid;
    }

    @Schema(description="Used to categorize the order, useful for the OM system, such as: Broadband, TVOption")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public ServiceOrder completionDate(OffsetDateTime completionDate) {
        this.completionDate = completionDate;
        return this;
    }

    @Schema(description="Effective delivery date amended by the provider")
    @Valid
    @JsonProperty(value="completionDate")
    public String getCompletionDateString() {
        if (this.completionDate == null) {
            return null;
        }
        return this.completionDate.toString();
    }

    public OffsetDateTime getCompletionDate() {
        return this.completionDate;
    }

    public void setCompletionDate(OffsetDateTime completionDate) {
        this.completionDate = completionDate;
    }

    public ServiceOrder description(String description) {
        this.description = description;
        return this;
    }

    public void setCompletionDate(String completionDate) {
        if (completionDate != null) {
            this.completionDate = OffsetDateTime.parse(completionDate);
        }
    }

    @Schema(description="A free-text description of the service order")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ServiceOrder expectedCompletionDate(OffsetDateTime expectedCompletionDate) {
        this.expectedCompletionDate = expectedCompletionDate;
        return this;
    }

    @Schema(description="Expected delivery date amended by the provider")
    @Valid
    @JsonProperty(value="expectedCompletionDate")
    public String getExpectedCompletionDateString() {
        if (this.expectedCompletionDate == null) {
            return null;
        }
        return this.expectedCompletionDate.toString();
    }

    public OffsetDateTime getExpectedCompletionDate() {
        return this.expectedCompletionDate;
    }

    public void setExpectedCompletionDate(OffsetDateTime expectedCompletionDate) {
        this.expectedCompletionDate = expectedCompletionDate;
    }

    public void setExpectedCompletionDate(String expectedCompletionDate) {
        if (expectedCompletionDate != null) {
            this.expectedCompletionDate = OffsetDateTime.parse(expectedCompletionDate);
        }
    }

    public ServiceOrder externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Schema(description="ID given by the consumer to facilitate searches")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public ServiceOrder notificationContact(String notificationContact) {
        this.notificationContact = notificationContact;
        return this;
    }

    @Schema(description="Contact attached to the order to send back information regarding this order")
    public String getNotificationContact() {
        return this.notificationContact;
    }

    public void setNotificationContact(String notificationContact) {
        this.notificationContact = notificationContact;
    }

    public ServiceOrder orderDate(OffsetDateTime orderDate) {
        this.orderDate = orderDate;
        return this;
    }

    @Schema(description="")
    @Valid
    @JsonProperty(value="orderDate")
    public String getOrderDateString() {
        if (this.orderDate == null) {
            return null;
        }
        return this.orderDate.toString();
    }

    public OffsetDateTime getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(OffsetDateTime orderDate) {
        this.orderDate = orderDate;
    }

    public ServiceOrder priority(String priority) {
        this.priority = priority;
        return this;
    }

    public void setOrderDate(String orderDate) {
        if (orderDate != null) {
            this.orderDate = OffsetDateTime.parse(orderDate);
        }
    }

    @Schema(description="Can be used by consumers to prioritize orders in a Service Order Management system")
    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public ServiceOrder requestedCompletionDate(OffsetDateTime requestedCompletionDate) {
        this.requestedCompletionDate = requestedCompletionDate;
        return this;
    }

    @Schema(description="Requested delivery date from the requestors perspective")
    @Valid
    @JsonProperty(value="requestedCompletionDate")
    public String getRequestedCompletionDateString() {
        if (this.requestedCompletionDate == null) {
            return null;
        }
        return this.requestedCompletionDate.toString();
    }

    public OffsetDateTime getRequestedCompletionDate() {
        return this.requestedCompletionDate;
    }

    public void setRequestedCompletionDate(OffsetDateTime requestedCompletionDate) {
        this.requestedCompletionDate = requestedCompletionDate;
    }

    public ServiceOrder requestedStartDate(OffsetDateTime requestedStartDate) {
        this.requestedStartDate = requestedStartDate;
        return this;
    }

    public void setRequestedCompletionDate(String requestedCompletionDate) {
        if (requestedCompletionDate != null) {
            this.requestedCompletionDate = OffsetDateTime.parse(requestedCompletionDate);
        }
    }

    @Schema(description="Order start date wished by the requestor")
    @Valid
    @JsonProperty(value="requestedStartDate")
    public String getRequestedStartDateString() {
        if (this.requestedStartDate == null) {
            return null;
        }
        return this.requestedStartDate.toString();
    }

    public OffsetDateTime getRequestedStartDate() {
        return this.requestedStartDate;
    }

    public void setRequestedStartDate(OffsetDateTime requestedStartDate) {
        this.requestedStartDate = requestedStartDate;
    }

    public void setRequestedStartDate(String requestedStartDate) {
        if (requestedStartDate != null) {
            this.requestedStartDate = OffsetDateTime.parse(requestedStartDate);
        }
    }

    public ServiceOrder startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Schema(description="Date when the order was started for processing")
    @Valid
    @JsonProperty(value="startDate")
    public String getStartDateString() {
        if (this.startDate == null) {
            return null;
        }
        return this.startDate.toString();
    }

    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public void setStartDate(String requestedStartDate) {
        if (requestedStartDate != null) {
            this.startDate = OffsetDateTime.parse(requestedStartDate);
        }
    }

    public ServiceOrder note(Set<Note> note) {
        this.note = note;
        return this;
    }

    public ServiceOrder addNoteItem(Note noteItem) {
        if (this.note == null) {
            this.note = new HashSet<Note>();
        }
        this.note.add(noteItem);
        return this;
    }

    @Schema(description="Extra-information about the order; e.g. useful to add extra delivery information that could be useful for a human process")
    @Valid
    public Set<Note> getNote() {
        return this.note;
    }

    public void setNote(Set<Note> note) {
        this.note = note;
    }

    public ServiceOrder orderItem(Set<ServiceOrderItem> orderItem) {
        this.orderItem = orderItem;
        return this;
    }

    public ServiceOrder addOrderItemItem(ServiceOrderItem orderItemItem) {
        this.orderItem.add(orderItemItem);
        return this;
    }

    @Schema(description="A list of service order items to be processed by this order")
    @NotNull
    @Valid
    @Size(min=1)
    public @NotNull @Valid @Size(min=1) Set<ServiceOrderItem> getOrderItem() {
        return this.orderItem;
    }

    public void setOrderItem(Set<ServiceOrderItem> orderItem) {
        this.orderItem = orderItem;
    }

    public ServiceOrder orderRelationship(Set<ServiceOrderRelationship> orderRelationship) {
        this.orderRelationship = orderRelationship;
        return this;
    }

    public ServiceOrder addOrderRelationshipItem(ServiceOrderRelationship orderRelationshipItem) {
        if (this.orderRelationship == null) {
            this.orderRelationship = new HashSet<ServiceOrderRelationship>();
        }
        this.orderRelationship.add(orderRelationshipItem);
        return this;
    }

    @Schema(description="A list of service orders related to this order (e.g. prerequisite, dependent on)")
    @Valid
    public Set<ServiceOrderRelationship> getOrderRelationship() {
        return this.orderRelationship;
    }

    public void setOrderRelationship(Set<ServiceOrderRelationship> orderRelationship) {
        this.orderRelationship = orderRelationship;
    }

    public ServiceOrder relatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ServiceOrder addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new HashSet<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="A list of parties which are involved in this order and the role they are playing")
    @Valid
    public Set<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ServiceOrder state(ServiceOrderStateType state) {
        this.state = state;
        return this;
    }

    @Schema(description="State of the order: described in the state-machine diagram")
    @Valid
    public ServiceOrderStateType getState() {
        return this.state;
    }

    public void setState(ServiceOrderStateType state) {
        this.state = state;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceOrder serviceOrder = (ServiceOrder)o;
        return Objects.equals(this.id, serviceOrder.id) && Objects.equals(this.href, serviceOrder.href) && Objects.equals(this.category, serviceOrder.category) && Objects.equals(this.completionDate, serviceOrder.completionDate) && Objects.equals(this.description, serviceOrder.description) && Objects.equals(this.expectedCompletionDate, serviceOrder.expectedCompletionDate) && Objects.equals(this.externalId, serviceOrder.externalId) && Objects.equals(this.notificationContact, serviceOrder.notificationContact) && Objects.equals(this.orderDate, serviceOrder.orderDate) && Objects.equals(this.priority, serviceOrder.priority) && Objects.equals(this.requestedCompletionDate, serviceOrder.requestedCompletionDate) && Objects.equals(this.requestedStartDate, serviceOrder.requestedStartDate) && Objects.equals(this.startDate, serviceOrder.startDate) && Objects.equals(this.note, serviceOrder.note) && Objects.equals(this.orderItem, serviceOrder.orderItem) && Objects.equals(this.orderRelationship, serviceOrder.orderRelationship) && Objects.equals(this.relatedParty, serviceOrder.relatedParty) && Objects.equals((Object)this.state, (Object)serviceOrder.state) && Objects.equals(this.baseType, serviceOrder.baseType) && Objects.equals(this.schemaLocation, serviceOrder.schemaLocation) && Objects.equals(this.type, serviceOrder.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceOrder {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    completionDate: ").append(this.toIndentedString(this.completionDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    expectedCompletionDate: ").append(this.toIndentedString(this.expectedCompletionDate)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    notificationContact: ").append(this.toIndentedString(this.notificationContact)).append("\n");
        sb.append("    orderDate: ").append(this.toIndentedString(this.orderDate)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    requestedCompletionDate: ").append(this.toIndentedString(this.requestedCompletionDate)).append("\n");
        sb.append("    requestedStartDate: ").append(this.toIndentedString(this.requestedStartDate)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    orderItem: ").append(this.toIndentedString(this.orderItem)).append("\n");
        sb.append("    orderRelationship: ").append(this.toIndentedString(this.orderRelationship)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public ServiceOrderItem findOrderItemById(String id) {
        for (ServiceOrderItem oi : this.orderItem) {
            if (!oi.getId().equals(id)) continue;
            return oi;
        }
        return null;
    }

    public RelatedParty getOrderRequester() {
        for (RelatedParty rp : this.relatedParty) {
            if (!rp.getRole().equals(UserPartRoleType.REQUESTER.toString())) continue;
            return rp;
        }
        return null;
    }
}

