/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.so641.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Refers an appointment, such as a Customer presentation or internal meeting or site visit")
@Validated
@Entity(name="AppointmentRef")
public class AppointmentRef
extends BaseRootEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="@referredType")
    private String referredType = null;

    @Schema(description="The identifier of the referred appointment")
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AppointmentRef description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="An explanatory text regarding the appointment made with a party")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation")
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppointmentRef appointmentRef = (AppointmentRef)o;
        return Objects.equals(this.id, appointmentRef.id) && Objects.equals(this.href, appointmentRef.href) && Objects.equals(this.description, appointmentRef.description) && Objects.equals(this.baseType, appointmentRef.baseType) && Objects.equals(this.schemaLocation, appointmentRef.schemaLocation) && Objects.equals(this.type, appointmentRef.type) && Objects.equals(this.referredType, appointmentRef.referredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppointmentRef {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

