/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.sim638.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.service.Characteristic;
import org.etsi.osl.tmf.common.model.service.Note;
import org.etsi.osl.tmf.common.model.service.Place;
import org.etsi.osl.tmf.common.model.service.ResourceRef;
import org.etsi.osl.tmf.common.model.service.ServiceRef;
import org.etsi.osl.tmf.common.model.service.ServiceRelationship;
import org.etsi.osl.tmf.common.model.service.ServiceSpecificationRef;
import org.etsi.osl.tmf.common.model.service.ServiceStateType;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.sim638.model.ServiceOrderRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="Service is a base class for defining the Service hierarchy. All Services are characterized as either being possibly visible and usable by a Customer or not. This gives rise to the two subclasses of Service: CustomerFacingService and ResourceFacingService. Skipped properties: id,href,serviceRelationship")
@Validated
public class ServiceUpdate {
    @JsonProperty(value="category")
    protected String category = null;
    @JsonProperty(value="description")
    protected String description = null;
    protected OffsetDateTime endDate = null;
    @JsonProperty(value="hasStarted")
    protected Boolean hasStarted = null;
    @JsonProperty(value="isServiceEnabled")
    protected Boolean isServiceEnabled = null;
    @JsonProperty(value="isStateful")
    protected Boolean isStateful = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="serviceDate")
    protected String serviceDate = null;
    @JsonProperty(value="serviceType")
    protected String serviceType = null;
    protected OffsetDateTime startDate = null;
    @JsonProperty(value="startMode")
    protected String startMode = null;
    @JsonProperty(value="note")
    @Valid
    protected List<Note> note = null;
    @JsonProperty(value="place")
    @Valid
    protected List<Place> place = null;
    @JsonProperty(value="relatedParty")
    @Valid
    protected List<RelatedParty> relatedParty = null;
    @JsonProperty(value="serviceCharacteristic")
    @Valid
    protected List<Characteristic> serviceCharacteristic = null;
    @JsonProperty(value="serviceOrder")
    @Valid
    protected List<ServiceOrderRef> serviceOrder = null;
    @JsonProperty(value="serviceSpecification")
    protected ServiceSpecificationRef serviceSpecificationRef = null;
    @JsonProperty(value="state")
    protected ServiceStateType state = null;
    @JsonProperty(value="supportingResource")
    @Valid
    protected List<ResourceRef> supportingResource = null;
    @JsonProperty(value="supportingService")
    @Valid
    protected List<ServiceRef> supportingService = null;
    @JsonProperty(value="serviceRelationship")
    @Valid
    protected List<ServiceRelationship> serviceRelationship = null;
    @JsonProperty(value="@baseType")
    protected String baseType = null;
    @JsonProperty(value="@schemaLocation")
    protected String schemaLocation = null;
    @JsonProperty(value="@type")
    protected String type = null;

    public ServiceUpdate category(String category) {
        this.category = category;
        return this;
    }

    @Schema(description="Is it a customer facing or resource facing service")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public ServiceUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Free-text description of the service")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ServiceUpdate endDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @JsonProperty(value="endDate")
    public String getEndDateStr() {
        if (this.endDate != null) {
            return this.endDate.toString();
        }
        return null;
    }

    @Schema(description="Date when the service ends")
    @Valid
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public void setEndDate(String anendDate) {
        if (anendDate != null) {
            this.endDate = OffsetDateTime.parse(anendDate);
        }
    }

    public ServiceUpdate hasStarted(Boolean hasStarted) {
        this.hasStarted = hasStarted;
        return this;
    }

    @Schema(description="If TRUE, this Service has already been started")
    public Boolean isHasStarted() {
        return this.hasStarted;
    }

    public void setHasStarted(Boolean hasStarted) {
        this.hasStarted = hasStarted;
    }

    public ServiceUpdate isServiceEnabled(Boolean isServiceEnabled) {
        this.isServiceEnabled = isServiceEnabled;
        return this;
    }

    @Schema(description="If FALSE, this particular Service has NOT been enabled for use")
    public Boolean isIsServiceEnabled() {
        return this.isServiceEnabled;
    }

    public void setIsServiceEnabled(Boolean isServiceEnabled) {
        this.isServiceEnabled = isServiceEnabled;
    }

    public ServiceUpdate isStateful(Boolean isStateful) {
        this.isStateful = isStateful;
        return this;
    }

    @Schema(description="If TRUE, this Service can be changed without affecting any other services")
    public Boolean isIsStateful() {
        return this.isStateful;
    }

    public void setIsStateful(Boolean isStateful) {
        this.isStateful = isStateful;
    }

    public ServiceUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the service")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ServiceUpdate serviceDate(String serviceDate) {
        this.serviceDate = serviceDate;
        return this;
    }

    @Schema(description="Date when the service was created (whatever its status).")
    public String getServiceDate() {
        return this.serviceDate;
    }

    public void setServiceDate(String serviceDate) {
        this.serviceDate = serviceDate;
    }

    public ServiceUpdate serviceType(String serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @Schema(description="Business type of the service")
    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public ServiceUpdate startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Schema(description="Date when the service starts")
    @Valid
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    public String getStartDateStr() {
        if (this.startDate != null) {
            return this.startDate.toString();
        }
        return null;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public void setStartDate(String astartDate) {
        if (astartDate != null) {
            this.startDate = OffsetDateTime.parse(astartDate);
        }
    }

    public ServiceUpdate startMode(String startMode) {
        this.startMode = startMode;
        return this;
    }

    @Schema(description="This attribute is an enumerated integer that indicates how the Service is started, such as: 0: Unknown; 1: Automatically by the managed environment; 2: Automatically by the owning device; 3: Manually by the Provider of the Service; 4: Manually by a Customer of the Provider; 5: Any of the above")
    public String getStartMode() {
        return this.startMode;
    }

    public void setStartMode(String startMode) {
        this.startMode = startMode;
    }

    public ServiceUpdate note(List<Note> note) {
        this.note = note;
        return this;
    }

    public ServiceUpdate addNoteItem(Note noteItem) {
        if (this.note == null) {
            this.note = new ArrayList<Note>();
        }
        this.note.add(noteItem);
        return this;
    }

    @Schema(description="A list of notes made on this service")
    @Valid
    public List<Note> getNote() {
        return this.note;
    }

    public void setNote(List<Note> note) {
        this.note = note;
    }

    public ServiceUpdate place(List<Place> place) {
        this.place = place;
        return this;
    }

    public ServiceUpdate addPlaceItem(Place placeItem) {
        if (this.place == null) {
            this.place = new ArrayList<Place>();
        }
        this.place.add(placeItem);
        return this;
    }

    @Schema(description="A list of places related to this service, e.g. where the service is installed, a delivery address for equipment, etc.")
    @Valid
    public List<Place> getPlace() {
        return this.place;
    }

    public void setPlace(List<Place> place) {
        this.place = place;
    }

    public ServiceUpdate relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ServiceUpdate addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="A list of related party references (RelatedParty [1..*]). A related party defines party or party role linked to a specific entity.")
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ServiceUpdate serviceCharacteristic(List<Characteristic> serviceCharacteristic) {
        this.serviceCharacteristic = serviceCharacteristic;
        return this;
    }

    public ServiceUpdate addServiceCharacteristicItem(Characteristic serviceCharacteristicItem) {
        if (this.serviceCharacteristic == null) {
            this.serviceCharacteristic = new ArrayList<Characteristic>();
        }
        this.serviceCharacteristic.add(serviceCharacteristicItem);
        return this;
    }

    @Schema(description="A list of characteristics that characterize this service (ServiceCharacteristic [*]) ")
    @Valid
    public List<Characteristic> getServiceCharacteristic() {
        return this.serviceCharacteristic;
    }

    public void setServiceCharacteristic(List<Characteristic> serviceCharacteristic) {
        this.serviceCharacteristic = serviceCharacteristic;
    }

    public ServiceUpdate serviceOrder(List<ServiceOrderRef> serviceOrder) {
        this.serviceOrder = serviceOrder;
        return this;
    }

    public ServiceUpdate addServiceOrderItem(ServiceOrderRef serviceOrderItem) {
        if (this.serviceOrder == null) {
            this.serviceOrder = new ArrayList<ServiceOrderRef>();
        }
        this.serviceOrder.add(serviceOrderItem);
        return this;
    }

    @Schema(description="A list of service orders related to this service")
    @Valid
    public List<ServiceOrderRef> getServiceOrder() {
        return this.serviceOrder;
    }

    public void setServiceOrder(List<ServiceOrderRef> serviceOrder) {
        this.serviceOrder = serviceOrder;
    }

    public ServiceUpdate serviceSpecificationRef(ServiceSpecificationRef serviceSpecification) {
        this.serviceSpecificationRef = serviceSpecification;
        return this;
    }

    @Schema(description="The specification from which this service was instantiated")
    @Valid
    public ServiceSpecificationRef getServiceSpecificationRef() {
        return this.serviceSpecificationRef;
    }

    public void setServiceSpecificationRef(ServiceSpecificationRef serviceSpecification) {
        this.serviceSpecificationRef = serviceSpecification;
    }

    public ServiceUpdate state(ServiceStateType state) {
        this.state = state;
        return this;
    }

    @Schema(description="The life cycle state of the service, such as: feasibilityChecked, designed, reserved, active, inactive, terminated")
    @Valid
    public ServiceStateType getState() {
        return this.state;
    }

    public void setState(ServiceStateType state) {
        this.state = state;
    }

    public ServiceUpdate supportingResource(List<ResourceRef> supportingResource) {
        this.supportingResource = supportingResource;
        return this;
    }

    public ServiceUpdate addSupportingResourceItem(ResourceRef supportingResourceItem) {
        if (this.supportingResource == null) {
            this.supportingResource = new ArrayList<ResourceRef>();
        }
        this.supportingResource.add(supportingResourceItem);
        return this;
    }

    @Schema(description="A list of supporting resources (SupportingResource [*]).Note: only Service of type RFS can be associated with Resources.")
    @Valid
    public List<ResourceRef> getSupportingResource() {
        return this.supportingResource;
    }

    public void setSupportingResource(List<ResourceRef> supportingResource) {
        this.supportingResource = supportingResource;
    }

    public ServiceUpdate supportingService(List<ServiceRef> supportingService) {
        this.supportingService = supportingService;
        return this;
    }

    public ServiceUpdate addSupportingServiceItem(ServiceRef supportingServiceItem) {
        if (this.supportingService == null) {
            this.supportingService = new ArrayList<ServiceRef>();
        }
        this.supportingService.add(supportingServiceItem);
        return this;
    }

    @Schema(description="A list of supporting services (SupportingService [*]). A collection of services that support this service (bundling, link CFS to RFS).")
    @Valid
    public List<ServiceRef> getSupportingService() {
        return this.supportingService;
    }

    public void setSupportingService(List<ServiceRef> supportingService) {
        this.supportingService = supportingService;
    }

    public ServiceUpdate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ServiceUpdate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ServiceUpdate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ServiceRelationship addServiceRelationshipItem(ServiceRelationship serviceRelationshipItem) {
        if (this.serviceRelationship == null) {
            this.serviceRelationship = new ArrayList<ServiceRelationship>();
        }
        this.serviceRelationship.add(serviceRelationshipItem);
        return serviceRelationshipItem;
    }

    @Schema(description="A list of service relationships (ServiceRelationship [*]). Describes links with other service(s) in the inventory (useful for describing relies-on, relies-from between CFS for example).")
    @Valid
    public List<ServiceRelationship> getServiceRelationship() {
        return this.serviceRelationship;
    }

    public void setServiceRelationship(List<ServiceRelationship> serviceRelationship) {
        this.serviceRelationship = serviceRelationship;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceUpdate serviceUpdate = (ServiceUpdate)o;
        return Objects.equals(this.category, serviceUpdate.category) && Objects.equals(this.description, serviceUpdate.description) && Objects.equals(this.endDate, serviceUpdate.endDate) && Objects.equals(this.hasStarted, serviceUpdate.hasStarted) && Objects.equals(this.isServiceEnabled, serviceUpdate.isServiceEnabled) && Objects.equals(this.isStateful, serviceUpdate.isStateful) && Objects.equals(this.name, serviceUpdate.name) && Objects.equals(this.serviceDate, serviceUpdate.serviceDate) && Objects.equals(this.serviceType, serviceUpdate.serviceType) && Objects.equals(this.startDate, serviceUpdate.startDate) && Objects.equals(this.startMode, serviceUpdate.startMode) && Objects.equals(this.note, serviceUpdate.note) && Objects.equals(this.place, serviceUpdate.place) && Objects.equals(this.relatedParty, serviceUpdate.relatedParty) && Objects.equals(this.serviceCharacteristic, serviceUpdate.serviceCharacteristic) && Objects.equals(this.serviceOrder, serviceUpdate.serviceOrder) && Objects.equals(this.serviceSpecificationRef, serviceUpdate.serviceSpecificationRef) && Objects.equals((Object)this.state, (Object)serviceUpdate.state) && Objects.equals(this.supportingResource, serviceUpdate.supportingResource) && Objects.equals(this.supportingService, serviceUpdate.supportingService) && Objects.equals(this.baseType, serviceUpdate.baseType) && Objects.equals(this.schemaLocation, serviceUpdate.schemaLocation) && Objects.equals(this.type, serviceUpdate.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceUpdate {\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    hasStarted: ").append(this.toIndentedString(this.hasStarted)).append("\n");
        sb.append("    isServiceEnabled: ").append(this.toIndentedString(this.isServiceEnabled)).append("\n");
        sb.append("    isStateful: ").append(this.toIndentedString(this.isStateful)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    serviceDate: ").append(this.toIndentedString(this.serviceDate)).append("\n");
        sb.append("    serviceType: ").append(this.toIndentedString(this.serviceType)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    startMode: ").append(this.toIndentedString(this.startMode)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    serviceCharacteristic: ").append(this.toIndentedString(this.serviceCharacteristic)).append("\n");
        sb.append("    serviceOrder: ").append(this.toIndentedString(this.serviceOrder)).append("\n");
        sb.append("    serviceSpecification: ").append(this.toIndentedString(this.serviceSpecificationRef)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    supportingResource: ").append(this.toIndentedString(this.supportingResource)).append("\n");
        sb.append("    supportingService: ").append(this.toIndentedString(this.supportingService)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public Characteristic getServiceCharacteristicByName(String characteristicname) {
        for (Characteristic c : this.serviceCharacteristic) {
            if (!c.getName().equals(characteristicname)) continue;
            return c;
        }
        return null;
    }
}

