/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.sim638.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Service Order reference. Useful to understand the which was the Service order through which the service was instantiated in the service inventory")
@Validated
@Entity(name="ServiceOrderRef")
@JsonIgnoreProperties(value={"uuid"})
public class ServiceOrderRef
extends BaseRootEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="serviceOrderItemId")
    private String serviceOrderItemId = null;
    @JsonProperty(value="@referredType")
    private String referredType = null;

    public ServiceOrderRef id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of the Service Order")
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ServiceOrderRef serviceOrderItemId(String serviceOrderItemId) {
        this.serviceOrderItemId = serviceOrderItemId;
        return this;
    }

    @Schema(description="Unique identifier of the Service Order Item within a service order, not populated if this is a reference to a service order")
    public String getServiceOrderItemId() {
        return this.serviceOrderItemId;
    }

    public void setServiceOrderItemId(String serviceOrderItemId) {
        this.serviceOrderItemId = serviceOrderItemId;
    }

    public ServiceOrderRef referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceOrderRef serviceOrderRef = (ServiceOrderRef)o;
        return Objects.equals(this.id, serviceOrderRef.id) && Objects.equals(this.href, serviceOrderRef.href) && Objects.equals(this.serviceOrderItemId, serviceOrderRef.serviceOrderItemId) && Objects.equals(this.baseType, serviceOrderRef.baseType) && Objects.equals(this.schemaLocation, serviceOrderRef.schemaLocation) && Objects.equals(this.type, serviceOrderRef.type) && Objects.equals(this.referredType, serviceOrderRef.referredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceOrderRef {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    serviceOrderItemId: ").append(this.toIndentedString(this.serviceOrderItemId)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

