/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.sim638.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Lob;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.etsi.osl.tmf.sim638.model.ServiceActionQueueAction;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.validation.annotation.Validated;

@Entity(name="ServiceActionQueueItem")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Schema(description="These are items inserted in the ServiceActionQueue ")
@Validated
public class ServiceActionQueueItem {
    @Id
    @GeneratedValue(generator="uuid")
    @GenericGenerator(name="uuid", strategy="uuid2")
    protected String uuid = null;
    @JsonProperty(value="serviceRefId")
    private String serviceRefId = null;
    private OffsetDateTime insertedDate = null;
    @JsonProperty(value="action")
    ServiceActionQueueAction action = ServiceActionQueueAction.NONE;
    @Lob
    @Column(name="LORIGINAL_SERVICE", columnDefinition="LONGTEXT")
    private String originalServiceInJSONL;

    public ServiceActionQueueItem() {
        this.insertedDate = OffsetDateTime.now(ZoneOffset.UTC);
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getServiceRefId() {
        return this.serviceRefId;
    }

    public void setServiceRefId(String serviceRefId) {
        this.serviceRefId = serviceRefId;
    }

    public OffsetDateTime getInsertedDate() {
        return this.insertedDate;
    }

    public void setInsertedDate(OffsetDateTime insertedDate) {
        this.insertedDate = insertedDate;
    }

    public void setInsertedDate(String insDate) {
        if (insDate != null) {
            this.insertedDate = OffsetDateTime.parse(insDate);
        }
    }

    @JsonProperty(value="insertedDate")
    public String getInsertedDateStr() {
        if (this.insertedDate != null) {
            return this.insertedDate.toString();
        }
        return null;
    }

    public ServiceActionQueueAction getAction() {
        return this.action;
    }

    public void setAction(ServiceActionQueueAction action) {
        this.action = action;
    }

    public String getOriginalServiceInJSON() {
        return this.originalServiceInJSONL;
    }

    public void setOriginalServiceInJSON(String originalServiceInJSON) {
        this.originalServiceInJSONL = originalServiceInJSON;
    }
}

