/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.sim638.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.service.Note;
import org.etsi.osl.tmf.common.model.service.Place;
import org.etsi.osl.tmf.common.model.service.ResourceRef;
import org.etsi.osl.tmf.common.model.service.ServiceRef;
import org.etsi.osl.tmf.common.model.service.ServiceRelationship;
import org.etsi.osl.tmf.common.model.service.ServiceSpecificationRef;
import org.etsi.osl.tmf.common.model.service.ServiceStateType;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.ri639.model.Characteristic;
import org.etsi.osl.tmf.ri639.model.Resource;
import org.etsi.osl.tmf.ri639.model.ResourceStatusType;
import org.etsi.osl.tmf.sim638.model.ServiceOrderRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="Service is a base class for defining the Service hierarchy. All Services are characterized as either being possibly visible and usable by a Customer or not. This gives rise to the two subclasses of Service: CustomerFacingService and ResourceFacingService.")
@Validated
@Entity
public class Service
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="category")
    private String category = null;
    @Lob
    @Column(name="LDESCRIPTION", columnDefinition="LONGTEXT")
    @JsonProperty(value="description")
    private String descriptionL = null;
    private OffsetDateTime endDate = null;
    @JsonProperty(value="hasStarted")
    private Boolean hasStarted = null;
    @JsonProperty(value="isServiceEnabled")
    private Boolean isServiceEnabled = null;
    @JsonProperty(value="isStateful")
    private Boolean isStateful = null;
    @JsonProperty(value="serviceDate")
    private String serviceDate = null;
    @JsonProperty(value="serviceType")
    private String serviceType = null;
    private OffsetDateTime startDate = null;
    @JsonProperty(value="startMode")
    private String startMode = null;
    @JsonProperty(value="note")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<Note> note = new HashSet<Note>();
    @JsonProperty(value="place")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<Place> place = new HashSet<Place>();
    @JsonProperty(value="relatedParty")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<RelatedParty> relatedParty = new HashSet<RelatedParty>();
    @JsonProperty(value="serviceCharacteristic")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<org.etsi.osl.tmf.common.model.service.Characteristic> serviceCharacteristic = new HashSet<org.etsi.osl.tmf.common.model.service.Characteristic>();
    @JsonProperty(value="serviceOrder")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ServiceOrderRef> serviceOrder = new HashSet<ServiceOrderRef>();
    @JsonProperty(value="serviceRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ServiceRelationship> serviceRelationship = new HashSet<ServiceRelationship>();
    @JsonProperty(value="serviceSpecification")
    @OneToOne(cascade={CascadeType.ALL})
    private ServiceSpecificationRef serviceSpecificationRef = null;
    @JsonProperty(value="state")
    private ServiceStateType state = ServiceStateType.FEASIBILITYCHECKED;
    @JsonProperty(value="supportingResource")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ResourceRef> supportingResource = new HashSet<ResourceRef>();
    @JsonProperty(value="supportingService")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ServiceRef> supportingService = new HashSet<ServiceRef>();

    public Service() {
        this.baseType = "BaseRootNamedEntity";
        this.type = "CustomerFacingServiceSpecification";
    }

    @Schema(description="Unique identifier of the service")
    public String getId() {
        this.id = this.uuid;
        return this.uuid;
    }

    @Schema(description="Is it a customer facing or resource facing service")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Service description(String description) {
        this.descriptionL = description;
        return this;
    }

    @Schema(description="Free-text description of the service")
    public String getDescription() {
        return this.descriptionL;
    }

    public void setDescription(String description) {
        this.descriptionL = description;
    }

    public Service endDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Schema(description="Date when the service ends")
    @Valid
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    public String getEndDateStr() {
        if (this.endDate != null) {
            return this.endDate.toString();
        }
        return null;
    }

    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public void setEndDate(String endDate) {
        if (endDate != null) {
            this.endDate = OffsetDateTime.parse(endDate);
        }
    }

    public Service hasStarted(Boolean hasStarted) {
        this.hasStarted = hasStarted;
        return this;
    }

    @Schema(description="If TRUE, this Service has already been started")
    public Boolean isHasStarted() {
        return this.hasStarted;
    }

    public void setHasStarted(Boolean hasStarted) {
        this.hasStarted = hasStarted;
    }

    public Service isServiceEnabled(Boolean isServiceEnabled) {
        this.isServiceEnabled = isServiceEnabled;
        return this;
    }

    @Schema(description="If FALSE, this particular Service has NOT been enabled for use")
    public Boolean isIsServiceEnabled() {
        return this.isServiceEnabled;
    }

    public void setIsServiceEnabled(Boolean isServiceEnabled) {
        this.isServiceEnabled = isServiceEnabled;
    }

    public Service isStateful(Boolean isStateful) {
        this.isStateful = isStateful;
        return this;
    }

    @Schema(description="If TRUE, this Service can be changed without affecting any other services")
    public Boolean isIsStateful() {
        return this.isStateful;
    }

    public void setIsStateful(Boolean isStateful) {
        this.isStateful = isStateful;
    }

    public Service serviceDate(String serviceDate) {
        this.serviceDate = serviceDate;
        return this;
    }

    @Schema(description="Date when the service was created (whatever its status).")
    public String getServiceDate() {
        return this.serviceDate;
    }

    public void setServiceDate(String serviceDate) {
        this.serviceDate = serviceDate;
    }

    public Service serviceType(String serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @Schema(description="Business type of the service")
    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public Service startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Schema(description="Date when the service starts")
    @Valid
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    public String getStartDateStr() {
        if (this.startDate != null) {
            return this.startDate.toString();
        }
        return null;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public void setStartDate(String startDate) {
        if (startDate != null) {
            this.startDate = OffsetDateTime.parse(startDate);
        }
    }

    public Service startMode(String startMode) {
        this.startMode = startMode;
        return this;
    }

    @Schema(description="This attribute is an enumerated integer that indicates how the Service is started, such as: 0: Unknown; 1: Automatically by the managed environment; 2: Automatically by the owning device; 3: Manually by the Provider of the Service; 4: Manually by a Customer of the Provider; 5: Any of the above")
    public String getStartMode() {
        return this.startMode;
    }

    public void setStartMode(String startMode) {
        this.startMode = startMode;
    }

    public Service note(Set<Note> note) {
        this.note = note;
        return this;
    }

    public Service addNoteItem(Note noteItem) {
        if (this.note == null) {
            this.note = new HashSet<Note>();
        }
        this.note.add(noteItem);
        return this;
    }

    @Schema(description="A list of notes made on this service")
    @Valid
    public Set<Note> getNote() {
        return this.note;
    }

    public void setNote(Set<Note> note) {
        this.note = note;
    }

    public Service place(Set<Place> place) {
        this.place = place;
        return this;
    }

    public Service addPlaceItem(Place placeItem) {
        if (this.place == null) {
            this.place = new HashSet<Place>();
        }
        this.place.add(placeItem);
        return this;
    }

    @Schema(description="A list of places related to this service, e.g. where the service is installed, a delivery address for equipment, etc.")
    @Valid
    public Set<Place> getPlace() {
        return this.place;
    }

    public void setPlace(Set<Place> place) {
        this.place = place;
    }

    public Service relatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public Service addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new HashSet<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="A list of related party references (RelatedParty [1..*]). A related party defines party or party role linked to a specific entity.")
    @Valid
    public Set<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public Service serviceCharacteristic(Set<org.etsi.osl.tmf.common.model.service.Characteristic> serviceCharacteristic) {
        this.serviceCharacteristic = serviceCharacteristic;
        return this;
    }

    public Service addServiceCharacteristicItem(org.etsi.osl.tmf.common.model.service.Characteristic serviceCharacteristicItem) {
        if (this.serviceCharacteristic == null) {
            this.serviceCharacteristic = new HashSet<org.etsi.osl.tmf.common.model.service.Characteristic>();
        }
        this.serviceCharacteristic.add(serviceCharacteristicItem);
        return this;
    }

    @Schema(description="A list of characteristics that characterize this service (ServiceCharacteristic [*]) ")
    @Valid
    public Set<org.etsi.osl.tmf.common.model.service.Characteristic> getServiceCharacteristic() {
        return this.serviceCharacteristic;
    }

    public void setServiceCharacteristic(Set<org.etsi.osl.tmf.common.model.service.Characteristic> serviceCharacteristic) {
        this.serviceCharacteristic = serviceCharacteristic;
    }

    public Service serviceOrder(Set<ServiceOrderRef> serviceOrder) {
        this.serviceOrder = serviceOrder;
        return this;
    }

    public Service addServiceOrderItem(ServiceOrderRef serviceOrderItem) {
        if (this.serviceOrder == null) {
            this.serviceOrder = new HashSet<ServiceOrderRef>();
        }
        this.serviceOrder.add(serviceOrderItem);
        return this;
    }

    @Schema(description="A list of service orders related to this service")
    @Valid
    public Set<ServiceOrderRef> getServiceOrder() {
        return this.serviceOrder;
    }

    public void setServiceOrder(Set<ServiceOrderRef> serviceOrder) {
        this.serviceOrder = serviceOrder;
    }

    public Service serviceRelationship(Set<ServiceRelationship> serviceRelationship) {
        this.serviceRelationship = serviceRelationship;
        return this;
    }

    public Service addServiceRelationshipItem(ServiceRelationship serviceRelationshipItem) {
        if (this.serviceRelationship == null) {
            this.serviceRelationship = new HashSet<ServiceRelationship>();
        }
        this.serviceRelationship.add(serviceRelationshipItem);
        return this;
    }

    @Schema(description="A list of service relationships (ServiceRelationship [*]). Describes links with other service(s) in the inventory (useful for describing relies-on, relies-from between CFS for example).")
    @Valid
    public Set<ServiceRelationship> getServiceRelationship() {
        return this.serviceRelationship;
    }

    public void setServiceRelationship(Set<ServiceRelationship> serviceRelationship) {
        this.serviceRelationship = serviceRelationship;
    }

    public Service serviceSpecificationRef(ServiceSpecificationRef serviceSpecification) {
        this.serviceSpecificationRef = serviceSpecification;
        return this;
    }

    @Schema(description="The specification from which this service was instantiated")
    @Valid
    public ServiceSpecificationRef getServiceSpecificationRef() {
        return this.serviceSpecificationRef;
    }

    public void setServiceSpecificationRef(ServiceSpecificationRef serviceSpecification) {
        this.serviceSpecificationRef = serviceSpecification;
    }

    public Service state(ServiceStateType state) {
        this.state = state;
        return this;
    }

    @Schema(description="The life cycle state of the service, such as: feasibilityChecked, designed, reserved, active, inactive, terminated")
    @Valid
    public ServiceStateType getState() {
        return this.state;
    }

    public void setState(ServiceStateType state) {
        this.state = state;
    }

    public Service supportingResource(Set<ResourceRef> supportingResource) {
        this.supportingResource = supportingResource;
        return this;
    }

    public Service addSupportingResourceItem(ResourceRef supportingResourceItem) {
        if (this.supportingResource == null) {
            this.supportingResource = new HashSet<ResourceRef>();
        }
        this.supportingResource.add(supportingResourceItem);
        return this;
    }

    @Schema(description="A list of supporting resources (SupportingResource [*]).Note: only Service of type RFS can be associated with Resources.")
    @Valid
    public Set<ResourceRef> getSupportingResource() {
        return this.supportingResource;
    }

    public void setSupportingResource(Set<ResourceRef> supportingResource) {
        this.supportingResource = supportingResource;
    }

    public Service supportingService(Set<ServiceRef> supportingService) {
        this.supportingService = supportingService;
        return this;
    }

    public Service addSupportingServiceItem(ServiceRef supportingServiceItem) {
        if (this.supportingService == null) {
            this.supportingService = new HashSet<ServiceRef>();
        }
        this.supportingService.add(supportingServiceItem);
        return this;
    }

    @Schema(description="A list of supporting services (SupportingService [*]). A collection of services that support this service (bundling, link CFS to RFS).")
    @Valid
    public Set<ServiceRef> getSupportingService() {
        return this.supportingService;
    }

    public void setSupportingService(Set<ServiceRef> supportingService) {
        this.supportingService = supportingService;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Service service = (Service)o;
        return Objects.equals(this.id, service.id) && Objects.equals(this.href, service.href) && Objects.equals(this.category, service.category) && Objects.equals(this.descriptionL, service.descriptionL) && Objects.equals(this.endDate, service.endDate) && Objects.equals(this.hasStarted, service.hasStarted) && Objects.equals(this.isServiceEnabled, service.isServiceEnabled) && Objects.equals(this.isStateful, service.isStateful) && Objects.equals(this.name, service.name) && Objects.equals(this.serviceDate, service.serviceDate) && Objects.equals(this.serviceType, service.serviceType) && Objects.equals(this.startDate, service.startDate) && Objects.equals(this.startMode, service.startMode) && Objects.equals(this.note, service.note) && Objects.equals(this.place, service.place) && Objects.equals(this.relatedParty, service.relatedParty) && Objects.equals(this.serviceCharacteristic, service.serviceCharacteristic) && Objects.equals(this.serviceOrder, service.serviceOrder) && Objects.equals(this.serviceRelationship, service.serviceRelationship) && Objects.equals(this.serviceSpecificationRef, service.serviceSpecificationRef) && Objects.equals((Object)this.state, (Object)service.state) && Objects.equals(this.supportingResource, service.supportingResource) && Objects.equals(this.supportingService, service.supportingService) && Objects.equals(this.baseType, service.baseType) && Objects.equals(this.schemaLocation, service.schemaLocation) && Objects.equals(this.type, service.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Service {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.descriptionL)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    hasStarted: ").append(this.toIndentedString(this.hasStarted)).append("\n");
        sb.append("    isServiceEnabled: ").append(this.toIndentedString(this.isServiceEnabled)).append("\n");
        sb.append("    isStateful: ").append(this.toIndentedString(this.isStateful)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    serviceDate: ").append(this.toIndentedString(this.serviceDate)).append("\n");
        sb.append("    serviceType: ").append(this.toIndentedString(this.serviceType)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    startMode: ").append(this.toIndentedString(this.startMode)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    serviceCharacteristic: ").append(this.toIndentedString(this.serviceCharacteristic)).append("\n");
        sb.append("    serviceOrder: ").append(this.toIndentedString(this.serviceOrder)).append("\n");
        sb.append("    serviceRelationship: ").append(this.toIndentedString(this.serviceRelationship)).append("\n");
        sb.append("    serviceSpecificationRef: ").append(this.toIndentedString(this.serviceSpecificationRef)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    supportingResource: ").append(this.toIndentedString(this.supportingResource)).append("\n");
        sb.append("    supportingService: ").append(this.toIndentedString(this.supportingService)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public org.etsi.osl.tmf.common.model.service.Characteristic getServiceCharacteristicByName(String name) {
        for (org.etsi.osl.tmf.common.model.service.Characteristic c : this.serviceCharacteristic) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public ServiceStateType findNextStateBasedOnResourceList(List<Resource> supportingResources) {
        if (this.getState().equals((Object)ServiceStateType.TERMINATED)) {
            return ServiceStateType.TERMINATED;
        }
        @Valid ServiceStateType nextState = this.getState();
        boolean allResourcesAvailable = true;
        boolean allResourcesTerminated = true;
        boolean existsSuspended = false;
        boolean existsStandby = false;
        boolean existsReserved = false;
        boolean existUnknown = false;
        boolean existAlarm = false;
        for (Resource res : supportingResources) {
            block20: {
                block19: {
                    if (res.getResourceStatus() == null) break block19;
                    switch (res.getResourceStatus()) {
                        case AVAILABLE: {
                            break block20;
                        }
                        case STANDBY: {
                            existsStandby = true;
                            break block20;
                        }
                        case SUSPENDED: {
                            existsSuspended = true;
                            break block20;
                        }
                        case RESERVED: {
                            existsReserved = true;
                            break block20;
                        }
                        case UNKNOWN: {
                            existUnknown = true;
                            break block20;
                        }
                        case ALARM: {
                            existAlarm = true;
                            break block20;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)res.getResourceStatus()));
                        }
                    }
                }
                existUnknown = true;
            }
            allResourcesAvailable = allResourcesAvailable && res.getResourceStatus() != null && res.getResourceStatus().equals((Object)ResourceStatusType.AVAILABLE);
            allResourcesTerminated = allResourcesTerminated && res.getResourceStatus() != null && res.getResourceStatus().equals((Object)ResourceStatusType.SUSPENDED);
        }
        if (allResourcesAvailable) {
            nextState = ServiceStateType.ACTIVE;
        } else if (allResourcesTerminated) {
            nextState = ServiceStateType.TERMINATED;
        } else if (existAlarm) {
            nextState = ServiceStateType.INACTIVE;
        } else if (existsReserved || existsStandby) {
            nextState = ServiceStateType.RESERVED;
        } else if (existsSuspended || existUnknown) {
            // empty if block
        }
        return nextState;
    }

    public boolean checkIsKindResource(Resource res) {
        org.etsi.osl.tmf.common.model.service.Characteristic serviceKindChar = this.getServiceCharacteristicByName("Kind");
        if (serviceKindChar != null && serviceKindChar.getValue() != null) {
            Characteristic ckind = res.getResourceCharacteristicByName("Kind");
            String resourceKind = "";
            if (ckind != null && ckind.getValue() != null) {
                resourceKind = ckind.getValue().getValue();
            }
            if (serviceKindChar.getValue().getValue().equals(resourceKind) || this.getCategory().equals(resourceKind)) {
                return true;
            }
        }
        return false;
    }
}

