/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.scm633.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.AttachmentRef;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationRef;
import org.etsi.osl.tmf.scm633.model.ServiceLevelSpecificationRef;
import org.etsi.osl.tmf.scm633.model.ServiceSpecCharacteristic;
import org.etsi.osl.tmf.scm633.model.ServiceSpecRelationship;
import org.etsi.osl.tmf.scm633.model.ServiceSpecification;
import org.etsi.osl.tmf.scm633.model.TargetServiceSchema;
import org.springframework.validation.annotation.Validated;

@Schema(description="ServiceSpecification is a class that offers characteristics to describe a type of service. Functionally, it acts as a template by which Services may be instantiated. By sharing the same  specification, these services would therefore share the same set of characteristics. Skipped properties: id,href,lastUpdate")
@Validated
public class ServiceSpecificationUpdate {
    @JsonProperty(value="description")
    protected String description = null;
    @JsonProperty(value="isBundle")
    protected Boolean isBundle = null;
    @JsonProperty(value="lifecycleStatus")
    protected String lifecycleStatus = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="version")
    protected String version = null;
    @JsonProperty(value="attachment")
    @Valid
    protected List<AttachmentRef> attachment = null;
    @JsonProperty(value="relatedParty")
    @Valid
    protected List<RelatedParty> relatedParty = null;
    @JsonProperty(value="resourceSpecification")
    @Valid
    protected List<ResourceSpecificationRef> resourceSpecification = null;
    @JsonProperty(value="serviceLevelSpecification")
    @Valid
    protected List<ServiceLevelSpecificationRef> serviceLevelSpecification = null;
    @JsonProperty(value="serviceSpecCharacteristic")
    @Valid
    protected List<ServiceSpecCharacteristic> serviceSpecCharacteristic = null;
    @JsonProperty(value="serviceSpecRelationship")
    @Valid
    protected List<ServiceSpecRelationship> serviceSpecRelationship = null;
    @JsonProperty(value="targetServiceSchema")
    protected TargetServiceSchema targetServiceSchema = null;
    @JsonProperty(value="validFor")
    protected TimePeriod validFor = null;
    @JsonProperty(value="@baseType")
    protected String baseType = null;
    @JsonProperty(value="@schemaLocation")
    protected String schemaLocation = null;
    @JsonProperty(value="@type")
    protected String type = null;

    public ServiceSpecificationUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A narrative that explains in detail what the service specification is")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ServiceSpecificationUpdate isBundle(Boolean isBundle) {
        this.isBundle = isBundle;
        return this;
    }

    @Schema(description="isBundle determines whether a ServiceSpecification represents a single ServiceSpecification (false), or a bundle of ServiceSpecification (true).")
    public Boolean isIsBundle() {
        return this.isBundle;
    }

    public void setIsBundle(Boolean isBundle) {
        this.isBundle = isBundle;
    }

    public ServiceSpecificationUpdate lifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
        return this;
    }

    @Schema(description="Used to indicate the current lifecycle status of the service specification")
    public String getLifecycleStatus() {
        return this.lifecycleStatus;
    }

    public void setLifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
    }

    public ServiceSpecificationUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the service specification")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ServiceSpecificationUpdate version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="Service specification version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ServiceSpecificationUpdate attachment(List<AttachmentRef> attachment) {
        this.attachment = attachment;
        return this;
    }

    public ServiceSpecificationUpdate addAttachmentItem(AttachmentRef attachmentItem) {
        if (this.attachment == null) {
            this.attachment = new ArrayList<AttachmentRef>();
        }
        this.attachment.add(attachmentItem);
        return this;
    }

    @Schema(description="A list of attachments (Attachment [*]). Complements the description of the specification through video, pictures...")
    @Valid
    public List<AttachmentRef> getAttachment() {
        return this.attachment;
    }

    public void setAttachment(List<AttachmentRef> attachment) {
        this.attachment = attachment;
    }

    public ServiceSpecificationUpdate relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ServiceSpecificationUpdate addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="A list of related party references (RelatedParty [*]). A related party defines party or party role linked to a specific entity.")
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ServiceSpecificationUpdate resourceSpecification(List<ResourceSpecificationRef> resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
        return this;
    }

    public ServiceSpecificationUpdate addResourceSpecificationItem(ResourceSpecificationRef resourceSpecificationItem) {
        if (this.resourceSpecification == null) {
            this.resourceSpecification = new ArrayList<ResourceSpecificationRef>();
        }
        this.resourceSpecification.add(resourceSpecificationItem);
        return this;
    }

    @Schema(description="A list of resource specification references (ResourceSpecificationRef [*]). The ResourceSpecification is required for a service specification with type ResourceFacingServiceSpecification (RFSS).")
    @Valid
    public List<ResourceSpecificationRef> getResourceSpecification() {
        return this.resourceSpecification;
    }

    public void setResourceSpecification(List<ResourceSpecificationRef> resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
    }

    public ServiceSpecificationUpdate serviceLevelSpecification(List<ServiceLevelSpecificationRef> serviceLevelSpecification) {
        this.serviceLevelSpecification = serviceLevelSpecification;
        return this;
    }

    public ServiceSpecificationUpdate addServiceLevelSpecificationItem(ServiceLevelSpecificationRef serviceLevelSpecificationItem) {
        if (this.serviceLevelSpecification == null) {
            this.serviceLevelSpecification = new ArrayList<ServiceLevelSpecificationRef>();
        }
        this.serviceLevelSpecification.add(serviceLevelSpecificationItem);
        return this;
    }

    @Schema(description="A list of service level specifications related to this service specification, and which will need to be satisifiable for corresponding service instances; e.g. Gold, Platinum")
    @Valid
    public List<ServiceLevelSpecificationRef> getServiceLevelSpecification() {
        return this.serviceLevelSpecification;
    }

    public void setServiceLevelSpecification(List<ServiceLevelSpecificationRef> serviceLevelSpecification) {
        this.serviceLevelSpecification = serviceLevelSpecification;
    }

    public ServiceSpecificationUpdate serviceSpecCharacteristic(List<ServiceSpecCharacteristic> serviceSpecCharacteristic) {
        this.serviceSpecCharacteristic = serviceSpecCharacteristic;
        return this;
    }

    public ServiceSpecificationUpdate addServiceSpecCharacteristicItem(ServiceSpecCharacteristic serviceSpecCharacteristicItem) {
        if (this.serviceSpecCharacteristic == null) {
            this.serviceSpecCharacteristic = new ArrayList<ServiceSpecCharacteristic>();
        }
        this.serviceSpecCharacteristic.add(serviceSpecCharacteristicItem);
        return this;
    }

    @Schema(description="A list of service spec characteristics (ServiceSpecCharacteristic [*]). This class represents the key features of this service specification.")
    @Valid
    public List<ServiceSpecCharacteristic> getServiceSpecCharacteristic() {
        return this.serviceSpecCharacteristic;
    }

    public void setServiceSpecCharacteristic(List<ServiceSpecCharacteristic> serviceSpecCharacteristic) {
        this.serviceSpecCharacteristic = serviceSpecCharacteristic;
    }

    public ServiceSpecificationUpdate serviceSpecRelationship(List<ServiceSpecRelationship> serviceSpecRelationship) {
        this.serviceSpecRelationship = serviceSpecRelationship;
        return this;
    }

    public ServiceSpecificationUpdate addServiceSpecRelationshipItem(ServiceSpecRelationship serviceSpecRelationshipItem) {
        if (this.serviceSpecRelationship == null) {
            this.serviceSpecRelationship = new ArrayList<ServiceSpecRelationship>();
        }
        this.serviceSpecRelationship.add(serviceSpecRelationshipItem);
        return this;
    }

    @Schema(description="A list of service specifications related to this specification, e.g. migration, substitution, dependency or exclusivity relationship")
    @Valid
    public List<ServiceSpecRelationship> getServiceSpecRelationship() {
        return this.serviceSpecRelationship;
    }

    public void setServiceSpecRelationship(List<ServiceSpecRelationship> serviceSpecRelationship) {
        this.serviceSpecRelationship = serviceSpecRelationship;
    }

    public ServiceSpecificationUpdate targetServiceSchema(TargetServiceSchema targetServiceSchema) {
        this.targetServiceSchema = targetServiceSchema;
        return this;
    }

    @Schema(description="A target service schema reference (TargetServiceSchemaRef). The reference object to the schema and type of target service which is described by service specification.")
    @Valid
    public TargetServiceSchema getTargetServiceSchema() {
        return this.targetServiceSchema;
    }

    public void setTargetServiceSchema(TargetServiceSchema targetServiceSchema) {
        this.targetServiceSchema = targetServiceSchema;
    }

    public ServiceSpecificationUpdate validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period for which the service specification is valid")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ServiceSpecificationUpdate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ServiceSpecificationUpdate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ServiceSpecificationUpdate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceSpecificationUpdate serviceSpecificationUpdate = (ServiceSpecificationUpdate)o;
        return Objects.equals(this.description, serviceSpecificationUpdate.description) && Objects.equals(this.isBundle, serviceSpecificationUpdate.isBundle) && Objects.equals(this.lifecycleStatus, serviceSpecificationUpdate.lifecycleStatus) && Objects.equals(this.name, serviceSpecificationUpdate.name) && Objects.equals(this.version, serviceSpecificationUpdate.version) && Objects.equals(this.attachment, serviceSpecificationUpdate.attachment) && Objects.equals(this.relatedParty, serviceSpecificationUpdate.relatedParty) && Objects.equals(this.resourceSpecification, serviceSpecificationUpdate.resourceSpecification) && Objects.equals(this.serviceLevelSpecification, serviceSpecificationUpdate.serviceLevelSpecification) && Objects.equals(this.serviceSpecCharacteristic, serviceSpecificationUpdate.serviceSpecCharacteristic) && Objects.equals(this.serviceSpecRelationship, serviceSpecificationUpdate.serviceSpecRelationship) && Objects.equals(this.targetServiceSchema, serviceSpecificationUpdate.targetServiceSchema) && Objects.equals(this.validFor, serviceSpecificationUpdate.validFor) && Objects.equals(this.baseType, serviceSpecificationUpdate.baseType) && Objects.equals(this.schemaLocation, serviceSpecificationUpdate.schemaLocation) && Objects.equals(this.type, serviceSpecificationUpdate.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceSpecificationUpdate {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    resourceSpecification: ").append(this.toIndentedString(this.resourceSpecification)).append("\n");
        sb.append("    serviceLevelSpecification: ").append(this.toIndentedString(this.serviceLevelSpecification)).append("\n");
        sb.append("    serviceSpecCharacteristic: ").append(this.toIndentedString(this.serviceSpecCharacteristic)).append("\n");
        sb.append("    serviceSpecRelationship: ").append(this.toIndentedString(this.serviceSpecRelationship)).append("\n");
        sb.append("    targetServiceSchema: ").append(this.toIndentedString(this.targetServiceSchema)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public void addServiceSpecRelationshipWith(ServiceSpecification responsesSpec1) {
        ServiceSpecRelationship r1 = new ServiceSpecRelationship();
        r1.setId(responsesSpec1.getId());
        r1.setName(responsesSpec1.getName());
        r1.setRole("serviceSpecRelationship");
        r1.setRelationshipType("aggregation");
        this.addServiceSpecRelationshipItem(r1);
    }
}

