/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.scm633.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.scm633.model.ServiceSpecificationUpdate;
import org.springframework.validation.annotation.Validated;

@Schema(description="ServiceSpecification is a class that offers characteristics to describe a type of service. Functionally, it acts as a template by which Services may be instantiated. By sharing the same  specification, these services would therefore share the same set of characteristics. Skipped properties: id,href")
@Validated
public class ServiceSpecificationCreate
extends ServiceSpecificationUpdate {
    @JsonProperty(value="lastUpdate")
    private OffsetDateTime lastUpdate = null;

    public ServiceSpecificationCreate lastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Schema(description="Date and time of the last update of the service specification")
    @Valid
    public OffsetDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceSpecificationCreate serviceSpecificationCreate = (ServiceSpecificationCreate)o;
        return Objects.equals(this.description, serviceSpecificationCreate.description) && Objects.equals(this.isBundle, serviceSpecificationCreate.isBundle) && Objects.equals(this.lastUpdate, serviceSpecificationCreate.lastUpdate) && Objects.equals(this.lifecycleStatus, serviceSpecificationCreate.lifecycleStatus) && Objects.equals(this.name, serviceSpecificationCreate.name) && Objects.equals(this.version, serviceSpecificationCreate.version) && Objects.equals(this.attachment, serviceSpecificationCreate.attachment) && Objects.equals(this.relatedParty, serviceSpecificationCreate.relatedParty) && Objects.equals(this.resourceSpecification, serviceSpecificationCreate.resourceSpecification) && Objects.equals(this.serviceLevelSpecification, serviceSpecificationCreate.serviceLevelSpecification) && Objects.equals(this.serviceSpecCharacteristic, serviceSpecificationCreate.serviceSpecCharacteristic) && Objects.equals(this.serviceSpecRelationship, serviceSpecificationCreate.serviceSpecRelationship) && Objects.equals(this.targetServiceSchema, serviceSpecificationCreate.targetServiceSchema) && Objects.equals(this.validFor, serviceSpecificationCreate.validFor) && Objects.equals(this.baseType, serviceSpecificationCreate.baseType) && Objects.equals(this.schemaLocation, serviceSpecificationCreate.schemaLocation) && Objects.equals(this.type, serviceSpecificationCreate.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceSpecificationCreate {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    resourceSpecification: ").append(this.toIndentedString(this.resourceSpecification)).append("\n");
        sb.append("    serviceLevelSpecification: ").append(this.toIndentedString(this.serviceLevelSpecification)).append("\n");
        sb.append("    serviceSpecCharacteristic: ").append(this.toIndentedString(this.serviceSpecCharacteristic)).append("\n");
        sb.append("    serviceSpecRelationship: ").append(this.toIndentedString(this.serviceSpecRelationship)).append("\n");
        sb.append("    targetServiceSchema: ").append(this.toIndentedString(this.targetServiceSchema)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

