/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.scm633.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.scm633.model.ServiceSpecificationChangeEvent;
import org.springframework.validation.annotation.Validated;

@Schema(description="The notification data structure")
@Validated
public class ServiceSpecificationChangeNotification {
    @JsonProperty(value="eventId")
    private String eventId = null;
    @JsonProperty(value="eventTime")
    private OffsetDateTime eventTime = null;
    @JsonProperty(value="eventType")
    private String eventType = null;
    @JsonProperty(value="fieldPath")
    private String fieldPath = null;
    @JsonProperty(value="resourcePath")
    private String resourcePath = null;
    @JsonProperty(value="event")
    private ServiceSpecificationChangeEvent event = null;

    public ServiceSpecificationChangeNotification eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @Schema(description="The identifier of the notification")
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public ServiceSpecificationChangeNotification eventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @Schema(description="Time of the event occurrence")
    @Valid
    public OffsetDateTime getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
    }

    public ServiceSpecificationChangeNotification eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @Schema(description="The type of the notification")
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public ServiceSpecificationChangeNotification fieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
        return this;
    }

    @Schema(description="The path identifying the object field concerned by this notification")
    public String getFieldPath() {
        return this.fieldPath;
    }

    public void setFieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
    }

    public ServiceSpecificationChangeNotification resourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
        return this;
    }

    @Schema(description="The path identifying the resource object concerned by this notification")
    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public ServiceSpecificationChangeNotification event(ServiceSpecificationChangeEvent event) {
        this.event = event;
        return this;
    }

    @Schema(description="The event linked to the involved resource object")
    @Valid
    public ServiceSpecificationChangeEvent getEvent() {
        return this.event;
    }

    public void setEvent(ServiceSpecificationChangeEvent event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceSpecificationChangeNotification serviceSpecificationChangeNotification = (ServiceSpecificationChangeNotification)o;
        return Objects.equals(this.eventId, serviceSpecificationChangeNotification.eventId) && Objects.equals(this.eventTime, serviceSpecificationChangeNotification.eventTime) && Objects.equals(this.eventType, serviceSpecificationChangeNotification.eventType) && Objects.equals(this.fieldPath, serviceSpecificationChangeNotification.fieldPath) && Objects.equals(this.resourcePath, serviceSpecificationChangeNotification.resourcePath) && Objects.equals(this.event, serviceSpecificationChangeNotification.event);
    }

    public int hashCode() {
        return Objects.hash(this.eventId, this.eventTime, this.eventType, this.fieldPath, this.resourcePath, this.event);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceSpecificationChangeNotification {\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    fieldPath: ").append(this.toIndentedString(this.fieldPath)).append("\n");
        sb.append("    resourcePath: ").append(this.toIndentedString(this.resourcePath)).append("\n");
        sb.append("    event: ").append(this.toIndentedString(this.event)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

