/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.scm633.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.sd.model.ServiceDescriptor;
import org.etsi.osl.tmf.common.model.AttachmentRef;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationRef;
import org.etsi.osl.tmf.scm633.model.ServiceLevelSpecificationRef;
import org.etsi.osl.tmf.scm633.model.ServiceSpecCharRelationship;
import org.etsi.osl.tmf.scm633.model.ServiceSpecCharacteristic;
import org.etsi.osl.tmf.scm633.model.ServiceSpecRelationship;
import org.etsi.osl.tmf.scm633.model.TargetServiceSchema;
import org.springframework.validation.annotation.Validated;

@Schema(description="ServiceSpecification is a class that offers characteristics to describe a type of service. Functionally, it acts as a template by which Services may be instantiated. By sharing the same  specification, these services would therefore share the same set of characteristics.")
@Validated
@Entity(name="ServiceSpecification")
public class ServiceSpecification
extends BaseEntity {
    @JsonProperty(value="isBundle")
    private Boolean isBundle = null;
    @JsonProperty(value="attachment")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<AttachmentRef> attachment = new HashSet<AttachmentRef>();
    @JsonProperty(value="relatedParty")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<RelatedParty> relatedParty = new HashSet<RelatedParty>();
    @JsonProperty(value="resourceSpecification")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ResourceSpecificationRef> resourceSpecification = new HashSet<ResourceSpecificationRef>();
    @JsonProperty(value="serviceLevelSpecification")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ServiceLevelSpecificationRef> serviceLevelSpecification = new HashSet<ServiceLevelSpecificationRef>();
    @JsonProperty(value="serviceSpecCharacteristic")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ServiceSpecCharacteristic> serviceSpecCharacteristic = new HashSet<ServiceSpecCharacteristic>();
    @JsonProperty(value="serviceSpecRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ServiceSpecRelationship> serviceSpecRelationship = new HashSet<ServiceSpecRelationship>();
    @JsonProperty(value="targetServiceSchema")
    private TargetServiceSchema targetServiceSchema = null;
    @JsonProperty(value="id")
    protected String id = null;
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.DETACH})
    @JoinColumn(name="service_descrid", referencedColumnName="uuid")
    @JsonIgnore
    private ServiceDescriptor serviceDescriptor;
    @JsonIgnore
    @Column(name="candidate_specid")
    private String serviceCandidateObjId;

    public ServiceDescriptor getServiceDescriptor() {
        return this.serviceDescriptor;
    }

    public void setServiceDescriptor(ServiceDescriptor serviceDescriptor) {
        this.serviceDescriptor = serviceDescriptor;
    }

    public String getServiceCandidateObjId() {
        return this.serviceCandidateObjId;
    }

    public void setServiceCandidateObjId(String serviceCandidateObjId) {
        this.serviceCandidateObjId = serviceCandidateObjId;
    }

    public String getId() {
        if (this.uuid != null) {
            this.id = this.uuid;
        }
        return this.id;
    }

    public ServiceSpecification() {
        this.baseType = "BaseEntity";
        this.type = "CustomerFacingServiceSpecification";
    }

    public ServiceSpecification(ServiceSpecification src) {
        this();
        this.name = src.name;
        this.description = src.description;
        this.isBundle = src.isBundle;
        this.lastUpdate = src.lastUpdate;
        this.lifecycleStatus = src.lifecycleStatus;
        this.version = src.version;
        this.validFor = new TimePeriod(src.validFor);
        if (src.attachment != null) {
            for (AttachmentRef attachmentRef : src.attachment) {
                this.addAttachmentItem(new AttachmentRef(attachmentRef));
            }
        }
        if (src.relatedParty != null) {
            for (RelatedParty relatedParty : src.relatedParty) {
                this.addRelatedPartyItem(new RelatedParty(relatedParty));
            }
        }
        if (src.resourceSpecification != null) {
            for (ResourceSpecificationRef resourceSpecificationRef : src.resourceSpecification) {
                this.addResourceSpecificationItem(new ResourceSpecificationRef(resourceSpecificationRef));
            }
        }
        if (src.serviceLevelSpecification != null) {
            for (ServiceLevelSpecificationRef serviceLevelSpecificationRef : src.serviceLevelSpecification) {
                this.addServiceLevelSpecificationItem(new ServiceLevelSpecificationRef(serviceLevelSpecificationRef));
            }
        }
        if (src.serviceSpecCharacteristic != null) {
            for (ServiceSpecCharacteristic serviceSpecCharacteristic : src.serviceSpecCharacteristic) {
                this.addServiceSpecCharacteristicItem(new ServiceSpecCharacteristic(serviceSpecCharacteristic));
            }
        }
        if (src.serviceSpecRelationship != null) {
            for (ServiceSpecRelationship serviceSpecRelationship : src.serviceSpecRelationship) {
                this.addServiceSpecRelationshipItem(new ServiceSpecRelationship(serviceSpecRelationship));
            }
        }
    }

    public ServiceSpecification isBundle(Boolean isBundle) {
        this.isBundle = isBundle;
        return this;
    }

    @Schema(description="isBundle determines whether a ServiceSpecification represents a single ServiceSpecification (false), or a bundle of ServiceSpecification (true).")
    public Boolean isIsBundle() {
        if (this.isBundle == null) {
            this.isBundle = false;
        }
        return this.isBundle;
    }

    public void setIsBundle(Boolean isBundle) {
        this.isBundle = isBundle;
    }

    public ServiceSpecification attachment(Set<AttachmentRef> attachment) {
        this.attachment = attachment;
        return this;
    }

    public ServiceSpecification addAttachmentItem(AttachmentRef attachmentItem) {
        if (this.attachment == null) {
            this.attachment = new HashSet<AttachmentRef>();
        }
        this.attachment.add(attachmentItem);
        return this;
    }

    @Schema(description="A list of attachments (Attachment [*]). Complements the description of the specification through video, pictures...")
    @Valid
    public Set<AttachmentRef> getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Set<AttachmentRef> attachment) {
        this.attachment = attachment;
    }

    public ServiceSpecification relatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ServiceSpecification addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new HashSet<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="A list of related party references (RelatedParty [*]). A related party defines party or party role linked to a specific entity.")
    @Valid
    public Set<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(Set<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ServiceSpecification resourceSpecification(Set<ResourceSpecificationRef> resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
        return this;
    }

    public ServiceSpecification addResourceSpecificationItem(ResourceSpecificationRef resourceSpecificationItem) {
        if (this.resourceSpecification == null) {
            this.resourceSpecification = new HashSet<ResourceSpecificationRef>();
        }
        this.resourceSpecification.add(resourceSpecificationItem);
        return this;
    }

    @Schema(description="A list of resource specification references (ResourceSpecificationRef [*]). The ResourceSpecification is required for a service specification with type ResourceFacingServiceSpecification (RFSS).")
    @Valid
    public Set<ResourceSpecificationRef> getResourceSpecification() {
        return this.resourceSpecification;
    }

    public void setResourceSpecification(Set<ResourceSpecificationRef> resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
    }

    public ServiceSpecification serviceLevelSpecification(Set<ServiceLevelSpecificationRef> serviceLevelSpecification) {
        this.serviceLevelSpecification = serviceLevelSpecification;
        return this;
    }

    public ServiceSpecification addServiceLevelSpecificationItem(ServiceLevelSpecificationRef serviceLevelSpecificationItem) {
        if (this.serviceLevelSpecification == null) {
            this.serviceLevelSpecification = new HashSet<ServiceLevelSpecificationRef>();
        }
        this.serviceLevelSpecification.add(serviceLevelSpecificationItem);
        return this;
    }

    @Schema(description="A list of service level specifications related to this service specification, and which will need to be satisifiable for corresponding service instances; e.g. Gold, Platinum")
    @Valid
    public Set<ServiceLevelSpecificationRef> getServiceLevelSpecification() {
        return this.serviceLevelSpecification;
    }

    public void setServiceLevelSpecification(Set<ServiceLevelSpecificationRef> serviceLevelSpecification) {
        this.serviceLevelSpecification = serviceLevelSpecification;
    }

    public ServiceSpecification serviceSpecCharacteristic(Set<ServiceSpecCharacteristic> serviceSpecCharacteristic) {
        this.serviceSpecCharacteristic = serviceSpecCharacteristic;
        return this;
    }

    public ServiceSpecification addServiceSpecCharacteristicItem(ServiceSpecCharacteristic serviceSpecCharacteristicItem) {
        if (this.serviceSpecCharacteristic == null) {
            this.serviceSpecCharacteristic = new HashSet<ServiceSpecCharacteristic>();
        }
        this.serviceSpecCharacteristic.add(serviceSpecCharacteristicItem);
        return this;
    }

    @Schema(description="A list of service spec characteristics (ServiceSpecCharacteristic [*]). This class represents the key features of this service specification.")
    @Valid
    public Set<ServiceSpecCharacteristic> getServiceSpecCharacteristic() {
        return this.serviceSpecCharacteristic;
    }

    public void setServiceSpecCharacteristic(Set<ServiceSpecCharacteristic> serviceSpecCharacteristic) {
        this.serviceSpecCharacteristic = serviceSpecCharacteristic;
    }

    public ServiceSpecification serviceSpecRelationship(Set<ServiceSpecRelationship> serviceSpecRelationship) {
        this.serviceSpecRelationship = serviceSpecRelationship;
        return this;
    }

    public ServiceSpecification addServiceSpecRelationshipItem(ServiceSpecRelationship serviceSpecRelationshipItem) {
        if (this.serviceSpecRelationship == null) {
            this.serviceSpecRelationship = new HashSet<ServiceSpecRelationship>();
        }
        this.serviceSpecRelationship.add(serviceSpecRelationshipItem);
        return this;
    }

    @Schema(description="A list of service specifications related to this specification, e.g. migration, substitution, dependency or exclusivity relationship")
    @Valid
    public Set<ServiceSpecRelationship> getServiceSpecRelationship() {
        return this.serviceSpecRelationship;
    }

    public void setServiceSpecRelationship(Set<ServiceSpecRelationship> serviceSpecRelationship) {
        this.serviceSpecRelationship = serviceSpecRelationship;
    }

    public ServiceSpecification targetServiceSchema(TargetServiceSchema targetServiceSchema) {
        this.targetServiceSchema = targetServiceSchema;
        return this;
    }

    @Schema(description="A target service schema reference (TargetServiceSchemaRef). The reference object to the schema and type of target service which is described by service specification.")
    @Valid
    public TargetServiceSchema getTargetServiceSchema() {
        return this.targetServiceSchema;
    }

    public void setTargetServiceSchema(TargetServiceSchema targetServiceSchema) {
        this.targetServiceSchema = targetServiceSchema;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceSpecification serviceSpecification = (ServiceSpecification)o;
        return Objects.equals(this.id, serviceSpecification.id) && Objects.equals(this.uuid, serviceSpecification.uuid) && Objects.equals(this.href, serviceSpecification.href) && Objects.equals(this.description, serviceSpecification.description) && Objects.equals(this.isBundle, serviceSpecification.isBundle) && Objects.equals(this.lastUpdate, serviceSpecification.lastUpdate) && Objects.equals(this.lifecycleStatus, serviceSpecification.lifecycleStatus) && Objects.equals(this.name, serviceSpecification.name) && Objects.equals(this.version, serviceSpecification.version) && Objects.equals(this.attachment, serviceSpecification.attachment) && Objects.equals(this.relatedParty, serviceSpecification.relatedParty) && Objects.equals(this.resourceSpecification, serviceSpecification.resourceSpecification) && Objects.equals(this.serviceLevelSpecification, serviceSpecification.serviceLevelSpecification) && Objects.equals(this.serviceSpecCharacteristic, serviceSpecification.serviceSpecCharacteristic) && Objects.equals(this.serviceSpecRelationship, serviceSpecification.serviceSpecRelationship) && Objects.equals(this.targetServiceSchema, serviceSpecification.targetServiceSchema) && Objects.equals(this.validFor, serviceSpecification.validFor) && Objects.equals(this.baseType, serviceSpecification.baseType) && Objects.equals(this.schemaLocation, serviceSpecification.schemaLocation) && Objects.equals(this.type, serviceSpecification.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceSpecification {\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    resourceSpecification: ").append(this.toIndentedString(this.resourceSpecification)).append("\n");
        sb.append("    serviceLevelSpecification: ").append(this.toIndentedString(this.serviceLevelSpecification)).append("\n");
        sb.append("    serviceSpecCharacteristic: ").append(this.toIndentedString(this.serviceSpecCharacteristic)).append("\n");
        sb.append("    serviceSpecRelationship: ").append(this.toIndentedString(this.serviceSpecRelationship)).append("\n");
        sb.append("    targetServiceSchema: ").append(this.toIndentedString(this.targetServiceSchema)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public ServiceSpecCharacteristic findSpecCharacteristicByName(String an) {
        for (ServiceSpecCharacteristic ssci : this.getServiceSpecCharacteristic()) {
            if (!ssci.getName().equals(an)) continue;
            return ssci;
        }
        return null;
    }

    public void fixSpecCharRelationhsipIDs() {
        for (ServiceSpecCharacteristic schar : this.serviceSpecCharacteristic) {
            for (ServiceSpecCharRelationship charRel : schar.getServiceSpecCharRelationship()) {
                if (charRel.getId() == null) {
                    for (ServiceSpecCharacteristic searchChar : this.serviceSpecCharacteristic) {
                        if (!searchChar.getName().equals(charRel.getName())) continue;
                        charRel.setId(searchChar.getUuid());
                        break;
                    }
                }
                if (charRel.getId() != null) continue;
                charRel.setId(this.getName() + "-" + charRel.getName());
            }
        }
    }

    public ServiceSpecCharacteristic getServiceSpecCharacteristicByName(String aName) {
        for (ServiceSpecCharacteristic c : this.getServiceSpecCharacteristic()) {
            if (!c.getName().equals(aName)) continue;
            return c;
        }
        return null;
    }
}

