/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.scm633.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.springframework.validation.annotation.Validated;

@Schema(description="A migration, substitution, dependency or exclusivity relationship between/among service specifications.")
@Validated
@Entity(name="ServiceSpecRelationship")
public class ServiceSpecRelationship
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    protected String id = null;
    @JsonProperty(value="relationshipType")
    private String relationshipType = null;
    @JsonProperty(value="role")
    private String role = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;

    public ServiceSpecRelationship() {
        this.baseType = "BaseRootEntity";
        this.type = this.getClass().getName();
    }

    public ServiceSpecRelationship(ServiceSpecRelationship src) {
        this();
        this.name = src.name;
        this.relationshipType = src.relationshipType;
        this.role = src.role;
        this.validFor = new TimePeriod(src.validFor);
        this.id = src.getId();
    }

    public ServiceSpecRelationship id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of the target serviceSpecification")
    public ServiceSpecRelationship relationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @Schema(description="Type of relationship such as migration, substitution, dependency, exclusivity")
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public ServiceSpecRelationship role(String role) {
        this.role = role;
        return this;
    }

    @Schema(description="The association role for this service specification")
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public ServiceSpecRelationship validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period for which the serviceSpecRelationship is valid")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceSpecRelationship serviceSpecRelationship = (ServiceSpecRelationship)o;
        return Objects.equals(this.id, serviceSpecRelationship.id) && Objects.equals(this.name, serviceSpecRelationship.name) && Objects.equals(this.relationshipType, serviceSpecRelationship.relationshipType) && Objects.equals(this.role, serviceSpecRelationship.role) && Objects.equals(this.validFor, serviceSpecRelationship.validFor) && Objects.equals(this.baseType, serviceSpecRelationship.baseType) && Objects.equals(this.schemaLocation, serviceSpecRelationship.schemaLocation) && Objects.equals(this.type, serviceSpecRelationship.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.name, this.relationshipType, this.role, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceSpecRelationship {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    relationshipType: ").append(this.toIndentedString(this.relationshipType)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

