/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.scm633.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.scm633.model.ServiceSpecCharRelationship;
import org.etsi.osl.tmf.scm633.model.ServiceSpecCharacteristicValue;
import org.springframework.validation.annotation.Validated;

@Schema(description="This class represents the key features of this service specification. For example, bandwidth is a characteristic of many different types of services; if bandwidth is a relevant characteristic (e.g., from the point-of-view of a Customer obtaining this Service via a Product) then bandwidth would be a ServiceSpecCharacteristic for that particular Service.")
@Validated
@Entity(name="ServiceSpecCharacteristic")
public class ServiceSpecCharacteristic
extends BaseRootNamedEntity {
    @JsonProperty(value="configurable")
    private Boolean configurable = null;
    @Lob
    @Column(name="LDESCRIPTION", columnDefinition="LONGTEXT")
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="extensible")
    private Boolean extensible = null;
    @JsonProperty(value="isUnique")
    private Boolean isUnique = null;
    @JsonProperty(value="maxCardinality")
    private Integer maxCardinality = null;
    @JsonProperty(value="minCardinality")
    private Integer minCardinality = null;
    @JsonProperty(value="regex")
    private String regex = null;
    @JsonProperty(value="valueType")
    private String valueType = null;
    @JsonProperty(value="serviceSpecCharRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ServiceSpecCharRelationship> serviceSpecCharRelationship = new HashSet<ServiceSpecCharRelationship>();
    @JsonProperty(value="serviceSpecCharacteristicValue")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<ServiceSpecCharacteristicValue> serviceSpecCharacteristicValue = new HashSet<ServiceSpecCharacteristicValue>();
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;
    @JsonProperty(value="@valueSchemaLocation")
    private String valueSchemaLocation = null;
    @JsonProperty(value="id")
    protected String id = null;

    public String getId() {
        this.id = this.uuid;
        return this.uuid;
    }

    public ServiceSpecCharacteristic configurable(Boolean configurable) {
        this.configurable = configurable;
        return this;
    }

    public ServiceSpecCharacteristic() {
        this.baseType = "BaseRootEntity";
        this.type = this.getClass().getName();
    }

    public ServiceSpecCharacteristic(ServiceSpecCharacteristic src) {
        this();
        this.configurable = src.configurable;
        this.description = src.description;
        this.extensible = src.extensible;
        this.isUnique = src.isUnique;
        this.maxCardinality = src.maxCardinality;
        this.minCardinality = src.minCardinality;
        this.name = src.name;
        this.regex = src.regex;
        this.valueType = src.valueType;
        this.validFor = new TimePeriod(src.validFor);
        for (ServiceSpecCharRelationship serviceSpecCharRelationship : src.serviceSpecCharRelationship) {
            this.addServiceSpecCharRelationshipItem(new ServiceSpecCharRelationship(serviceSpecCharRelationship));
        }
        for (ServiceSpecCharacteristicValue serviceSpecCharacteristicValue : src.serviceSpecCharacteristicValue) {
            this.addServiceSpecCharacteristicValueItem(new ServiceSpecCharacteristicValue(serviceSpecCharacteristicValue));
        }
    }

    @Schema(description="If true, the Boolean indicates that the serviceSpecCharacteristic is configurable")
    public Boolean isConfigurable() {
        return this.configurable;
    }

    public void setConfigurable(Boolean configurable) {
        this.configurable = configurable;
    }

    public ServiceSpecCharacteristic description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A narrative that explains in detail what the serviceSpecCharacteristic is")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ServiceSpecCharacteristic extensible(Boolean extensible) {
        this.extensible = extensible;
        return this;
    }

    @Schema(description="An indicator that specifies that the values for the characteristic can be extended by adding new values when instantiating a characteristic for an Entity.")
    public Boolean isExtensible() {
        return this.extensible;
    }

    public void setExtensible(Boolean extensible) {
        this.extensible = extensible;
    }

    public ServiceSpecCharacteristic isUnique(Boolean isUnique) {
        this.isUnique = isUnique;
        return this;
    }

    @Schema(description="An indicator that specifies if a value is unique for the specification. Possible values are; \"unique while value is in effect\" and \"unique whether value is in effect or not\"")
    public Boolean isIsUnique() {
        return this.isUnique;
    }

    public void setIsUnique(Boolean isUnique) {
        this.isUnique = isUnique;
    }

    public ServiceSpecCharacteristic maxCardinality(Integer maxCardinality) {
        this.maxCardinality = maxCardinality;
        return this;
    }

    @Schema(description="The maximum number of instances a CharacteristicValue can take on. For example, zero to five phone numbers in a group calling plan, where five is the value for the maxCardinality.")
    public Integer getMaxCardinality() {
        return this.maxCardinality;
    }

    public void setMaxCardinality(Integer maxCardinality) {
        this.maxCardinality = maxCardinality;
    }

    public ServiceSpecCharacteristic minCardinality(Integer minCardinality) {
        this.minCardinality = minCardinality;
        return this;
    }

    @Schema(description="The minimum number of instances a CharacteristicValue can take on. For example, zero to five phone numbers in a group calling plan, where zero is the value for the minCardinality.")
    public Integer getMinCardinality() {
        return this.minCardinality;
    }

    public void setMinCardinality(Integer minCardinality) {
        this.minCardinality = minCardinality;
    }

    public ServiceSpecCharacteristic regex(String regex) {
        this.regex = regex;
        return this;
    }

    @Schema(description="A rule or principle represented in regular expression used to derive the value of a characteristic value.")
    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public ServiceSpecCharacteristic valueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    @Schema(description="A kind of value that the characteristic can take on, such as numeric, text and so forth")
    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public ServiceSpecCharacteristic serviceSpecCharRelationship(Set<ServiceSpecCharRelationship> serviceSpecCharRelationship) {
        this.serviceSpecCharRelationship = serviceSpecCharRelationship;
        return this;
    }

    public ServiceSpecCharacteristic addServiceSpecCharRelationshipItem(ServiceSpecCharRelationship serviceSpecCharRelationshipItem) {
        if (this.serviceSpecCharRelationship == null) {
            this.serviceSpecCharRelationship = new HashSet<ServiceSpecCharRelationship>();
        }
        this.serviceSpecCharRelationship.add(serviceSpecCharRelationshipItem);
        return this;
    }

    @Schema(description="A list of service spec char relationships (ServiceSpecCharRelationship [*]). An aggregation, migration, substitution, dependency or exclusivity relationship between/among Specification Characteristics.")
    @Valid
    public Set<ServiceSpecCharRelationship> getServiceSpecCharRelationship() {
        return this.serviceSpecCharRelationship;
    }

    public void setServiceSpecCharRelationship(Set<ServiceSpecCharRelationship> serviceSpecCharRelationship) {
        this.serviceSpecCharRelationship = serviceSpecCharRelationship;
    }

    public ServiceSpecCharacteristic serviceSpecCharacteristicValue(Set<ServiceSpecCharacteristicValue> serviceSpecCharacteristicValue) {
        this.serviceSpecCharacteristicValue = serviceSpecCharacteristicValue;
        return this;
    }

    public ServiceSpecCharacteristic addServiceSpecCharacteristicValueItem(ServiceSpecCharacteristicValue serviceSpecCharacteristicValueItem) {
        if (this.serviceSpecCharacteristicValue == null) {
            this.serviceSpecCharacteristicValue = new HashSet<ServiceSpecCharacteristicValue>();
        }
        this.serviceSpecCharacteristicValue.add(serviceSpecCharacteristicValueItem);
        return this;
    }

    @Schema(description="A list of service spec characteristic values (ServiceSpecCharacteristicValue [*]). A ServiceSpecCharacteristicValue object is used to define a set of attributes, each of which can be assigned to a corresponding set of attributes in a ServiceSpecCharacteristic object. The values of the attributes in the ServiceSpecCharacteristicValue object describe the values of the attributes that a corresponding ServiceSpecCharacteristic object can take on.")
    @Valid
    public Set<ServiceSpecCharacteristicValue> getServiceSpecCharacteristicValue() {
        return this.serviceSpecCharacteristicValue;
    }

    public void setServiceSpecCharacteristicValue(Set<ServiceSpecCharacteristicValue> serviceSpecCharacteristicValue) {
        this.serviceSpecCharacteristicValue = serviceSpecCharacteristicValue;
    }

    public ServiceSpecCharacteristic validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period for which the serviceSpecCharacteristic is valid")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ServiceSpecCharacteristic valueSchemaLocation(String valueSchemaLocation) {
        this.valueSchemaLocation = valueSchemaLocation;
        return this;
    }

    @Schema(description="This (optional) field provides a link to the schema describing the value type.")
    public String getValueSchemaLocation() {
        return this.valueSchemaLocation;
    }

    public void setValueSchemaLocation(String valueSchemaLocation) {
        this.valueSchemaLocation = valueSchemaLocation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceSpecCharacteristic serviceSpecCharacteristic = (ServiceSpecCharacteristic)o;
        return Objects.equals(this.configurable, serviceSpecCharacteristic.configurable) && Objects.equals(this.description, serviceSpecCharacteristic.description) && Objects.equals(this.extensible, serviceSpecCharacteristic.extensible) && Objects.equals(this.isUnique, serviceSpecCharacteristic.isUnique) && Objects.equals(this.maxCardinality, serviceSpecCharacteristic.maxCardinality) && Objects.equals(this.minCardinality, serviceSpecCharacteristic.minCardinality) && Objects.equals(this.name, serviceSpecCharacteristic.name) && Objects.equals(this.regex, serviceSpecCharacteristic.regex) && Objects.equals(this.valueType, serviceSpecCharacteristic.valueType) && Objects.equals(this.serviceSpecCharRelationship, serviceSpecCharacteristic.serviceSpecCharRelationship) && Objects.equals(this.serviceSpecCharacteristicValue, serviceSpecCharacteristic.serviceSpecCharacteristicValue) && Objects.equals(this.validFor, serviceSpecCharacteristic.validFor) && Objects.equals(this.baseType, serviceSpecCharacteristic.baseType) && Objects.equals(this.schemaLocation, serviceSpecCharacteristic.schemaLocation) && Objects.equals(this.type, serviceSpecCharacteristic.type) && Objects.equals(this.valueSchemaLocation, serviceSpecCharacteristic.valueSchemaLocation);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceSpecCharacteristic {\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    configurable: ").append(this.toIndentedString(this.configurable)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    extensible: ").append(this.toIndentedString(this.extensible)).append("\n");
        sb.append("    isUnique: ").append(this.toIndentedString(this.isUnique)).append("\n");
        sb.append("    maxCardinality: ").append(this.toIndentedString(this.maxCardinality)).append("\n");
        sb.append("    minCardinality: ").append(this.toIndentedString(this.minCardinality)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    regex: ").append(this.toIndentedString(this.regex)).append("\n");
        sb.append("    valueType: ").append(this.toIndentedString(this.valueType)).append("\n");
        sb.append("    serviceSpecCharRelationship: ").append(this.toIndentedString(this.serviceSpecCharRelationship)).append("\n");
        sb.append("    serviceSpecCharacteristicValue: ").append(this.toIndentedString(this.serviceSpecCharacteristicValue)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    valueSchemaLocation: ").append(this.toIndentedString(this.valueSchemaLocation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public void updateWith(ServiceSpecCharacteristic src) {
        this.name = src.getName();
        this.description = src.getDescription();
        this.maxCardinality = src.getMaxCardinality();
        this.minCardinality = src.getMinCardinality();
        this.regex = src.getRegex();
        this.isUnique = src.isUnique;
        this.configurable = src.isConfigurable();
        this.extensible = src.isExtensible();
        this.valueType = src.valueType;
        this.updateServiceSpecCharacteristicValues(src.getServiceSpecCharacteristicValue());
        this.updateServiceSpecCharRelationships(src.getServiceSpecCharRelationship());
    }

    private void updateServiceSpecCharacteristicValues(@Valid Set<ServiceSpecCharacteristicValue> srcSet) {
        if (srcSet == null) {
            return;
        }
        HashMap<Integer, Boolean> idAddedUpdated = new HashMap<Integer, Boolean>();
        for (ServiceSpecCharacteristicValue r : srcSet) {
            boolean valueExists = false;
            for (ServiceSpecCharacteristicValue thisCharVal : this.serviceSpecCharacteristicValue) {
                if (thisCharVal.hashCode() != r.hashCode()) continue;
                valueExists = true;
                idAddedUpdated.put(thisCharVal.hashCode(), true);
                break;
            }
            if (valueExists) continue;
            ServiceSpecCharacteristicValue nr = new ServiceSpecCharacteristicValue(r);
            this.addServiceSpecCharacteristicValueItem(nr);
            idAddedUpdated.put(nr.hashCode(), true);
        }
        ArrayList<ServiceSpecCharacteristicValue> toRemove = new ArrayList<ServiceSpecCharacteristicValue>();
        for (ServiceSpecCharacteristicValue ss : this.serviceSpecCharacteristicValue) {
            if (idAddedUpdated.get(ss.hashCode()) != null) continue;
            toRemove.add(ss);
        }
        for (ServiceSpecCharacteristicValue r : toRemove) {
            this.serviceSpecCharacteristicValue.remove(r);
        }
    }

    private void updateServiceSpecCharRelationships(@Valid Set<ServiceSpecCharRelationship> srcSet) {
        HashMap<String, Boolean> idAddedUpdated = new HashMap<String, Boolean>();
        for (ServiceSpecCharRelationship r : srcSet) {
            boolean valueExists = false;
            for (ServiceSpecCharRelationship thisCharVal : this.serviceSpecCharRelationship) {
                if (thisCharVal.getId() == null || !thisCharVal.getId().equals(r.getId())) continue;
                valueExists = true;
                idAddedUpdated.put(thisCharVal.getId(), true);
                break;
            }
            if (valueExists) continue;
            this.serviceSpecCharRelationship.add(new ServiceSpecCharRelationship(r));
            idAddedUpdated.put(r.getId(), true);
        }
        ArrayList<ServiceSpecCharRelationship> toRemove = new ArrayList<ServiceSpecCharRelationship>();
        for (ServiceSpecCharRelationship ss : this.serviceSpecCharRelationship) {
            if (idAddedUpdated.get(ss.getId()) != null) continue;
            toRemove.add(ss);
        }
        for (ServiceSpecCharRelationship r : toRemove) {
            this.serviceSpecCharRelationship.remove(r);
        }
    }

    @JsonIgnore
    public String getDefaultValue() {
        for (ServiceSpecCharacteristicValue val : this.getServiceSpecCharacteristicValue()) {
            if (!val.isIsDefault().booleanValue()) continue;
            return val.getValue().getValue();
        }
        return null;
    }
}

