/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.scm633.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.validation.annotation.Validated;

@Schema(description="An aggregation, migration, substitution, dependency or exclusivity relationship between/among serviceSpecCharacteristics.")
@Validated
@Entity(name="ServiceSpecCharRelationship")
public class ServiceSpecCharRelationship {
    @Id
    @GeneratedValue(generator="uuid")
    @GenericGenerator(name="uuid", strategy="uuid2")
    protected String uuid = null;
    @JsonProperty(value="id")
    protected String id = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="relationshipType")
    private String relationshipType = null;
    @JsonProperty(value="@baseType")
    protected String baseType = "BaseEntity";
    @JsonProperty(value="@schemaLocation")
    protected String schemaLocation = null;
    @JsonProperty(value="@type")
    protected String type = null;
    @JsonProperty(value="role")
    private String role = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;

    public ServiceSpecCharRelationship() {
    }

    public ServiceSpecCharRelationship(ServiceSpecCharRelationship src) {
        this.name = src.name;
        this.relationshipType = src.relationshipType;
        this.role = src.role;
        this.validFor = new TimePeriod(src.validFor);
        this.id = src.id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public ServiceSpecCharRelationship relationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @Schema(description="Type of relationship such as aggregation, migration, substitution, dependency, exclusivity")
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public ServiceSpecCharRelationship role(String role) {
        this.role = role;
        return this;
    }

    @Schema(description="The association role for this service specification")
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public ServiceSpecCharRelationship validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period for which the serviceSpecCharRelationship is valid")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceSpecCharRelationship serviceSpecCharRelationship = (ServiceSpecCharRelationship)o;
        return Objects.equals(this.id, serviceSpecCharRelationship.id) && Objects.equals(this.name, serviceSpecCharRelationship.name) && Objects.equals(this.relationshipType, serviceSpecCharRelationship.relationshipType) && Objects.equals(this.role, serviceSpecCharRelationship.role) && Objects.equals(this.validFor, serviceSpecCharRelationship.validFor) && Objects.equals(this.baseType, serviceSpecCharRelationship.baseType) && Objects.equals(this.schemaLocation, serviceSpecCharRelationship.schemaLocation) && Objects.equals(this.type, serviceSpecCharRelationship.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceSpecCharRelationship {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    relationshipType: ").append(this.toIndentedString(this.relationshipType)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

