/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.scm633.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="A Service Level Specification represents a pre-defined or negotiated set of Service Level  Objectives. In addition, certain consequences are associated with not meeting the Service Level  Objectives. Service Level Agreements are expressed in terms of Service Level Specifications.")
@Validated
@Entity(name="ServiceLevelSpecificationRef")
public class ServiceLevelSpecificationRef
extends BaseRootNamedEntity {
    @JsonProperty(value="@referredType")
    private String referredType = null;
    @JsonProperty(value="id")
    protected String id = null;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ServiceLevelSpecificationRef id(String id) {
        this.id = id;
        return this;
    }

    public ServiceLevelSpecificationRef() {
        this.baseType = "BaseRootEntity";
        this.type = this.getClass().getName();
    }

    public ServiceLevelSpecificationRef(ServiceLevelSpecificationRef r) {
        this();
        this.name = r.name;
        this.id = r.id;
    }

    public ServiceLevelSpecificationRef referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceLevelSpecificationRef serviceLevelSpecificationRef = (ServiceLevelSpecificationRef)o;
        return Objects.equals(this.id, serviceLevelSpecificationRef.id) && Objects.equals(this.href, serviceLevelSpecificationRef.href) && Objects.equals(this.name, serviceLevelSpecificationRef.name) && Objects.equals(this.baseType, serviceLevelSpecificationRef.baseType) && Objects.equals(this.schemaLocation, serviceLevelSpecificationRef.schemaLocation) && Objects.equals(this.type, serviceLevelSpecificationRef.type) && Objects.equals(this.referredType, serviceLevelSpecificationRef.referredType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.href, this.name, this.baseType, this.schemaLocation, this.type, this.referredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceLevelSpecificationRef {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

