/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.scm633.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.scm633.model.ServiceCandidateRef;
import org.etsi.osl.tmf.scm633.model.ServiceCategoryRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="The (service) category resource is used to group service candidates in logical containers. Categories can contain other categories. Skipped properties: id,href,lastUpdate")
@Validated
public class ServiceCategoryUpdate {
    @JsonProperty(value="description")
    protected String description = null;
    @JsonProperty(value="isRoot")
    protected Boolean isRoot = null;
    @JsonProperty(value="lifecycleStatus")
    protected String lifecycleStatus = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="parentId")
    protected String parentId = null;
    @JsonProperty(value="version")
    protected String version = null;
    @JsonProperty(value="category")
    @Valid
    protected List<ServiceCategoryRef> category = null;
    @JsonProperty(value="serviceCandidate")
    @Valid
    protected List<ServiceCandidateRef> serviceCandidate = null;
    @JsonProperty(value="validFor")
    protected TimePeriod validFor = null;
    @JsonProperty(value="@baseType")
    protected String baseType = null;
    @JsonProperty(value="@schemaLocation")
    protected String schemaLocation = null;
    @JsonProperty(value="@type")
    protected String type = null;

    public ServiceCategoryUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of the category")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ServiceCategoryUpdate isRoot(Boolean isRoot) {
        this.isRoot = isRoot;
        return this;
    }

    @Schema(description="If true, this Boolean indicates that the category is a root of categories")
    public Boolean isIsRoot() {
        return this.isRoot;
    }

    public void setIsRoot(Boolean isRoot) {
        this.isRoot = isRoot;
    }

    public ServiceCategoryUpdate lifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
        return this;
    }

    @Schema(description="Used to indicate the current lifecycle status")
    public String getLifecycleStatus() {
        return this.lifecycleStatus;
    }

    public void setLifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
    }

    public ServiceCategoryUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the category")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ServiceCategoryUpdate parentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    @Schema(description="Unique identifier of the parent category")
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public ServiceCategoryUpdate version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="ServiceCategory version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ServiceCategoryUpdate category(List<ServiceCategoryRef> category) {
        this.category = category;
        return this;
    }

    public ServiceCategoryUpdate addCategoryItem(ServiceCategoryRef categoryItem) {
        if (this.category == null) {
            this.category = new ArrayList<ServiceCategoryRef>();
        }
        this.category.add(categoryItem);
        return this;
    }

    @Schema(description="List of child categories in the tree for in this category")
    @Valid
    public List<ServiceCategoryRef> getCategory() {
        return this.category;
    }

    public void setCategory(List<ServiceCategoryRef> category) {
        this.category = category;
    }

    public ServiceCategoryUpdate serviceCandidate(List<ServiceCandidateRef> serviceCandidate) {
        this.serviceCandidate = serviceCandidate;
        return this;
    }

    public ServiceCategoryUpdate addServiceCandidateItem(ServiceCandidateRef serviceCandidateItem) {
        if (this.serviceCandidate == null) {
            this.serviceCandidate = new ArrayList<ServiceCandidateRef>();
        }
        this.serviceCandidate.add(serviceCandidateItem);
        return this;
    }

    @Schema(description="List of service candidates associated with this category")
    @Valid
    public List<ServiceCandidateRef> getServiceCandidate() {
        return this.serviceCandidate;
    }

    public void setServiceCandidate(List<ServiceCandidateRef> serviceCandidate) {
        this.serviceCandidate = serviceCandidate;
    }

    public ServiceCategoryUpdate validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period for which the category is valid")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ServiceCategoryUpdate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ServiceCategoryUpdate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ServiceCategoryUpdate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceCategoryUpdate serviceCategoryUpdate = (ServiceCategoryUpdate)o;
        return Objects.equals(this.description, serviceCategoryUpdate.description) && Objects.equals(this.isRoot, serviceCategoryUpdate.isRoot) && Objects.equals(this.lifecycleStatus, serviceCategoryUpdate.lifecycleStatus) && Objects.equals(this.name, serviceCategoryUpdate.name) && Objects.equals(this.parentId, serviceCategoryUpdate.parentId) && Objects.equals(this.version, serviceCategoryUpdate.version) && Objects.equals(this.category, serviceCategoryUpdate.category) && Objects.equals(this.serviceCandidate, serviceCategoryUpdate.serviceCandidate) && Objects.equals(this.validFor, serviceCategoryUpdate.validFor) && Objects.equals(this.baseType, serviceCategoryUpdate.baseType) && Objects.equals(this.schemaLocation, serviceCategoryUpdate.schemaLocation) && Objects.equals(this.type, serviceCategoryUpdate.type);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.isRoot, this.lifecycleStatus, this.name, this.parentId, this.version, this.category, this.serviceCandidate, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceCategoryUpdate {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isRoot: ").append(this.toIndentedString(this.isRoot)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    serviceCandidate: ").append(this.toIndentedString(this.serviceCandidate)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

