/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.scm633.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.scm633.model.ServiceCategoryUpdate;
import org.springframework.validation.annotation.Validated;

@Schema(description="The (service) category resource is used to group service candidates in logical containers. Categories can contain other categories. Skipped properties: id,href")
@Validated
public class ServiceCategoryCreate
extends ServiceCategoryUpdate {
    @JsonProperty(value="lastUpdate")
    private OffsetDateTime lastUpdate = null;

    @Schema(description="Date and time of the last update")
    @Valid
    public OffsetDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceCategoryCreate serviceCategoryCreate = (ServiceCategoryCreate)o;
        return Objects.equals(this.description, serviceCategoryCreate.description) && Objects.equals(this.isRoot, serviceCategoryCreate.isRoot) && Objects.equals(this.lastUpdate, serviceCategoryCreate.lastUpdate) && Objects.equals(this.lifecycleStatus, serviceCategoryCreate.lifecycleStatus) && Objects.equals(this.name, serviceCategoryCreate.name) && Objects.equals(this.parentId, serviceCategoryCreate.parentId) && Objects.equals(this.version, serviceCategoryCreate.version) && Objects.equals(this.category, serviceCategoryCreate.category) && Objects.equals(this.serviceCandidate, serviceCategoryCreate.serviceCandidate) && Objects.equals(this.validFor, serviceCategoryCreate.validFor) && Objects.equals(this.baseType, serviceCategoryCreate.baseType) && Objects.equals(this.schemaLocation, serviceCategoryCreate.schemaLocation) && Objects.equals(this.type, serviceCategoryCreate.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.description, this.isRoot, this.lastUpdate, this.lifecycleStatus, this.name, this.parentId, this.version, this.category, this.serviceCandidate, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceCategoryCreate {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isRoot: ").append(this.toIndentedString(this.isRoot)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    serviceCandidate: ").append(this.toIndentedString(this.serviceCandidate)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

