/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.scm633.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.scm633.model.ServiceCandidate;
import org.etsi.osl.tmf.scm633.model.ServiceCandidateRef;
import org.etsi.osl.tmf.scm633.model.ServiceCategoryRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="The (service) category resource is used to group service candidates in logical containers. Categories can contain other categories.")
@Validated
@Entity(name="ServiceCategory")
@Table(name="ServiceCategory")
public class ServiceCategory
extends BaseEntity {
    @JsonProperty(value="isRoot")
    private Boolean isRoot = null;
    @JsonProperty(value="parentId")
    private String parentId = null;
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.DETACH})
    @JoinTable
    @JsonIgnore
    private Set<ServiceCategory> categoryObj = new HashSet<ServiceCategory>();
    @ManyToMany(cascade={CascadeType.MERGE, CascadeType.REMOVE})
    @JoinTable
    @JsonIgnore
    private Set<ServiceCandidate> serviceCandidateObj = new HashSet<ServiceCandidate>();
    @JsonProperty(value="id")
    protected String id = null;

    public String getId() {
        this.id = this.uuid;
        return this.uuid;
    }

    public ServiceCategory() {
        this.baseType = "BaseEntity";
        this.type = "ServiceCategory";
    }

    @Schema(description="If true, this Boolean indicates that the category is a root of categories")
    public Boolean isIsRoot() {
        return this.isRoot;
    }

    public void setIsRoot(Boolean isRoot) {
        this.isRoot = isRoot == null ? Boolean.valueOf(true) : isRoot;
    }

    @Schema(description="Unique identifier of the parent category")
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Schema(description="List of child categories in the tree for in this category")
    @Transient
    @JsonProperty(value="category")
    @Valid
    public List<ServiceCategoryRef> getCategoryRefs() {
        ArrayList<ServiceCategoryRef> category = new ArrayList<ServiceCategoryRef>();
        for (ServiceCategory serviceCategory : this.categoryObj) {
            ServiceCategoryRef scr = new ServiceCategoryRef();
            scr.setId(serviceCategory.getId());
            scr.setName(serviceCategory.getName());
            scr.setBaseType(ServiceCategoryRef.class.getName());
            category.add(scr);
        }
        return category;
    }

    @JsonProperty(value="category")
    public void setCategoryObj(List<ServiceCategoryRef> alist) {
        this.categoryObj.clear();
        for (ServiceCategoryRef serviceCategoryRef : alist) {
            ServiceCategory sc = new ServiceCategory();
            sc.setUuid(serviceCategoryRef.getId());
            sc.setName(serviceCategoryRef.getName());
            sc.setBaseType(serviceCategoryRef.getBaseType());
            this.categoryObj.add(sc);
        }
    }

    public Set<ServiceCategory> getCategoryObj() {
        return this.categoryObj;
    }

    public void setCategoryObj(Set<ServiceCategory> categoryObj) {
        this.categoryObj = categoryObj;
    }

    @Schema(description="List of service candidates associated with this category")
    @Valid
    @JsonProperty(value="serviceCandidate")
    public List<ServiceCandidateRef> getServiceCandidateRefs() {
        ArrayList<ServiceCandidateRef> scref = new ArrayList<ServiceCandidateRef>();
        for (ServiceCandidate sc : this.serviceCandidateObj) {
            ServiceCandidateRef scr = new ServiceCandidateRef();
            scr.setId(sc.getId());
            scr.setName(sc.getName());
            scr.setVersion(sc.getVersion());
            scr.setBaseType(ServiceCategoryRef.class.getName());
            scref.add(scr);
        }
        return scref;
    }

    public Set<ServiceCandidate> getServiceCandidateObj() {
        return this.serviceCandidateObj;
    }

    @JsonProperty(value="serviceCandidate")
    public void setServiceCandidateObj(Set<ServiceCandidate> serviceCandidateObj) {
        this.serviceCandidateObj = serviceCandidateObj;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceCategory serviceCategory = (ServiceCategory)o;
        return Objects.equals(this.id, serviceCategory.id) && Objects.equals(this.href, serviceCategory.href) && Objects.equals(this.description, serviceCategory.description) && Objects.equals(this.isRoot, serviceCategory.isRoot) && Objects.equals(this.lastUpdate, serviceCategory.lastUpdate) && Objects.equals(this.lifecycleStatus, serviceCategory.lifecycleStatus) && Objects.equals(this.name, serviceCategory.name) && Objects.equals(this.parentId, serviceCategory.parentId) && Objects.equals(this.version, serviceCategory.version) && Objects.equals(this.getCategoryRefs(), serviceCategory.getCategoryRefs()) && Objects.equals(this.getServiceCandidateRefs(), serviceCategory.getServiceCandidateRefs()) && Objects.equals(this.validFor, serviceCategory.validFor) && Objects.equals(this.baseType, serviceCategory.baseType) && Objects.equals(this.schemaLocation, serviceCategory.schemaLocation) && Objects.equals(this.type, serviceCategory.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceCategory {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isRoot: ").append(this.toIndentedString(this.isRoot)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.getCategoryRefs())).append("\n");
        sb.append("    serviceCandidate: ").append(this.toIndentedString(this.getServiceCandidateRefs())).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

