/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.scm633.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.scm633.model.ServiceCategoryRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="The root entity for service catalog management. A service catalog is a group of service specifications made available through service candidates that an organization provides to the consumers (internal consumers like its employees or B2B customers or B2C customers).  A service catalog typically includes name, description and time period that is valid for. It will have a list of ServiceCandidate catalog items. A ServiceCandidate is an entity that makes a ServiceSpecification available to a catalog. A ServiceCandidate and its associated ServiceSpecification may be \"published\" - made visible -in any number of ServiceCatalogs, or in none. Skipped properties: id,href,lastUpdate")
@Validated
public class ServiceCatalogUpdate {
    @JsonProperty(value="description")
    protected String description = null;
    @JsonProperty(value="lifecycleStatus")
    protected String lifecycleStatus = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="version")
    protected String version = null;
    @JsonProperty(value="category")
    @Valid
    protected List<ServiceCategoryRef> category = null;
    @JsonProperty(value="relatedParty")
    @Valid
    protected List<RelatedParty> relatedParty = null;
    @JsonProperty(value="validFor")
    protected TimePeriod validFor = null;
    @JsonProperty(value="@baseType")
    protected String baseType = null;
    @JsonProperty(value="@schemaLocation")
    protected String schemaLocation = null;
    @JsonProperty(value="@type")
    protected String type = null;

    public ServiceCatalogUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of this catalog")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ServiceCatalogUpdate lifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
        return this;
    }

    @Schema(description="Used to indicate the current lifecycle status")
    public String getLifecycleStatus() {
        return this.lifecycleStatus;
    }

    public void setLifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
    }

    public ServiceCatalogUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the service catalog")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ServiceCatalogUpdate version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="ServiceCatalog version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ServiceCatalogUpdate category(List<ServiceCategoryRef> category) {
        this.category = category;
        return this;
    }

    public ServiceCatalogUpdate addCategoryItem(ServiceCategoryRef categoryItem) {
        if (this.category == null) {
            this.category = new ArrayList<ServiceCategoryRef>();
        }
        this.category.add(categoryItem);
        return this;
    }

    @Schema(description="List of service categories associated with this catalog")
    @Valid
    public List<ServiceCategoryRef> getCategory() {
        return this.category;
    }

    public void setCategory(List<ServiceCategoryRef> category) {
        this.category = category;
    }

    public ServiceCatalogUpdate relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ServiceCatalogUpdate addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="List of parties or party roles related to this category")
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ServiceCatalogUpdate validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period for which the service catalog is valid")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ServiceCatalogUpdate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ServiceCatalogUpdate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ServiceCatalogUpdate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceCatalogUpdate serviceCatalogUpdate = (ServiceCatalogUpdate)o;
        return Objects.equals(this.description, serviceCatalogUpdate.description) && Objects.equals(this.lifecycleStatus, serviceCatalogUpdate.lifecycleStatus) && Objects.equals(this.name, serviceCatalogUpdate.name) && Objects.equals(this.version, serviceCatalogUpdate.version) && Objects.equals(this.category, serviceCatalogUpdate.category) && Objects.equals(this.relatedParty, serviceCatalogUpdate.relatedParty) && Objects.equals(this.validFor, serviceCatalogUpdate.validFor) && Objects.equals(this.baseType, serviceCatalogUpdate.baseType) && Objects.equals(this.schemaLocation, serviceCatalogUpdate.schemaLocation) && Objects.equals(this.type, serviceCatalogUpdate.type);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.lifecycleStatus, this.name, this.version, this.category, this.relatedParty, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceCatalogUpdate {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

