/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.scm633.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.scm633.model.ServiceCatalogCreateEvent;
import org.springframework.validation.annotation.Validated;

@Schema(description="The notification data structure")
@Validated
public class ServiceCatalogCreateNotification {
    @JsonProperty(value="eventId")
    private String eventId = null;
    @JsonProperty(value="eventTime")
    private OffsetDateTime eventTime = null;
    @JsonProperty(value="eventType")
    private String eventType = null;
    @JsonProperty(value="fieldPath")
    private String fieldPath = null;
    @JsonProperty(value="resourcePath")
    private String resourcePath = null;
    @JsonProperty(value="event")
    private ServiceCatalogCreateEvent event = null;

    public ServiceCatalogCreateNotification eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @Schema(description="The identifier of the notification")
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public ServiceCatalogCreateNotification eventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @Schema(description="Time of the event occurrence")
    @Valid
    public OffsetDateTime getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
    }

    public ServiceCatalogCreateNotification eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @Schema(description="The type of the notification")
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public ServiceCatalogCreateNotification fieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
        return this;
    }

    @Schema(description="The path identifying the object field concerned by this notification")
    public String getFieldPath() {
        return this.fieldPath;
    }

    public void setFieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
    }

    public ServiceCatalogCreateNotification resourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
        return this;
    }

    @Schema(description="The path identifying the resource object concerned by this notification")
    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public ServiceCatalogCreateNotification event(ServiceCatalogCreateEvent event) {
        this.event = event;
        return this;
    }

    @Schema(description="The event linked to the involved resource object")
    @Valid
    public ServiceCatalogCreateEvent getEvent() {
        return this.event;
    }

    public void setEvent(ServiceCatalogCreateEvent event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceCatalogCreateNotification serviceCatalogCreateNotification = (ServiceCatalogCreateNotification)o;
        return Objects.equals(this.eventId, serviceCatalogCreateNotification.eventId) && Objects.equals(this.eventTime, serviceCatalogCreateNotification.eventTime) && Objects.equals(this.eventType, serviceCatalogCreateNotification.eventType) && Objects.equals(this.fieldPath, serviceCatalogCreateNotification.fieldPath) && Objects.equals(this.resourcePath, serviceCatalogCreateNotification.resourcePath) && Objects.equals(this.event, serviceCatalogCreateNotification.event);
    }

    public int hashCode() {
        return Objects.hash(this.eventId, this.eventTime, this.eventType, this.fieldPath, this.resourcePath, this.event);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceCatalogCreateNotification {\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    fieldPath: ").append(this.toIndentedString(this.fieldPath)).append("\n");
        sb.append("    resourcePath: ").append(this.toIndentedString(this.resourcePath)).append("\n");
        sb.append("    event: ").append(this.toIndentedString(this.event)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

