/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.scm633.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.scm633.model.ServiceCatalogUpdate;
import org.springframework.validation.annotation.Validated;

@Schema(description="The root entity for service catalog management. A service catalog is a group of service specifications made available through service candidates that an organization provides to the consumers (internal consumers like its employees or B2B customers or B2C customers).  A service catalog typically includes name, description and time period that is valid for. It will have a list of ServiceCandidate catalog items. A ServiceCandidate is an entity that makes a ServiceSpecification available to a catalog. A ServiceCandidate and its associated ServiceSpecification may be \"published\" - made visible -in any number of ServiceCatalogs, or in none. Skipped properties: id,href")
@Validated
public class ServiceCatalogCreate
extends ServiceCatalogUpdate {
    @JsonProperty(value="lastUpdate")
    private OffsetDateTime lastUpdate = null;

    public ServiceCatalogCreate lastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Schema(description="Date and time of the last update")
    @Valid
    public OffsetDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceCatalogCreate serviceCatalogCreate = (ServiceCatalogCreate)o;
        return Objects.equals(this.description, serviceCatalogCreate.description) && Objects.equals(this.lastUpdate, serviceCatalogCreate.lastUpdate) && Objects.equals(this.lifecycleStatus, serviceCatalogCreate.lifecycleStatus) && Objects.equals(this.name, serviceCatalogCreate.name) && Objects.equals(this.version, serviceCatalogCreate.version) && Objects.equals(this.category, serviceCatalogCreate.category) && Objects.equals(this.relatedParty, serviceCatalogCreate.relatedParty) && Objects.equals(this.validFor, serviceCatalogCreate.validFor) && Objects.equals(this.baseType, serviceCatalogCreate.baseType) && Objects.equals(this.schemaLocation, serviceCatalogCreate.schemaLocation) && Objects.equals(this.type, serviceCatalogCreate.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.description, this.lastUpdate, this.lifecycleStatus, this.name, this.version, this.category, this.relatedParty, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceCatalogCreate {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

