/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.scm633.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.scm633.model.ServiceCategory;
import org.etsi.osl.tmf.scm633.model.ServiceCategoryRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="The root entity for service catalog management. A service catalog is a group of service specifications made available through service candidates that an organization provides to the consumers (internal consumers like its employees or B2B customers or B2C customers).  A service catalog typically includes name, description and time period that is valid for. It will have a list of ServiceCandidate catalog items. A ServiceCandidate is an entity that makes a ServiceSpecification available to a catalog. A ServiceCandidate and its associated ServiceSpecification may be \"published\" - made visible -in any number of ServiceCatalogs, or in none.")
@Validated
@Entity(name="ServiceCatalog")
@Table(name="ServiceCatalog")
public class ServiceCatalog
extends BaseEntity {
    @ManyToMany(cascade={CascadeType.DETACH})
    @JoinTable
    @JsonIgnore
    private Set<ServiceCategory> categoryObj = new HashSet<ServiceCategory>();
    @Transient
    @JsonProperty(value="relatedParty")
    @Valid
    private List<RelatedParty> relatedParty = null;
    @JsonProperty(value="id")
    protected String id = null;

    public ServiceCatalog() {
        this.type = "ServiceCatalog";
        this.baseType = "BaseEntity";
    }

    public String getId() {
        return this.uuid;
    }

    @Schema(description="List of service categories associated with this catalog")
    @Transient
    @JsonProperty(value="category")
    @Valid
    public List<ServiceCategoryRef> getCategoryRefs() {
        ArrayList<ServiceCategoryRef> category = new ArrayList<ServiceCategoryRef>();
        for (ServiceCategory serviceCategory : this.categoryObj) {
            ServiceCategoryRef scr = new ServiceCategoryRef();
            scr.setId(serviceCategory.getId());
            scr.setName(serviceCategory.getName());
            scr.setBaseType(ServiceCategoryRef.class.getName());
            category.add(scr);
        }
        return category;
    }

    public void setCategoryRefs(List<ServiceCategoryRef> crefs) {
        for (ServiceCategoryRef serviceCategoryRef : crefs) {
            ServiceCategory e = new ServiceCategory();
            e.setUuid(serviceCategoryRef.getId());
            e.setName(serviceCategoryRef.getName());
            this.categoryObj.add(e);
        }
    }

    public Set<ServiceCategory> getCategoryObj() {
        return this.categoryObj;
    }

    public void setCategoryObj(Set<ServiceCategory> categoryObj) {
        this.categoryObj = categoryObj;
    }

    public ServiceCatalog relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ServiceCatalog addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="List of parties or party roles related to this category")
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    @Override
    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    @Override
    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    @Override
    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceCatalog serviceCatalog = (ServiceCatalog)o;
        return Objects.equals(this.id, serviceCatalog.id) && Objects.equals(this.href, serviceCatalog.href) && Objects.equals(this.description, serviceCatalog.description) && Objects.equals(this.lastUpdate, serviceCatalog.lastUpdate) && Objects.equals(this.lifecycleStatus, serviceCatalog.lifecycleStatus) && Objects.equals(this.name, serviceCatalog.name) && Objects.equals(this.version, serviceCatalog.version) && Objects.equals(this.getCategoryRefs(), serviceCatalog.getCategoryRefs()) && Objects.equals(this.relatedParty, serviceCatalog.relatedParty) && Objects.equals(this.validFor, serviceCatalog.validFor) && Objects.equals(this.baseType, serviceCatalog.baseType) && Objects.equals(this.schemaLocation, serviceCatalog.schemaLocation) && Objects.equals(this.type, serviceCatalog.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceCatalog {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.getCategoryRefs())).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public void addCategory(ServiceCategory servcat) {
        if (!this.categoryObj.contains(servcat)) {
            this.categoryObj.add(servcat);
        }
    }
}

