/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.scm633.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.common.model.service.ServiceSpecificationRef;
import org.etsi.osl.tmf.scm633.model.ServiceCategoryRef;
import org.springframework.validation.annotation.Validated;

@Schema(description="ServiceCandidate is an entity that makes a service specification available to a catalog. A ServiceCandidate and its associated service specification may be published - made visible - in any number of service catalogs, or in none. One service specification can be composed of other service specifications. Skipped properties: id,href,lastUpdate")
@Validated
public class ServiceCandidateUpdate {
    @JsonProperty(value="description")
    protected String description = null;
    @JsonProperty(value="lifecycleStatus")
    protected String lifecycleStatus = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="version")
    protected String version = null;
    @JsonProperty(value="category")
    @Valid
    protected List<ServiceCategoryRef> category = null;
    @JsonProperty(value="serviceSpecification")
    protected ServiceSpecificationRef serviceSpecification = null;
    @JsonProperty(value="validFor")
    protected TimePeriod validFor = null;
    @JsonProperty(value="@baseType")
    protected String baseType = null;
    @JsonProperty(value="@schemaLocation")
    protected String schemaLocation = null;
    @JsonProperty(value="@type")
    protected String type = null;

    public ServiceCandidateUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of this REST resource")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ServiceCandidateUpdate lifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
        return this;
    }

    @Schema(description="Used to indicate the current lifecycle status of the service candidate.")
    public String getLifecycleStatus() {
        return this.lifecycleStatus;
    }

    public void setLifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
    }

    public ServiceCandidateUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name given to this REST resource")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ServiceCandidateUpdate version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="the version of service candidate")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ServiceCandidateUpdate category(List<ServiceCategoryRef> category) {
        this.category = category;
        return this;
    }

    public ServiceCandidateUpdate addCategoryItem(ServiceCategoryRef categoryItem) {
        if (this.category == null) {
            this.category = new ArrayList<ServiceCategoryRef>();
        }
        this.category.add(categoryItem);
        return this;
    }

    @Schema(description="List of categories for this candidate")
    @Valid
    public List<ServiceCategoryRef> getCategory() {
        return this.category;
    }

    public void setCategory(List<ServiceCategoryRef> category) {
        this.category = category;
    }

    public ServiceCandidateUpdate serviceSpecification(ServiceSpecificationRef serviceSpecification) {
        this.serviceSpecification = serviceSpecification;
        return this;
    }

    @Schema(description="The service specification implied by this candidate")
    @Valid
    public ServiceSpecificationRef getServiceSpecification() {
        return this.serviceSpecification;
    }

    public void setServiceSpecification(ServiceSpecificationRef serviceSpecification) {
        this.serviceSpecification = serviceSpecification;
    }

    public ServiceCandidateUpdate validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="The period for which this REST resource is valid")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ServiceCandidateUpdate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ServiceCandidateUpdate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ServiceCandidateUpdate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceCandidateUpdate serviceCandidateUpdate = (ServiceCandidateUpdate)o;
        return Objects.equals(this.description, serviceCandidateUpdate.description) && Objects.equals(this.lifecycleStatus, serviceCandidateUpdate.lifecycleStatus) && Objects.equals(this.name, serviceCandidateUpdate.name) && Objects.equals(this.version, serviceCandidateUpdate.version) && Objects.equals(this.category, serviceCandidateUpdate.category) && Objects.equals(this.serviceSpecification, serviceCandidateUpdate.serviceSpecification) && Objects.equals(this.validFor, serviceCandidateUpdate.validFor) && Objects.equals(this.baseType, serviceCandidateUpdate.baseType) && Objects.equals(this.schemaLocation, serviceCandidateUpdate.schemaLocation) && Objects.equals(this.type, serviceCandidateUpdate.type);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.lifecycleStatus, this.name, this.version, this.category, this.serviceSpecification, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceCandidateUpdate {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    serviceSpecification: ").append(this.toIndentedString(this.serviceSpecification)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

